package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseSettlementEntity;
import com.ejianc.business.settlementmanage.bean.SettlementFinalizedEntity;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseSettlementService;
import com.ejianc.business.settlementmanage.service.ISettlementFinalizedService;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/cost/")
public class CostApi {
    @Autowired
    private IMaterialPurchaseSettlementService iMaterialPurchaseSettlementService;

    @Autowired
    private IMachinerySettlementService iMachinerySettlementService;

    @Autowired
    private ISettlementFinalizedService settlementFinalizedService;
    /**
     * 成本核算:部品部件及材料费
     */
    @RequestMapping(value = "queryCostaccountPartmaterial", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountPartmaterial(@RequestParam Long projectId,@RequestParam String time) {
        QueryWrapper<MaterialPurchaseSettlementEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.le("create_time",time);
        List<MaterialPurchaseSettlementEntity> list = iMaterialPurchaseSettlementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            MaterialPurchaseSettlementEntity MaterialPurchaseSettlement = list.get(i);
            if(MaterialPurchaseSettlement.getIntaxSummaryAmount() != null){
                total = total.add(MaterialPurchaseSettlement.getIntaxSummaryAmount());
            }
        }
        return CommonResponse.success("查询详情数据成功！",total);
    }

    /**
     * 成本核算:机械费
     */
    @RequestMapping(value = "queryCostaccountMechanical", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountMechanical(@RequestParam Long projectId,@RequestParam String time) {
        QueryWrapper<MachinerySettlementEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.le("create_time",time);
        List<MachinerySettlementEntity> list = iMachinerySettlementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            MachinerySettlementEntity MachinerySettlement = list.get(i);
            if(MachinerySettlement.getIntaxMonthlyAmount() != null){
                total = total.add(MachinerySettlement.getIntaxMonthlyAmount());
            }
        }
        return CommonResponse.success("查询详情数据成功！",total);
    }

    /**
     * 项目部商务经理月度报告：竣工工程结算额
     */
    @RequestMapping(value = "queryProjectreportSettlement", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryProjectreportSettlement(@RequestParam Long contractId,@RequestParam String time) {
        QueryWrapper<SettlementFinalizedEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("contract_id",contractId);
        queryWrapper.le("create_time",time);
        List<SettlementFinalizedEntity> list = settlementFinalizedService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            SettlementFinalizedEntity SettlementFinalized = list.get(i);
            if(SettlementFinalized.getSettlementValue() != null){
                total = total.add(SettlementFinalized.getSettlementValue());
            }
        }
        return CommonResponse.success("查询详情数据成功！",total);
    }
}
