package com.ejianc.business.settlementmanage.controller.api;

import com.ejianc.business.settlementmanage.service.ISettlementCountersignService;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/settlementCountersign")
public class SettlementApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementCountersignService settlementCountersignService;


    /**
     * 根据合同id查询 总包结算会审会签记录表
     * @Description querySettleById
     *  根据创建时间倒序,取最新生效的一条数据,成本管理使用
     */
    @RequestMapping(value = "/querySettleById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCountersignVO> querySettleById(Long contractId) {
        SettlementCountersignVO settlementCountersignVO = settlementCountersignService.querySettleById(contractId);
        return CommonResponse.success("查询详情数据成功！",settlementCountersignVO);
    }
}
