package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookQuantityBasDeatilEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookQuantityBasDeatilService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookQuantityBasDeatilVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 工程分包结算书-工程量清单结算表
 */
@Controller
@RequestMapping("settlementBookStatementExport")
public class ExcelSettlementBookStatementController {

    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;

    @Autowired
    private IOutcontractApi outcontractApi;

    /**
     * 工程量清单结算表导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportStateFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void exportStateFromPage(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        List<SettlementBookStatementDetailVO> records = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SettlementBookStatementDetailVO statementDetailVO = list.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
                records.add(statementDetailVO);
                if(statementDetailVO.getChildren()!=null&&statementDetailVO.getChildren().size()>0){
                    this.splitList(statementDetailVO.getChildren(),records);
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    /**
     * 导出遍历加上所有子表
     * @param list
     * @param records
     */
    private void splitList(List<SettlementBookStatementDetailVO> list,List<SettlementBookStatementDetailVO> records) {
        for(SettlementBookStatementDetailVO vo : list){
            String source = vo.getSource();
            if("1".equals(source)){//来源：1合同内 2合同外
                source = "合同内";
            }else if("2".equals(source)){
                source = "合同外";
            }
            vo.setSource(source);
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }
    }

    /**
     * 工程量清单结算表导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportStateFromDataBase", method = RequestMethod.POST)
    @ResponseBody
    public void exportStateFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper<SettlementBookStatementDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", settlementBookVO.getId());
        queryWrapper.eq("dr", 0);
        List<SettlementBookStatementDetailEntity> list = statementDetailService.list(queryWrapper);
        List<SettlementBookStatementDetailVO> statementDetailVOList = BeanMapper.mapList(list, SettlementBookStatementDetailVO.class);
        if (statementDetailVOList != null && statementDetailVOList.size() > 0) {
            for (int i = 0; i < statementDetailVOList.size(); i++) {
                SettlementBookStatementDetailVO statementDetailVO = statementDetailVOList.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    /**
     * 工程量清单结算表导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/stateExcelDown")
    @ResponseBody
    public void stateExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SettlementBookStatementDetail-import.xlsx", "工程量清单结算表模板");
    }

    /**
     * 工程量清单结算表导入
     */
    @RequestMapping(value = "/statementExcelUpload", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> statementExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId,String settlementBookStatement) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SettlementBookStatementDetailVO> successList = new ArrayList<>();
        List<SettlementBookStatementDetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, SettlementBookStatementDetailVO> map = new HashMap<>();
        HashMap<String, String> diffMap = new HashMap<>();

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //工程量清单结算表（工程量依据带入）
                List<SettlementBookStatementDetailVO> grabVos = JSON.parseArray(settlementBookStatement, SettlementBookStatementDetailVO.class);
                Map<String, SettlementBookStatementDetailVO> grabMap = new HashMap<>();
                for (int i = 0; i < grabVos.size(); i++) {
                    SettlementBookStatementDetailVO grabVo = grabVos.get(i);
                    String grapListingCode = grabVo.getListingCode();
                    String grapUnits = grabVo.getUnits();
                    String grapPartProjectName = grabVo.getPartProjectName();
                    String grapKey = grapListingCode + grapUnits + grapPartProjectName;
                    grabMap.put(grapKey, grabVo);
                }

                for (int i = 1; i < result.size(); i++) {
                    StringBuffer errorBuffer = new StringBuffer();
                    List<String> datas = result.get(i);

                    String listingCode = datas.get(0);//清单编码
                    String partProjectName = datas.get(1);//分部分项工程名称
                    String units = datas.get(2);//单位
                    String quantities = datas.get(3);//工程量
                    String extaxUnitprice = datas.get(4);//合同单价(除税)
                    String intaxUnitprice = datas.get(5);//合同单价(含税)
                    String exsettlementUnitprice = datas.get(6);// 结算单价(除税)
                    String insettlementUnitprice = datas.get(7);// 结算单价(含税)
                    String extaxAddition = datas.get(8);// 合价(除税)
                    String intaxAddition = datas.get(9);// 合价(含税)
                    String source = datas.get(10);// 来源
                    String remarks = datas.get(11);// 备注

                    SettlementBookStatementDetailVO statementDetailVO = new SettlementBookStatementDetailVO();
                    statementDetailVO.setId(IdWorker.getId());//id
                    statementDetailVO.setSort(Long.valueOf(i));
                    statementDetailVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    statementDetailVO.setUnits(units);//单位
                    statementDetailVO.setRemarks(remarks);// 备注

                    //固定列校验
                    String currentKey = listingCode + units + partProjectName;
                    if(grabMap.get(currentKey) == null){
                        statementDetailVO.setErrorMsg("清单编码、分部分项工程名称、单位，为工程量依据带入，不允许修改！");
                        errorBuffer.append("清单编码、分部分项工程名称、单位、为工程量依据带入，不允许修改！");

                        statementDetailVO.setListingCode(listingCode);
                        statementDetailVO.setUnits(units);
                        statementDetailVO.setPartProjectName(partProjectName);
                        errorList.add(statementDetailVO);
                        continue;
                    }else{
                        SettlementBookStatementDetailVO grabVo = grabMap.get(currentKey);
                        //以系统抓取的数据为准
                        statementDetailVO.setListingCode(grabVo.getListingCode());//清单编码
                        statementDetailVO.setPartProjectName(grabVo.getPartProjectName());//分部分项工程名称
                        statementDetailVO.setUnits(grabVo.getUnits());//单位
                        statementDetailVO.setQuantities(grabVo.getQuantities());//工程量
                        statementDetailVO.setSource(grabVo.getSource());//来源

                        //设置innercode
                        statementDetailVO.setInnercode(listingCode);//清单编码确定唯一性
                        if ("01".equals(listingCode) && partProjectName != null && partProjectName.contains("装饰")) {
                            statementDetailVO.setInnercode("a1");
                        }
                        //判断是否是装饰工程的子节点编码
                        if (listingCode.length() >= 4) {
                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                            String code = listingCode.substring(0, 4);
                            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                                //若是的话，将内码改为a1xx
                                statementDetailVO.setInnercode("a1" + listingCode.substring(2, listingCode.length()));
                            }
                        }

                        //重复性校验
                        SettlementBookStatementDetailVO mapVO = map.get(statementDetailVO.getInnercode());
                        if (mapVO == null) {
                            map.put(statementDetailVO.getInnercode(), statementDetailVO);
                        } else {
                            statementDetailVO.setErrorMsg("清单编码已存在！");
                            errorBuffer.append("清单编码已存在！");
                        }

                        //格式校验：结算除税单价、结算含税单价
                        if(StringUtils.isBlank(exsettlementUnitprice)){
                            statementDetailVO.setErrorMsg("'结算除税单价'不能为空");
                            errorBuffer.append("'结算除税单价'不能为空");
                        }else {
                            if (!NumberUtil.isNumber(exsettlementUnitprice)) {
                                statementDetailVO.setErrorMsg("'结算除税单价'格式错误");
                                errorBuffer.append("'结算除税单价'格式错误");
                            } else {
                                statementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                            }
                        }

                        if(StringUtils.isBlank(insettlementUnitprice)){
                            statementDetailVO.setErrorMsg("'结算含税单价'不能为空");
                            errorBuffer.append("'结算含税单价'不能为空");
                        }else {
                            if (!NumberUtil.isNumber(insettlementUnitprice)) {
                                statementDetailVO.setErrorMsg("'结算含税单价'格式错误");
                                errorBuffer.append("'结算含税单价'格式错误");
                            } else {
                                statementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                            }
                        }

                        if("合同内".equals(source)){//合同内
                            //合同价：如果为空，通过接口查询
                            CommonResponse<List<OutcontractSubcontractUnitPriceVO>> outcontractResp = outcontractApi.queryListBycontractIdAndCode(contractId, listingCode);
                            List<OutcontractSubcontractUnitPriceVO> priceVOS = outcontractResp.getData();
                            if (priceVOS != null && priceVOS.size() > 0) {
                                OutcontractSubcontractUnitPriceVO priceVO = priceVOS.get(0);
                                BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();//综合单价
                                BigDecimal tax = priceVO.getTax();//税金

                                if (comprehensiveUnitPrice != null) {
                                    if (tax != null) {
                                        //合同单价除税
                                        BigDecimal extaxUnitpriceB = comprehensiveUnitPrice.subtract(tax);//综合单价-税金
                                        statementDetailVO.setExtaxUnitprice(extaxUnitpriceB);
                                    } else {
                                        statementDetailVO.setExtaxUnitprice(comprehensiveUnitPrice);
                                    }
                                }
                                BigDecimal intaxUnitpriceB = comprehensiveUnitPrice;//合同单价含税
                                statementDetailVO.setIntaxUnitprice(intaxUnitpriceB);
                            }

                            if(!StringUtils.isBlank(extaxUnitprice)){//合同单价(除税)
                              if(!NumberUtil.isNumber(extaxUnitprice)){
                                    statementDetailVO.setErrorMsg("'合同单价(除税)'格式错误");
                                    errorBuffer.append("'合同单价(除税)'格式错误");
                                }else{
                                    statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                                }
                            }

                            if(!StringUtils.isBlank(intaxUnitprice)){
                                if(!NumberUtil.isNumber(intaxUnitprice)){
                                    statementDetailVO.setErrorMsg("'合同单价(含税)'格式错误");
                                    errorBuffer.append("'合同单价(含税)'格式错误");
                                }else{
                                    statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                                }
                            }
                        }else {//合同外
                            if(StringUtils.isBlank(extaxUnitprice)){//合同单价(除税)
//                                statementDetailVO.setErrorMsg("'合同单价(除税)'不能为空！");
//                                errorBuffer.append("'合同单价(除税)'不能为空！");
                            }else{
                                if(!NumberUtil.isNumber(extaxUnitprice)){
                                    statementDetailVO.setErrorMsg("'合同单价(除税)'格式错误");
                                    errorBuffer.append("'合同单价(除税)'格式错误");
                                }else{
                                    statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                                }
                            }

                            if(StringUtils.isBlank(intaxUnitprice)){
//                                statementDetailVO.setErrorMsg("'合同单价(含税)'不能为空！");
//                                errorBuffer.append("'合同单价(含税)'不能为空！");
                            }else{
                                if(!NumberUtil.isNumber(intaxUnitprice)){
                                    statementDetailVO.setErrorMsg("'合同单价(含税)'格式错误");
                                    errorBuffer.append("'合同单价(含税)'格式错误");
                                }else{
                                    statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                                }
                            }
                        }

                        //结算单价除税
                        BigDecimal exsettlementUnitpriceB = statementDetailVO.getExsettlementUnitprice();
                        //结算单价含税
                        BigDecimal insettlementUnitpriceB = statementDetailVO.getInsettlementUnitprice();
                        //工程量
                        BigDecimal quantitiesB = statementDetailVO.getQuantities();
                        if(StringUtils.isBlank(extaxAddition)){
                            if(exsettlementUnitpriceB != null && quantitiesB != null){
                                BigDecimal exTotal = exsettlementUnitpriceB.multiply(quantitiesB);
                                statementDetailVO.setExtaxAddition(exTotal);
                            }
                        }else{
                            if(!NumberUtil.isNumber(extaxAddition)){
                                statementDetailVO.setErrorMsg("'合价(除税)'格式错误");
                                errorBuffer.append("'合价(除税)'格式错误");
                            }else{
                                statementDetailVO.setExtaxAddition(new BigDecimal(extaxAddition));
                            }
                        }

                        if(StringUtils.isBlank(intaxAddition)){
                            if(insettlementUnitpriceB != null && quantitiesB != null){
                                BigDecimal inTotal = insettlementUnitpriceB.multiply(quantitiesB);
                                statementDetailVO.setIntaxAddition(inTotal);
                            }
                        }else{
                            if(!NumberUtil.isNumber(intaxAddition)){
                                statementDetailVO.setErrorMsg("'合价(含税)'格式错误");
                                errorBuffer.append("'合价(含税)'格式错误");
                            }else{
                                statementDetailVO.setIntaxAddition(new BigDecimal(intaxAddition));
                            }
                        }
                    }

                    if (errorBuffer.length() == 0) {
                        successList.add(statementDetailVO);
                    } else {
                        errorList.add(statementDetailVO);
                    }
                }
            }
        }
        //按子目编码排序
        Collections.sort(successList, new Comparator<SettlementBookStatementDetailVO>() {
            @Override
            public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                return (o1.getListingCode() + o1.getPartProjectName()).compareTo(o2.getListingCode() + o2.getPartProjectName());
            }
        });

        //设置tid和tpid
        List<SettlementBookStatementDetailVO> resList = setTidAndTpid(successList, map);

        //构建树
        resList = createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            SettlementBookStatementDetailVO statementDetailVO = vos.get(i);
            //设置父级id
            String innercode = statementDetailVO.getInnercode();
            Long pid = null;
            if (innercode.length() == 2) {
                //最上级
            } else if (innercode.length() == 4) {
                String pcode = innercode.substring(0, 2);
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercode.length() == 6) {
                String pcode = innercode.substring(0, 4);
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercode.length() > 6) {
                String pcode = innercode.substring(0, 6);
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                statementDetailVO.setTpid(pid.toString());
            } else {
                statementDetailVO.setTpid("");
            }
        }

        return vos;
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        List<SettlementBookStatementDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SettlementBookStatementDetailVO> listMap = new HashMap<>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SettlementBookStatementDetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = (List<SettlementBookStatementDetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

}
