package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.SettlementCountersignMapper;
import com.ejianc.business.settlementmanage.bean.SettlementCountersignEntity;
import com.ejianc.business.settlementmanage.service.ISettlementCountersignService;

import java.util.ArrayList;
import java.util.List;

/**
 * 总包结算会审会签记录表-主表
 * 
 * @author generator
 * 
 */
@Service("settlementCountersignService")
public class SettlementCountersignServiceImpl extends BaseServiceImpl<SettlementCountersignMapper, SettlementCountersignEntity> implements ISettlementCountersignService{

    @Override
    public SettlementCountersignVO querySettleById(Long contractId) {
        List<Integer> status = new ArrayList<>();
        status.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        status.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<SettlementCountersignEntity> lambda = Wrappers.<SettlementCountersignEntity>lambdaQuery();
        lambda.eq(SettlementCountersignEntity::getContractId, contractId);
        lambda.in(SettlementCountersignEntity::getBillState, status );
        lambda.orderByDesc(SettlementCountersignEntity::getCreateTime );
        List<SettlementCountersignEntity> settlementCountersignList = super.list(lambda);
        SettlementCountersignVO settlementCountersignVO = null;
        if(CollectionUtils.isNotEmpty(settlementCountersignList)){
            SettlementCountersignEntity settlementCountersignEntity = settlementCountersignList.get(0);
            settlementCountersignVO = BeanMapper.map(settlementCountersignEntity,SettlementCountersignVO.class);
        }
        return settlementCountersignVO;
    }
}
