/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"settlementBookStatementExport"})
public class ExcelSettlementBookStatementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;
    @Autowired
    private IOutcontractApi outcontractApi;

    @RequestMapping(value={"/exportStateFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromPage(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        ArrayList<SettlementBookStatementDetailVO> records = new ArrayList<SettlementBookStatementDetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = list.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
                records.add(statementDetailVO);
                if (statementDetailVO.getChildren() == null || statementDetailVO.getChildren().size() <= 0) continue;
                this.splitList(statementDetailVO.getChildren(), records);
            }
        }
        HashMap<String, ArrayList<SettlementBookStatementDetailVO>> beans = new HashMap<String, ArrayList<SettlementBookStatementDetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    private void splitList(List<SettlementBookStatementDetailVO> list, List<SettlementBookStatementDetailVO> records) {
        for (SettlementBookStatementDetailVO vo : list) {
            String source = vo.getSource();
            if ("1".equals(source)) {
                source = "\u5408\u540c\u5185";
            } else if ("2".equals(source)) {
                source = "\u5408\u540c\u5916";
            }
            vo.setSource(source);
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }

    @RequestMapping(value={"/exportStateFromDataBase"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)settlementBookVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.statementDetailService.list((Wrapper)queryWrapper);
        List statementDetailVOList = BeanMapper.mapList((Iterable)list, SettlementBookStatementDetailVO.class);
        if (statementDetailVOList != null && statementDetailVOList.size() > 0) {
            for (int i = 0; i < statementDetailVOList.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = (SettlementBookStatementDetailVO)((Object)statementDetailVOList.get(i));
                statementDetailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/stateExcelDown"})
    @ResponseBody
    public void stateExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SettlementBookStatementDetail-import.xlsx", (String)"\u5de5\u7a0b\u91cf\u6e05\u5355\u7ed3\u7b97\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/statementExcelUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> statementExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId, String settlementBookStatement) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SettlementBookStatementDetailVO> successList = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<SettlementBookStatementDetailVO> errorList = new ArrayList<SettlementBookStatementDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, SettlementBookStatementDetailVO> map = new HashMap<String, SettlementBookStatementDetailVO>();
        HashMap diffMap = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            int i;
            List grabVos = JSON.parseArray((String)settlementBookStatement, SettlementBookStatementDetailVO.class);
            HashMap<String, SettlementBookStatementDetailVO> grabMap = new HashMap<String, SettlementBookStatementDetailVO>();
            for (i = 0; i < grabVos.size(); ++i) {
                SettlementBookStatementDetailVO grabVo = (SettlementBookStatementDetailVO)((Object)grabVos.get(i));
                String grapListingCode = grabVo.getListingCode();
                String grapUnits = grabVo.getUnits();
                String grapPartProjectName = grabVo.getPartProjectName();
                String grapKey = grapListingCode + grapUnits + grapPartProjectName;
                grabMap.put(grapKey, grabVo);
            }
            for (i = 1; i < result.size(); ++i) {
                SettlementBookStatementDetailVO mapVO;
                String code;
                StringBuffer errorBuffer = new StringBuffer();
                List datas = (List)result.get(i);
                String listingCode = (String)datas.get(0);
                String partProjectName = (String)datas.get(1);
                String units = (String)datas.get(2);
                String quantities = (String)datas.get(3);
                String extaxUnitprice = (String)datas.get(4);
                String intaxUnitprice = (String)datas.get(5);
                String exsettlementUnitprice = (String)datas.get(6);
                String insettlementUnitprice = (String)datas.get(7);
                String extaxAddition = (String)datas.get(8);
                String intaxAddition = (String)datas.get(9);
                String source = (String)datas.get(10);
                String remarks = (String)datas.get(11);
                SettlementBookStatementDetailVO statementDetailVO = new SettlementBookStatementDetailVO();
                statementDetailVO.setId(IdWorker.getId());
                statementDetailVO.setSort(Long.valueOf(i));
                statementDetailVO.setTid(String.valueOf(IdWorker.getId()));
                statementDetailVO.setUnits(units);
                statementDetailVO.setRemarks(remarks);
                String currentKey = listingCode + units + partProjectName;
                if (grabMap.get(currentKey) == null) {
                    statementDetailVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u3001\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u540d\u79f0\u3001\u5355\u4f4d\uff0c\u4e3a\u5de5\u7a0b\u91cf\u4f9d\u636e\u5e26\u5165\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
                    errorBuffer.append("\u6e05\u5355\u7f16\u7801\u3001\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u540d\u79f0\u3001\u5355\u4f4d\u3001\u4e3a\u5de5\u7a0b\u91cf\u4f9d\u636e\u5e26\u5165\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
                    statementDetailVO.setListingCode(listingCode);
                    statementDetailVO.setUnits(units);
                    statementDetailVO.setPartProjectName(partProjectName);
                    errorList.add(statementDetailVO);
                    continue;
                }
                SettlementBookStatementDetailVO grabVo = (SettlementBookStatementDetailVO)((Object)grabMap.get(currentKey));
                statementDetailVO.setListingCode(grabVo.getListingCode());
                statementDetailVO.setPartProjectName(grabVo.getPartProjectName());
                statementDetailVO.setUnits(grabVo.getUnits());
                statementDetailVO.setQuantities(grabVo.getQuantities());
                statementDetailVO.setSource(grabVo.getSource());
                statementDetailVO.setInnercode(listingCode);
                if ("01".equals(listingCode) && partProjectName != null && partProjectName.contains("\u88c5\u9970")) {
                    statementDetailVO.setInnercode("a1");
                }
                if (listingCode.length() >= 4 && ("0111".equals(code = listingCode.substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
                    statementDetailVO.setInnercode("a1" + listingCode.substring(2, listingCode.length()));
                }
                if ((mapVO = map.get(statementDetailVO.getInnercode())) == null) {
                    map.put(statementDetailVO.getInnercode(), statementDetailVO);
                } else {
                    statementDetailVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                    errorBuffer.append("\u6e05\u5355\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                }
                if (StringUtils.isBlank((CharSequence)exsettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u9664\u7a0e\u5355\u4ef7'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u7ed3\u7b97\u9664\u7a0e\u5355\u4ef7'\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!NumberUtil.isNumber((String)exsettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u9664\u7a0e\u5355\u4ef7'\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("'\u7ed3\u7b97\u9664\u7a0e\u5355\u4ef7'\u683c\u5f0f\u9519\u8bef");
                } else {
                    statementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                }
                if (StringUtils.isBlank((CharSequence)insettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u542b\u7a0e\u5355\u4ef7'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u7ed3\u7b97\u542b\u7a0e\u5355\u4ef7'\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!NumberUtil.isNumber((String)insettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u542b\u7a0e\u5355\u4ef7'\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("'\u7ed3\u7b97\u542b\u7a0e\u5355\u4ef7'\u683c\u5f0f\u9519\u8bef");
                } else {
                    statementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                }
                if ("\u5408\u540c\u5185".equals(source)) {
                    CommonResponse outcontractResp = this.outcontractApi.queryListBycontractIdAndCode(contractId, listingCode);
                    List priceVOS = (List)outcontractResp.getData();
                    if (priceVOS != null && priceVOS.size() > 0) {
                        OutcontractSubcontractUnitPriceVO priceVO = (OutcontractSubcontractUnitPriceVO)priceVOS.get(0);
                        BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();
                        BigDecimal tax = priceVO.getTax();
                        if (comprehensiveUnitPrice != null) {
                            if (tax != null) {
                                BigDecimal extaxUnitpriceB = comprehensiveUnitPrice.subtract(tax);
                                statementDetailVO.setExtaxUnitprice(extaxUnitpriceB);
                            } else {
                                statementDetailVO.setExtaxUnitprice(comprehensiveUnitPrice);
                            }
                        }
                        BigDecimal intaxUnitpriceB = comprehensiveUnitPrice;
                        statementDetailVO.setIntaxUnitprice(intaxUnitpriceB);
                    }
                    if (!StringUtils.isBlank((CharSequence)extaxUnitprice)) {
                        if (!NumberUtil.isNumber((String)extaxUnitprice)) {
                            statementDetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7(\u9664\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                            errorBuffer.append("'\u5408\u540c\u5355\u4ef7(\u9664\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                        } else {
                            statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)intaxUnitprice)) {
                        if (!NumberUtil.isNumber((String)intaxUnitprice)) {
                            statementDetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7(\u542b\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                            errorBuffer.append("'\u5408\u540c\u5355\u4ef7(\u542b\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                        } else {
                            statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                        }
                    }
                } else {
                    if (!StringUtils.isBlank((CharSequence)extaxUnitprice)) {
                        if (!NumberUtil.isNumber((String)extaxUnitprice)) {
                            statementDetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7(\u9664\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                            errorBuffer.append("'\u5408\u540c\u5355\u4ef7(\u9664\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                        } else {
                            statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)intaxUnitprice)) {
                        if (!NumberUtil.isNumber((String)intaxUnitprice)) {
                            statementDetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7(\u542b\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                            errorBuffer.append("'\u5408\u540c\u5355\u4ef7(\u542b\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                        } else {
                            statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                        }
                    }
                }
                BigDecimal exsettlementUnitpriceB = statementDetailVO.getExsettlementUnitprice();
                BigDecimal insettlementUnitpriceB = statementDetailVO.getInsettlementUnitprice();
                BigDecimal quantitiesB = statementDetailVO.getQuantities();
                if (StringUtils.isBlank((CharSequence)extaxAddition)) {
                    if (exsettlementUnitpriceB != null && quantitiesB != null) {
                        BigDecimal exTotal = exsettlementUnitpriceB.multiply(quantitiesB);
                        statementDetailVO.setExtaxAddition(exTotal);
                    }
                } else if (!NumberUtil.isNumber((String)extaxAddition)) {
                    statementDetailVO.setErrorMsg("'\u5408\u4ef7(\u9664\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("'\u5408\u4ef7(\u9664\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                } else {
                    statementDetailVO.setExtaxAddition(new BigDecimal(extaxAddition));
                }
                if (StringUtils.isBlank((CharSequence)intaxAddition)) {
                    if (insettlementUnitpriceB != null && quantitiesB != null) {
                        BigDecimal inTotal = insettlementUnitpriceB.multiply(quantitiesB);
                        statementDetailVO.setIntaxAddition(inTotal);
                    }
                } else if (!NumberUtil.isNumber((String)intaxAddition)) {
                    statementDetailVO.setErrorMsg("'\u5408\u4ef7(\u542b\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("'\u5408\u4ef7(\u542b\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                } else {
                    statementDetailVO.setIntaxAddition(new BigDecimal(intaxAddition));
                }
                if (errorBuffer.length() == 0) {
                    successList.add(statementDetailVO);
                    continue;
                }
                errorList.add(statementDetailVO);
            }
        }
        Collections.sort(successList, new Comparator<SettlementBookStatementDetailVO>(){

            @Override
            public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                return (o1.getListingCode() + o1.getPartProjectName()).compareTo(o2.getListingCode() + o2.getPartProjectName());
            }
        });
        List<SettlementBookStatementDetailVO> resList = this.setTidAndTpid(successList, map);
        resList = ExcelSettlementBookStatementController.createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            SettlementBookStatementDetailVO statementDetailVO = vos.get(i);
            String innercode = statementDetailVO.getInnercode();
            Long pid = null;
            if (innercode.length() != 2) {
                String pcode;
                if (innercode.length() == 4) {
                    pcode = innercode.substring(0, 2);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() == 6) {
                    pcode = innercode.substring(0, 4);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() > 6) {
                    pcode = innercode.substring(0, 6);
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                statementDetailVO.setTpid(pid.toString());
                continue;
            }
            statementDetailVO.setTpid("");
        }
        return vos;
    }

    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        ArrayList<SettlementBookStatementDetailVO> resp = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SettlementBookStatementDetailVO> listMap = new HashMap<String, SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookStatementDetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = (SettlementBookStatementDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SettlementBookStatementDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }
}

