package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/settlementBookStatementDetail")
public class SettlementBookApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookService settlementBookService;//工程分包结算书主表service

    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;//工程分包结算书子表-程量清单结算表service


    /**
     * @Description queryActualCost
     *
     * 使用：成本管理-项目月度成本分析报告-子表本期实际成本
     * 数据来源：结算管理-工程分包结算书-工程量清单结算表
     */
    @RequestMapping(value = "/queryActualCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SettlementBookStatementDetailVO>> queryActualCost(Long contractId, String subitemCode, String subitemName) {
        QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("contract_id",contractId);
        queryWrapper.eq("dr",0);
        queryWrapper.in("bill_state","1", "3");
        List<SettlementBookEntity> mList = settlementBookService.list(queryWrapper);

        List<SettlementBookStatementDetailVO> resList = new ArrayList<>();
        if(mList != null && mList.size() > 0){
            for (SettlementBookEntity item:
                    mList) {
                QueryWrapper<SettlementBookStatementDetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                statementDetailQueryWrapper.eq("mid", item.getId());
                statementDetailQueryWrapper.eq("listing_code",subitemCode);
                statementDetailQueryWrapper.eq("part_project_name",subitemName);
                statementDetailQueryWrapper.eq("dr",0);
                List<SettlementBookStatementDetailEntity> detailList = settlementBookStatementDetailService.list(statementDetailQueryWrapper);

                if(detailList != null && detailList.size() > 0){
                    for (int i = 0; i < detailList.size(); i++) {
                        SettlementBookStatementDetailEntity detailEntity = detailList.get(i);
                        //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                        SettlementBookStatementDetailVO detailVO = BeanMapper.map(detailEntity, SettlementBookStatementDetailVO.class);
                        resList.add(detailVO);
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", resList);
    }
}
