/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseSettlementEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementFinalizedEntity;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseSettlementService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementFinalizedService;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/costmanage/"})
public class CostManageApi {
    @Autowired
    private IMaterialPurchaseSettlementService iMaterialPurchaseSettlementService;
    @Autowired
    private IMachinerySettlementService iMachinerySettlementService;
    @Autowired
    private ISettlementFinalizedService settlementFinalizedService;
    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;

    @RequestMapping(value={"queryCostaccountPartmaterial"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountPartmaterial(Long projectId, String time) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.le((Object)"create_time", (Object)time);
        List list = this.iMaterialPurchaseSettlementService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            MaterialPurchaseSettlementEntity MaterialPurchaseSettlement = (MaterialPurchaseSettlementEntity)((Object)list.get(i));
            if (MaterialPurchaseSettlement.getIntaxSummaryAmount() == null) continue;
            total = total.add(MaterialPurchaseSettlement.getIntaxSummaryAmount());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"queryCostaccountMechanical"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountMechanical(Long projectId, String time) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.le((Object)"create_time", (Object)time);
        List list = this.iMachinerySettlementService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            MachinerySettlementEntity MachinerySettlement = (MachinerySettlementEntity)((Object)list.get(i));
            if (MachinerySettlement.getIntaxMonthlyAmount() == null) continue;
            total = total.add(MachinerySettlement.getIntaxMonthlyAmount());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"queryProjectreportSettlement"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryProjectreportSettlement(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        List list = this.settlementFinalizedService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            SettlementFinalizedEntity SettlementFinalized = (SettlementFinalizedEntity)((Object)list.get(i));
            if (SettlementFinalized.getSettlementValue() == null) continue;
            total = total.add(SettlementFinalized.getSettlementValue());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"querySettlementBookStatement"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> querySettlementBookStatement(Long projectId, String code, String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"listing_code", (Object)code);
        queryWrapper.eq((Object)"part_project_name", (Object)name);
        List list = this.settlementBookStatementDetailService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookStatementDetailEntity SettlementBookStatementDetailEntity2 = (SettlementBookStatementDetailEntity)((Object)list.get(i));
            if (SettlementBookStatementDetailEntity2.getQuantities() == null && SettlementBookStatementDetailEntity2.getIntaxUnitprice() == null && SettlementBookStatementDetailEntity2.getIntaxAddition() == null) continue;
            total = total.add(SettlementBookStatementDetailEntity2.getQuantities());
            total = total.add(SettlementBookStatementDetailEntity2.getIntaxUnitprice());
            total = total.add(SettlementBookStatementDetailEntity2.getIntaxAddition());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }
}

