/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.utils.MonthUtil;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/settlementBookStatementDetail"})
public class SettlementBookApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookService settlementBookService;
    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;

    @RequestMapping(value={"/queryActualCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SettlementBookStatementDetailVO>> queryActualCost(Long projectId, String subitemCode, String section, String reportingMonth) {
        ArrayList<SettlementBookStatementDetailVO> resList = new ArrayList<SettlementBookStatementDetailVO>();
        if (StringUtils.isBlank((CharSequence)reportingMonth)) {
            return CommonResponse.error((String)"\u62a5\u544a\u6708\u4efd\u4e3a\u7a7a\uff01");
        }
        String[] strArr = reportingMonth.split("-");
        if (strArr.length > 1) {
            String year = strArr[0];
            String month = strArr[1];
            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
            String lastDay = MonthUtil.getLastDayOfMonth(year, month);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)projectId);
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.in((Object)"bill_state", new Object[]{"1", "3"});
            queryWrapper.ge((Object)"create_time", (Object)firstDay);
            queryWrapper.le((Object)"create_time", (Object)lastDay);
            List mList = this.settlementBookService.list((Wrapper)queryWrapper);
            if (mList != null && mList.size() > 0) {
                for (SettlementBookEntity item : mList) {
                    SettlementBookStatementDetailVO detailVO;
                    SettlementBookStatementDetailEntity detailEntity;
                    int i;
                    List detailList;
                    QueryWrapper statementDetailQueryWrapper;
                    String contractType = item.getContractType();
                    String contractTypes = "\u52b3\u52a1\u5206\u5305";
                    String contractTypess = "\u4e13\u4e1a\u5206\u5305";
                    if ("\u52b3\u52a1\u5206\u5305".equals(contractType)) {
                        statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq((Object)"mid", (Object)item.getId());
                        statementDetailQueryWrapper.eq((Object)"listing_code", (Object)subitemCode);
                        statementDetailQueryWrapper.eq((Object)"section", (Object)section);
                        statementDetailQueryWrapper.eq((Object)"dr", (Object)0);
                        detailList = this.settlementBookStatementDetailService.list((Wrapper)statementDetailQueryWrapper);
                        if (detailList == null || detailList.size() <= 0) continue;
                        for (i = 0; i < detailList.size(); ++i) {
                            detailEntity = (SettlementBookStatementDetailEntity)((Object)detailList.get(i));
                            detailVO = (SettlementBookStatementDetailVO)((Object)BeanMapper.map((Object)((Object)detailEntity), SettlementBookStatementDetailVO.class));
                            resList.add(detailVO);
                        }
                        continue;
                    }
                    if (!"\u4e13\u4e1a\u5206\u5305".equals(contractType)) continue;
                    statementDetailQueryWrapper = new QueryWrapper();
                    statementDetailQueryWrapper.eq((Object)"mid", (Object)item.getId());
                    statementDetailQueryWrapper.eq((Object)"listing_code", (Object)subitemCode);
                    statementDetailQueryWrapper.eq((Object)"section", (Object)section);
                    statementDetailQueryWrapper.eq((Object)"dr", (Object)0);
                    detailList = this.settlementBookStatementDetailService.list((Wrapper)statementDetailQueryWrapper);
                    if (detailList == null || detailList.size() <= 0) continue;
                    for (i = 0; i < detailList.size(); ++i) {
                        detailEntity = (SettlementBookStatementDetailEntity)((Object)detailList.get(i));
                        detailVO = (SettlementBookStatementDetailVO)((Object)BeanMapper.map((Object)((Object)detailEntity), SettlementBookStatementDetailVO.class));
                        resList.add(detailVO);
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", resList);
    }
}

