/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"settlementBookOtherExport"})
public class ExcelSettlementBookOtherController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookOtherDetailService otherDetailService;

    @RequestMapping(value={"/exportOtherFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportOtherFromPage(@RequestBody List<SettlementBookOtherDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SettlementBookOtherDetailVO detailVO = list.get(i);
                detailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List<SettlementBookOtherDetailVO>> beans = new HashMap<String, List<SettlementBookOtherDetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookOtherDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/exportOtherFromDataBase"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportOtherFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)settlementBookVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.otherDetailService.list((Wrapper)queryWrapper);
        List detailVOList = BeanMapper.mapList((Iterable)list, SettlementBookOtherDetailVO.class);
        if (detailVOList != null && detailVOList.size() > 0) {
            for (int i = 0; i < detailVOList.size(); ++i) {
                SettlementBookOtherDetailVO detailVO = (SettlementBookOtherDetailVO)((Object)detailVOList.get(i));
                detailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookOtherDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/otherExcelDown"})
    @ResponseBody
    public void otherExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"settlementBookOtherDetail-import.xlsx", (String)"\u5de5\u7a0b\u91cf\u4f9d\u636e\u6a21\u677f");
    }

    @RequestMapping(value={"/otherExcelUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> otherExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SettlementBookOtherDetailVO> successList = new ArrayList<SettlementBookOtherDetailVO>();
        ArrayList<SettlementBookOtherDetailVO> errorList = new ArrayList<SettlementBookOtherDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap map = new HashMap();
        HashMap diffMap = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal numberB;
                List datas = (List)result.get(i);
                StringBuffer errorBuffer = new StringBuffer();
                String sort = (String)datas.get(0);
                String deductionsName = (String)datas.get(1);
                String units = (String)datas.get(2);
                String number = (String)datas.get(3);
                String extaxUnitprice = (String)datas.get(4);
                String intaxUnitprice = (String)datas.get(5);
                String extaxPrice = (String)datas.get(6);
                String intaxPrice = (String)datas.get(7);
                String remarks = (String)datas.get(8);
                SettlementBookOtherDetailVO otherDetailVO = new SettlementBookOtherDetailVO();
                otherDetailVO.setId(IdWorker.getId());
                otherDetailVO.setSort(Long.valueOf(i));
                otherDetailVO.setUnits(units);
                otherDetailVO.setDeductionsName(deductionsName);
                otherDetailVO.setRemarks(remarks);
                if (StringUtils.isBlank((CharSequence)deductionsName)) {
                    otherDetailVO.setErrorMsg("\u6263\u6b3e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("\u6263\u6b3e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    otherDetailVO.setDeductionsName(deductionsName);
                }
                if (StringUtils.isBlank((CharSequence)number)) {
                    otherDetailVO.setErrorMsg("'\u5de5\u7a0b\u91cf'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u5de5\u7a0b\u91cf'\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!NumberUtil.isNumber((String)number)) {
                    otherDetailVO.setErrorMsg("'\u5de5\u7a0b\u91cf'\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("'\u5de5\u7a0b\u91cf'\u683c\u5f0f\u9519\u8bef");
                } else {
                    otherDetailVO.setNumber(new BigDecimal(number));
                }
                if (StringUtils.isBlank((CharSequence)extaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("\u9664\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!NumberUtil.isNumber((String)extaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef");
                } else {
                    otherDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                }
                if (StringUtils.isBlank((CharSequence)intaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!NumberUtil.isNumber((String)intaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef");
                } else {
                    otherDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                }
                if (StringUtils.isBlank((CharSequence)extaxPrice)) {
                    BigDecimal extaxUnitpriceB = otherDetailVO.getExtaxUnitprice();
                    numberB = otherDetailVO.getNumber();
                    if (extaxUnitpriceB != null && numberB != null) {
                        BigDecimal extaxPriceB = extaxUnitpriceB.multiply(numberB);
                        otherDetailVO.setExtaxPrice(extaxPriceB);
                    }
                } else if (!NumberUtil.isNumber((String)extaxPrice)) {
                    otherDetailVO.setErrorMsg("\u9664\u7a0e\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("\u9664\u7a0e\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                } else {
                    otherDetailVO.setExtaxPrice(new BigDecimal(extaxPrice));
                }
                if (StringUtils.isBlank((CharSequence)intaxPrice)) {
                    BigDecimal intaxUnitpriceB = otherDetailVO.getIntaxUnitprice();
                    numberB = otherDetailVO.getNumber();
                    if (intaxUnitpriceB != null && numberB != null) {
                        BigDecimal intaxPriceB = intaxUnitpriceB.multiply(numberB);
                        otherDetailVO.setIntaxPrice(intaxPriceB);
                    }
                } else if (!NumberUtil.isNumber((String)intaxPrice)) {
                    otherDetailVO.setErrorMsg("\u542b\u7a0e\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("\u542b\u7a0e\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                } else {
                    otherDetailVO.setIntaxPrice(new BigDecimal(intaxPrice));
                }
                if (errorBuffer.length() == 0) {
                    successList.add(otherDetailVO);
                    continue;
                }
                errorList.add(otherDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

