/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookQuantityBasDeatilService;
import com.ejianc.business.settlementmanage.vo.SettlementBookQuantityBasDeatilVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"settlementBookBasExport"})
public class ExcelSettlementBookQuantityBasController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookQuantityBasDeatilService basDeatilService;
    @Autowired
    private IOutcontractApi outcontractApi;

    @RequestMapping(value={"/exportBasFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportBasFromPage(@RequestBody List<SettlementBookQuantityBasDeatilVO> list, HttpServletResponse response) {
        ArrayList<SettlementBookQuantityBasDeatilVO> records = new ArrayList<SettlementBookQuantityBasDeatilVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SettlementBookQuantityBasDeatilVO settlementBookQuantityBasDeatilVO = list.get(i);
                settlementBookQuantityBasDeatilVO.setSort(Long.valueOf(i + 1));
                records.add(settlementBookQuantityBasDeatilVO);
                if (settlementBookQuantityBasDeatilVO.getChildren() == null || settlementBookQuantityBasDeatilVO.getChildren().size() <= 0) continue;
                this.splitList(settlementBookQuantityBasDeatilVO.getChildren(), records);
            }
        }
        HashMap<String, ArrayList<SettlementBookQuantityBasDeatilVO>> beans = new HashMap<String, ArrayList<SettlementBookQuantityBasDeatilVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookQuantityBasDetail-export.xlsx", beans, response);
    }

    private void splitList(List<SettlementBookQuantityBasDeatilVO> list, List<SettlementBookQuantityBasDeatilVO> records) {
        for (SettlementBookQuantityBasDeatilVO vo : list) {
            String source = vo.getSource();
            if ("1".equals(source)) {
                source = "\u5408\u540c\u5185";
            } else if ("2".equals(source)) {
                source = "\u5408\u540c\u5916";
            }
            vo.setSource(source);
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }

    @RequestMapping(value={"/exportBasFromDataBase"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportBasFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)settlementBookVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.basDeatilService.list((Wrapper)queryWrapper);
        List basDeatilVOList = BeanMapper.mapList((Iterable)list, SettlementBookQuantityBasDeatilVO.class);
        if (basDeatilVOList != null && basDeatilVOList.size() > 0) {
            for (int i = 0; i < basDeatilVOList.size(); ++i) {
                SettlementBookQuantityBasDeatilVO basDeatilVO = (SettlementBookQuantityBasDeatilVO)((Object)basDeatilVOList.get(i));
                basDeatilVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookQuantityBasDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/basExcelDown"})
    @ResponseBody
    public void basExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SettlementBookQuantityBasDetail-import.xlsx", (String)"\u5de5\u7a0b\u91cf\u4f9d\u636e\u6a21\u677f");
    }

    @RequestMapping(value={"/basExcelUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> basExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SettlementBookQuantityBasDeatilVO> successList = new ArrayList<SettlementBookQuantityBasDeatilVO>();
        ArrayList<SettlementBookQuantityBasDeatilVO> errorList = new ArrayList<SettlementBookQuantityBasDeatilVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, SettlementBookQuantityBasDeatilVO> map = new HashMap<String, SettlementBookQuantityBasDeatilVO>();
        HashMap diffMap = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                SettlementBookQuantityBasDeatilVO mapVO;
                List datas = (List)result.get(i);
                StringBuffer errorBuffer = new StringBuffer();
                String listingCode = (String)datas.get(0);
                String section = (String)datas.get(1);
                String partProjectName = (String)datas.get(2);
                String subitemDesc = (String)datas.get(3);
                String units = (String)datas.get(4);
                String quantities = (String)datas.get(5);
                String calculationProcess = (String)datas.get(6);
                String gist = (String)datas.get(7);
                String source = (String)datas.get(8);
                SettlementBookQuantityBasDeatilVO quantityBasDeatilVO = new SettlementBookQuantityBasDeatilVO();
                quantityBasDeatilVO.setId(IdWorker.getId());
                quantityBasDeatilVO.setSort(Long.valueOf(i));
                quantityBasDeatilVO.setTid(String.valueOf(IdWorker.getId()));
                quantityBasDeatilVO.setUnits(units);
                quantityBasDeatilVO.setSubitemDesc(subitemDesc);
                if (StringUtils.isBlank((CharSequence)listingCode)) {
                    quantityBasDeatilVO.setErrorMsg("'\u6e05\u5355\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u6e05\u5355\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    quantityBasDeatilVO.setListingCode(listingCode);
                }
                if (StringUtils.isBlank((CharSequence)section)) {
                    quantityBasDeatilVO.setErrorMsg("'\u533a\u6bb5'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u533a\u6bb5'\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    quantityBasDeatilVO.setSection(section);
                }
                if (StringUtils.isBlank((CharSequence)partProjectName)) {
                    quantityBasDeatilVO.setErrorMsg("'\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    quantityBasDeatilVO.setPartProjectName(partProjectName);
                }
                if (StringUtils.isBlank((CharSequence)quantities)) {
                    quantityBasDeatilVO.setErrorMsg("'\u5de5\u7a0b\u91cf'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u5de5\u7a0b\u91cf'\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!NumberUtil.isNumber((String)quantities)) {
                    quantityBasDeatilVO.setErrorMsg("'\u5de5\u7a0b\u91cf'\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("'\u5de5\u7a0b\u91cf'\u683c\u5f0f\u9519\u8bef");
                } else {
                    quantityBasDeatilVO.setQuantities(new BigDecimal(quantities));
                }
                if (StringUtils.isBlank((CharSequence)calculationProcess)) {
                    quantityBasDeatilVO.setErrorMsg("'\u8ba1\u7b97\u8fc7\u7a0b'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u8ba1\u7b97\u8fc7\u7a0b'\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    quantityBasDeatilVO.setCalculationProcess(calculationProcess);
                }
                if (StringUtils.isBlank((CharSequence)gist)) {
                    quantityBasDeatilVO.setErrorMsg("'\u4f9d\u636e'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u4f9d\u636e'\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    quantityBasDeatilVO.setGist(gist);
                }
                if (StringUtils.isBlank((CharSequence)source)) {
                    quantityBasDeatilVO.setErrorMsg("'\u6765\u6e90'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorBuffer.append("'\u6765\u6e90'\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (source.equals("\u5408\u540c\u5185") || source.equals("\u5408\u540c\u5916")) {
                    quantityBasDeatilVO.setSource(source);
                } else {
                    quantityBasDeatilVO.setErrorMsg("'\u6765\u6e90'\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
                    errorBuffer.append("'\u6765\u6e90'\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
                }
                if (StringUtils.isNotBlank((CharSequence)listingCode)) {
                    String code;
                    quantityBasDeatilVO.setInnercode(listingCode + "_" + section);
                    if ("01".equals(listingCode) && partProjectName != null && partProjectName.contains("\u88c5\u9970")) {
                        quantityBasDeatilVO.setInnercode("a1_" + quantityBasDeatilVO.getSection());
                    }
                    if (listingCode.length() >= 4 && ("0111".equals(code = listingCode.substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
                        quantityBasDeatilVO.setInnercode("a1" + listingCode.substring(2, listingCode.length()) + "_" + section);
                    }
                    if (listingCode == null || listingCode.length() != 2 && listingCode.length() != 4 && listingCode.length() != 6 && listingCode.length() < 9) {
                        quantityBasDeatilVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5b9a\u683c\u5f0f");
                        errorBuffer.append("\u6e05\u5355\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5b9a\u683c\u5f0f\uff01");
                    }
                    quantityBasDeatilVO.setListingCode(listingCode);
                    quantityBasDeatilVO.setListingCode(listingCode);
                }
                if ("\u5408\u540c\u5185".equals(source)) {
                    CommonResponse outcontractResp = this.outcontractApi.queryListBycontractIdAndCode(contractId, listingCode);
                    if (outcontractResp.getData() == null) {
                        quantityBasDeatilVO.setErrorMsg("'\u6e05\u5355\u7f16\u7801'\u672a\u5728\u5408\u540c\u4e2d\uff01");
                        errorBuffer.append("'\u6e05\u5355\u7f16\u7801'\u672a\u5728\u5408\u540c\u4e2d\uff01");
                    } else {
                        for (int x = 0; x < ((List)outcontractResp.getData()).size(); ++x) {
                            List priceVOS = (List)outcontractResp.getData();
                            if (!((OutcontractSubcontractUnitPriceVO)priceVOS.get(x)).getListCode().equals(listingCode)) {
                                quantityBasDeatilVO.setErrorMsg("'\u6e05\u5355\u7f16\u7801'\u672a\u5728\u5408\u540c\u4e2d\uff01");
                                errorBuffer.append("'\u6e05\u5355\u7f16\u7801'\u672a\u5728\u5408\u540c\u4e2d\uff01");
                                continue;
                            }
                            OutcontractSubcontractUnitPriceVO priceVO = (OutcontractSubcontractUnitPriceVO)priceVOS.get(0);
                            BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();
                            BigDecimal tax = priceVO.getTax();
                            if (comprehensiveUnitPrice != null) {
                                if (tax != null) {
                                    BigDecimal extaxUnitpriceB = comprehensiveUnitPrice.subtract(tax);
                                    quantityBasDeatilVO.setExtaxUnitprice(extaxUnitpriceB);
                                } else {
                                    quantityBasDeatilVO.setExtaxUnitprice(comprehensiveUnitPrice);
                                }
                            }
                            BigDecimal intaxUnitpriceB = comprehensiveUnitPrice;
                            quantityBasDeatilVO.setIntaxUnitprice(intaxUnitpriceB);
                            quantityBasDeatilVO.setPartProjectName(((OutcontractSubcontractUnitPriceVO)priceVOS.get(x)).getProject());
                        }
                    }
                }
                if ((mapVO = map.get(quantityBasDeatilVO.getInnercode())) == null) {
                    if (errorBuffer.length() == 0) {
                        map.put(quantityBasDeatilVO.getInnercode(), quantityBasDeatilVO);
                    }
                } else {
                    quantityBasDeatilVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
                    errorBuffer.append("\u6e05\u5355\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
                }
                if (errorBuffer.length() == 0) {
                    successList.add(quantityBasDeatilVO);
                    continue;
                }
                errorList.add(quantityBasDeatilVO);
            }
        }
        Collections.sort(successList, new Comparator<SettlementBookQuantityBasDeatilVO>(){

            @Override
            public int compare(SettlementBookQuantityBasDeatilVO o1, SettlementBookQuantityBasDeatilVO o2) {
                return (o1.getListingCode() + o1.getSection()).compareTo(o2.getListingCode() + o1.getSection());
            }
        });
        List<SettlementBookQuantityBasDeatilVO> resList = this.setTidAndTpid(successList, map);
        resList = ExcelSettlementBookQuantityBasController.createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<SettlementBookQuantityBasDeatilVO> setTidAndTpid(List<SettlementBookQuantityBasDeatilVO> vos, Map<String, SettlementBookQuantityBasDeatilVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            SettlementBookQuantityBasDeatilVO consdrawbudgetquantityBasDeatilVO = vos.get(i);
            String innercode = consdrawbudgetquantityBasDeatilVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                consdrawbudgetquantityBasDeatilVO.setTpid(pid.toString());
                continue;
            }
            consdrawbudgetquantityBasDeatilVO.setTpid("");
        }
        return vos;
    }

    public static List<SettlementBookQuantityBasDeatilVO> createTreeData(List<SettlementBookQuantityBasDeatilVO> list) {
        ArrayList<SettlementBookQuantityBasDeatilVO> resp = new ArrayList<SettlementBookQuantityBasDeatilVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SettlementBookQuantityBasDeatilVO> listMap = new HashMap<String, SettlementBookQuantityBasDeatilVO>();
        for (SettlementBookQuantityBasDeatilVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookQuantityBasDeatilVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SettlementBookQuantityBasDeatilVO parent = (SettlementBookQuantityBasDeatilVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SettlementBookQuantityBasDeatilVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SettlementBookQuantityBasDeatilVO> children = new ArrayList<SettlementBookQuantityBasDeatilVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SettlementBookQuantityBasDeatilVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private Long setPid(String pcode, Map<String, SettlementBookQuantityBasDeatilVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }
}

