package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookSummaryDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookSummaryDetailService;
import com.ejianc.business.settlementmanage.utils.MonthUtil;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookSumVo;
import com.ejianc.business.settlementmanage.vo.SettlementBookSummaryDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/settlementBookStatementDetail")
public class SettlementBookApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookService settlementBookService;//工程分包结算书主表service

    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;//工程分包结算书子表-程量清单结算表service

    @Autowired
    private ISettlementBookSummaryDetailService iSettlementBookSummaryDetailService;//工程分包结算书子表-汇总表

    /**
     * @Description queryActualCost
     * <p>
     * 使用：成本管理-项目月度成本分析报告-子表本期实际成本
     * 数据来源：结算管理-工程分包结算书-工程量清单结算表
     */
    @RequestMapping(value = "/queryActualCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SettlementBookStatementDetailVO>> queryActualCost(Long projectId, String subitemCode, String section, String reportingMonth) {
        List<SettlementBookStatementDetailVO> resList = new ArrayList<>();

        if (StringUtils.isBlank(reportingMonth)) {
            return CommonResponse.error("报告月份为空！");
        }

        String[] strArr = reportingMonth.split("-");
        if (strArr.length > 1) {
            String year = strArr[0];
            String month = strArr[1];
            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
            String lastDay = MonthUtil.getLastDayOfMonth(year, month);

            QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper();
            queryWrapper.eq("project_id", projectId);
            queryWrapper.eq("dr", 0);
            queryWrapper.in("bill_state", "1", "3");
            queryWrapper.ge("create_time", firstDay);
            queryWrapper.le("create_time", lastDay);
            List<SettlementBookEntity> mList = settlementBookService.list(queryWrapper);

            if (mList != null && mList.size() > 0) {
                for (SettlementBookEntity item :
                        mList) {

                    String contractType = item.getContractType();
                    if ("劳务分包".equals(contractType)) {
                        QueryWrapper<SettlementBookStatementDetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq("mid", item.getId());
                        statementDetailQueryWrapper.eq("listing_code", subitemCode);
                        statementDetailQueryWrapper.eq("section", section);
                        statementDetailQueryWrapper.eq("dr", 0);
                        List<SettlementBookStatementDetailEntity> detailList = settlementBookStatementDetailService.list(statementDetailQueryWrapper);

                        if (detailList != null && detailList.size() > 0) {
                            for (int i = 0; i < detailList.size(); i++) {
                                SettlementBookStatementDetailEntity detailEntity = detailList.get(i);
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                SettlementBookStatementDetailVO detailVO = BeanMapper.map(detailEntity, SettlementBookStatementDetailVO.class);
                                resList.add(detailVO);
                            }
                        }
                    } else if ("专业分包".equals(contractType)) {
                        QueryWrapper<SettlementBookStatementDetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq("mid", item.getId());
                        statementDetailQueryWrapper.eq("listing_code", subitemCode);
                        statementDetailQueryWrapper.eq("section", section);
                        statementDetailQueryWrapper.eq("dr", 0);
                        List<SettlementBookStatementDetailEntity> detailList = settlementBookStatementDetailService.list(statementDetailQueryWrapper);

                        if (detailList != null && detailList.size() > 0) {
                            for (int i = 0; i < detailList.size(); i++) {
                                SettlementBookStatementDetailEntity detailEntity = detailList.get(i);
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                SettlementBookStatementDetailVO detailVO = BeanMapper.map(detailEntity, SettlementBookStatementDetailVO.class);
                                resList.add(detailVO);
                            }
                        }

                    }
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！", resList);
    }


    /**
     * @Description queryActualCost
     * <p>
     * 使用：成本管理-项目月度成本分析报告-子表人工费本期实际成本
     * 数据来源：结算管理-工程分包结算书-汇总表
     */
    @RequestMapping(value = "/queryActualSumCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementBookSumVo> queryActualSumCost(Long projectId, String reportingMonth) {
        BigDecimal total = new BigDecimal("0.00");
        SettlementBookSumVo settlementBookSumVo = new SettlementBookSumVo();
        if (StringUtils.isBlank(reportingMonth)) {
            return CommonResponse.error("报告月份为空！");
        }

        String[] strArr = reportingMonth.split("-");
        if (strArr.length > 1) {
            String year = strArr[0];
            String month = strArr[1];
            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
            String lastDay = MonthUtil.getLastDayOfMonth(year, month);

            QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper();
            queryWrapper.eq("project_id", projectId);
            queryWrapper.eq("dr", 0);
            queryWrapper.in("bill_state", "1", "3");
            queryWrapper.ge("create_time", firstDay);
            queryWrapper.le("create_time", lastDay);
            List<SettlementBookEntity> mList = settlementBookService.list(queryWrapper);

            if (mList != null && mList.size() > 0) {
                for (SettlementBookEntity item :
                        mList) {
                    String contractType = item.getContractType();
                    QueryWrapper<SettlementBookSummaryDetailEntity> statementDetailQueryWrappers = new QueryWrapper();
                    statementDetailQueryWrappers.eq("mid", item.getId());
                    statementDetailQueryWrappers.eq("dr", 0);
                    List<SettlementBookSummaryDetailEntity> detailList2 = iSettlementBookSummaryDetailService.list(statementDetailQueryWrappers);
                    if (detailList2.size() > 0 && detailList2 != null) {
                        BigDecimal intaxPrice = detailList2.get(4).getIntaxPrice();//材料节超
                        BigDecimal intaxPrice1 = detailList2.get(6).getIntaxPrice();//扣甲供材
                        BigDecimal intaxPrice2 = detailList2.get(7).getIntaxPrice();//扣水电费
                        BigDecimal intaxPrice3 = detailList2.get(8).getIntaxPrice();//其他扣款
                        BigDecimal intaxPrice4 = intaxPrice.add(intaxPrice1);
                        BigDecimal intaxPrice5 = intaxPrice4.add(intaxPrice2);
                        BigDecimal intaxPrice6 = intaxPrice5.add(intaxPrice3);
                        // BigDecimal intaxPrice7 = intaxPrice6.add(intaxPrice4);
                        total = total.add(intaxPrice6);
                        settlementBookSumVo.setId(item.getId());
                        settlementBookSumVo.setTotal(total);
                        settlementBookSumVo.setContractType(contractType);
                        SettlementBookSumVo detailVO = BeanMapper.map(settlementBookSumVo, SettlementBookSumVo.class);

                    }
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！", settlementBookSumVo);
    }

}
