package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseDetailEntity;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseDetailService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseSettlementService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.MaterialPurchaseDetailVO;
import com.ejianc.business.settlementmanage.vo.MaterialPurchaseSettlementVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
@RequestMapping("materialPurchaseSettlementExport")
public class ExcelMaterialPurchaseSettlementController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialPurchaseDetailService materialPurchaseDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialPurchaseSettlementExportFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromPage(@RequestBody List<MaterialPurchaseDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MaterialPurchaseDetailVO subpackagematerialanalysisdetailVO = list.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialpurchasesettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialPurchaseSettlementExportFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromDatabase(@RequestBody MaterialPurchaseSettlementVO subpackagematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper<MaterialPurchaseDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackagematerialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<MaterialPurchaseDetailEntity> list = materialPurchaseDetailService.list(queryWrapper);
        List<MaterialPurchaseDetailVO> subpackagematerialanalysisdetailVOList = BeanMapper.mapList(list, MaterialPurchaseDetailVO.class);
        if (subpackagematerialanalysisdetailVOList != null && subpackagematerialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < subpackagematerialanalysisdetailVOList.size(); i++) {
                MaterialPurchaseDetailVO subpackagematerialanalysisdetailVO = subpackagematerialanalysisdetailVOList.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialpurchasesettlementdetail-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaterialPurchaseSettlement")
    @ResponseBody
    public void downloadSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialpurchasesettlementdetail-import.xlsx", "物资采购结算清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaterialPurchaseSettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialPurchaseDetailVO> successList = new ArrayList<>();
        List<MaterialPurchaseDetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, String> map = new HashMap<>();
        HashMap<String, String> map1 = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    int num = 0;
                    List<String> datas = result.get(i);
                    MaterialPurchaseDetailVO subpackagematerialanalysisdetailVO = new MaterialPurchaseDetailVO();
                    subpackagematerialanalysisdetailVO.setId(IdWorker.getId());//id
                    subpackagematerialanalysisdetailVO.setSuppliesCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资编码
                    subpackagematerialanalysisdetailVO.setSupplies(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 物资名称
                    subpackagematerialanalysisdetailVO.setSpecifications(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 规格型号
                    subpackagematerialanalysisdetailVO.setUnits(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 计量单位
                    subpackagematerialanalysisdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(13)) ? datas.get(13) : null); // 备注
                    /**
                     * 物资编码校验
                     */
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(1));
                    if (back0.getData() == null) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资编码未在库中,请检查!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        MaterialVO materialVO = back0.getData();
                        String name = materialVO.getName() == null ? "" : materialVO.getName();
                        String spec = materialVO.getSpec() == null ? "" : materialVO.getSpec();
                        String unitName = materialVO.getUnitName() == null ? "" : materialVO.getUnitName();
                        if (!name.equals(datas.get(2))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "物资名称与物资编码不符,请检查!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        }
                        if (!spec.equals(datas.get(3))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "规格与物资编码不符,请检查!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        }
                        if (!unitName.equals(datas.get(4))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "计量单位与物资编码不符,请检查!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        }
                    }
                    /**
                     * 非空校验
                     */
                    if (StringUtils.isEmpty(datas.get(1))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资编码不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(2))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资名称不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(6))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "供货数量不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "结算单价(除税)(元)不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "结算单价(含税)(元)不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    /**
                     * 日期格式校验
                     */
                    if (datas.get(5) != null && !"".equals(datas.get(5))) {
                        try {
                            subpackagematerialanalysisdetailVO.setSupplyMonth(StringUtils.isNotBlank(datas.get(5)) ? DateUtils.Date(datas.get(5)) : null); // 供货月份
                        } catch (Exception e) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "供货月份输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        }
                    }

                    /**
                     * 数字格式校验
                     */
                    if (datas.get(6) != null && !"".equals(datas.get(6))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(6)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "分包基础清单工程量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            String quantitySupplied = datas.get(6);
                            //quantitySupplied = quantitySupplied.substring(0,2);
                            subpackagematerialanalysisdetailVO.setQuantitySupplied(Long.parseLong(String.valueOf(quantitySupplied.split("\\.")[0]))); // 供货数量
                        }
                    }
                    if (datas.get(7) != null && !"".equals(datas.get(7))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(7)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "合同单价(除税)(元)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setExtaxContractPrice(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 合同单价(除税)(元)
                        }
                    }
                    if (datas.get(8) != null && !"".equals(datas.get(8))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(8)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "合同单价(含税)(元)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setIntaxContractPrice(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(9) != null && !"".equals(datas.get(9))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(9)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "结算单价(除税)(元)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setExtaxSettlementPrice(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(10) != null && !"".equals(datas.get(10))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(10)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "结算单价(含税)(元)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setIntaxSettlementPrice(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(11) != null && !"".equals(datas.get(11))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(11)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "结算金额(除税)(元)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setExtaxSummaryAmount(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 合同单价(含税)(元)
                        }
                    }
                    if (datas.get(12) != null && !"".equals(datas.get(12))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(12)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "结算金额(含税)(元)输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setIntaxSummaryAmount(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); // 合同单价(含税)(元)
                        }
                    }
                    /**
                     * 公式计算
                     */
                    if (datas.get(11) == null || "".equals(datas.get(11))) {
                        if (num == 0) {
                            BigDecimal extaxSummaryAmount = new BigDecimal(datas.get(6)).multiply(new BigDecimal(datas.get(9)));
                            subpackagematerialanalysisdetailVO.setExtaxSummaryAmount(extaxSummaryAmount);
                        }
                    } else  {
                        if (num==0){
                            subpackagematerialanalysisdetailVO.setExtaxSummaryAmount(new BigDecimal(datas.get(11)));
                        }
                    }
                    if (datas.get(12) == null || "".equals(datas.get(12))) {
                        if (num == 0) {
                            BigDecimal extaxSummaryAmount = new BigDecimal(datas.get(6)).multiply(new BigDecimal(datas.get(10)));
                            subpackagematerialanalysisdetailVO.setIntaxSummaryAmount(extaxSummaryAmount);
                        }
                    } else {
                        if (num==0){
                            subpackagematerialanalysisdetailVO.setIntaxSummaryAmount(new BigDecimal(datas.get(12)));
                        }
                    }
                    if (num > 0) {
                        errorList.add(subpackagematerialanalysisdetailVO);
                    } else {
                        successList.add(subpackagematerialanalysisdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
