package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 工程分包结算书-其他扣款
 * 导入导出
 */
@Controller
@RequestMapping("settlementBookOtherExport")
public class ExcelSettlementBookOtherController {

    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementBookOtherDetailService otherDetailService;

    /**
     * 工程量依据导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportOtherFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void exportOtherFromPage(@RequestBody List<SettlementBookOtherDetailVO> list, HttpServletResponse response) {
        if(list != null && list.size() > 0){
            for (int i = 0; i < list.size(); i++) {
                SettlementBookOtherDetailVO detailVO = list.get(i);
                detailVO.setSort(Long.valueOf(i + 1));
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookOtherDetail-export.xlsx", beans, response);
    }

    /**
     * 工程量依据导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportOtherFromDataBase", method = RequestMethod.POST)
    @ResponseBody
    public void exportOtherFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper<SettlementBookOtherDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", settlementBookVO.getId());
        queryWrapper.eq("dr", 0);
        List<SettlementBookOtherDetailEntity> list = otherDetailService.list(queryWrapper);
        List<SettlementBookOtherDetailVO> detailVOList = BeanMapper.mapList(list, SettlementBookOtherDetailVO.class);
        if (detailVOList != null && detailVOList.size() > 0) {
            for (int i = 0; i < detailVOList.size(); i++) {
                SettlementBookOtherDetailVO detailVO = detailVOList.get(i);
                detailVO.setSort(Long.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookOtherDetail-export.xlsx", beans, response);
    }

    /**
     * 工程量依据导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/otherExcelDown")
    @ResponseBody
    public void otherExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "settlementBookOtherDetail-import.xlsx", "工程量依据模板");
    }

    /**
     * 工程量依据导入
     */
    @RequestMapping(value = "/otherExcelUpload", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> otherExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SettlementBookOtherDetailVO> successList = new ArrayList<>();
        List<SettlementBookOtherDetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, SettlementBookOtherDetailVO> map = new HashMap<>();
        HashMap<String, String> diffMap = new HashMap<>();

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    StringBuffer errorBuffer = new StringBuffer();

                    String sort = datas.get(0);//序号
                    String deductionsName = datas.get(1);//扣款名称
                    String units = datas.get(2);//单位
                    String number = datas.get(3);//数量
                    String extaxUnitprice = datas.get(4);//除税单价
                    String intaxUnitprice = datas.get(5);//含税单价
                    String extaxPrice = datas.get(6);//除税金额
                    String intaxPrice = datas.get(7);//含税金额
                    String remarks = datas.get(8);//备注

                    SettlementBookOtherDetailVO otherDetailVO = new SettlementBookOtherDetailVO();
                    otherDetailVO.setId(IdWorker.getId());//id
                    otherDetailVO.setSort(Long.valueOf(i));
                    otherDetailVO.setUnits(units);//单位
                    otherDetailVO.setDeductionsName(deductionsName);//扣款名称
                    otherDetailVO.setRemarks(remarks);//备注

                    //必填项校验
                    if (StringUtils.isBlank(deductionsName)) {
                        otherDetailVO.setErrorMsg("扣款名称不能为空");
                        errorBuffer.append("扣款名称不能为空");
                    } else {
                        otherDetailVO.setDeductionsName(deductionsName);
                    }

                    if (StringUtils.isBlank(number)) {
                        otherDetailVO.setErrorMsg("'工程量'不能为空");
                        errorBuffer.append("'工程量'不能为空");
                    } else {
                        if (!NumberUtil.isNumber(number)) {
                            otherDetailVO.setErrorMsg("'工程量'格式错误");
                            errorBuffer.append("'工程量'格式错误");
                        } else {
                            otherDetailVO.setNumber(new BigDecimal(number));
                        }
                    }

                    if (StringUtils.isBlank(extaxUnitprice)) {
                        otherDetailVO.setErrorMsg("除税单价不能为空");
                        errorBuffer.append("除税单价不能为空");
                    } else {
                        if (!NumberUtil.isNumber(extaxUnitprice)) {
                            otherDetailVO.setErrorMsg("除税单价格式错误");
                            errorBuffer.append("除税单价格式错误");
                        } else {
                            otherDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                        }
                    }

                    if (StringUtils.isBlank(intaxUnitprice)) {
                        otherDetailVO.setErrorMsg("含税单价不能为空");
                        errorBuffer.append("含税单价不能为空");
                    } else {
                        if (!NumberUtil.isNumber(intaxUnitprice)) {
                            otherDetailVO.setErrorMsg("含税单价格式错误");
                            errorBuffer.append("含税单价格式错误");
                        } else {
                            otherDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                        }
                    }

                    if (StringUtils.isBlank(extaxPrice)) {
                        BigDecimal extaxUnitpriceB = otherDetailVO.getExtaxUnitprice();
                        BigDecimal numberB = otherDetailVO.getNumber();
                        if(extaxUnitpriceB != null && numberB != null){
                            BigDecimal extaxPriceB = extaxUnitpriceB.multiply(numberB);
                            otherDetailVO.setExtaxPrice(extaxPriceB);
                        }
                    } else {
                        if (!NumberUtil.isNumber(extaxPrice)) {
                            otherDetailVO.setErrorMsg("除税金额格式错误");
                            errorBuffer.append("除税金额格式错误");
                        } else {
                            otherDetailVO.setExtaxPrice(new BigDecimal(extaxPrice));
                        }
                    }

                    if (StringUtils.isBlank(intaxPrice)) {
                        BigDecimal intaxUnitpriceB = otherDetailVO.getIntaxUnitprice();
                        BigDecimal numberB = otherDetailVO.getNumber();
                        if(intaxUnitpriceB != null && numberB != null){
                            BigDecimal intaxPriceB = intaxUnitpriceB.multiply(numberB);
                            otherDetailVO.setIntaxPrice(intaxPriceB);
                        }
                    } else {
                        if (!NumberUtil.isNumber(intaxPrice)) {
                            otherDetailVO.setErrorMsg("含税金额格式错误");
                            errorBuffer.append("含税金额格式错误");
                        } else {
                            otherDetailVO.setIntaxPrice(new BigDecimal(intaxPrice));
                        }
                    }

                    
                    //重复性校验
//                    SettlementBookOtherDetailVO mapVO = map.get(otherDetailVO.getInnercode());
//                    if (mapVO == null) {
//                        if(errorBuffer.length() == 0){
//                            map.put(otherDetailVO.getInnercode(), otherDetailVO);
//                        }
//                    } else {
//                        otherDetailVO.setErrorMsg("清单编号已存在！");
//                        errorBuffer.append("清单编号已存在！");
//                    }

                    if (errorBuffer.length() == 0) {
                        successList.add(otherDetailVO);
                    } else {
                        errorList.add(otherDetailVO);
                    }
                }
            }
        }
        
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
