package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseSettlementEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementFinalizedEntity;
import com.ejianc.business.settlementmanage.service.*;
import com.ejianc.business.settlementmanage.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/costmanage/")
public class CostManageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPurchaseSettlementService iMaterialPurchaseSettlementService;

    @Autowired
    private IMachinerySettlementService iMachinerySettlementService;

    @Autowired
    private ISettlementFinalizedService settlementFinalizedService;

    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;


    /**
     * 成本核算:部品部件及材料费
     */
    @RequestMapping(value = "queryCostaccountPartmaterial", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountPartmaterial(Long projectId,String time) {
        QueryWrapper<MaterialPurchaseSettlementEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.le("create_time",time);
        List<MaterialPurchaseSettlementEntity> list = iMaterialPurchaseSettlementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            MaterialPurchaseSettlementEntity MaterialPurchaseSettlement = list.get(i);
            if(MaterialPurchaseSettlement.getIntaxSummaryAmount() != null){
                total = total.add(MaterialPurchaseSettlement.getIntaxSummaryAmount());
            }
        }
        return CommonResponse.success("查询详情数据成功！",total);
    }

    /**
     * 成本核算:机械费
     */
    @RequestMapping(value = "queryCostaccountMechanical", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountMechanical(Long projectId,String time) {
        QueryWrapper<MachinerySettlementEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.le("create_time",time);
        List<MachinerySettlementEntity> list = iMachinerySettlementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            MachinerySettlementEntity MachinerySettlement = list.get(i);
            if(MachinerySettlement.getIntaxMonthlyAmount() != null){
                total = total.add(MachinerySettlement.getIntaxMonthlyAmount());
            }
        }
        return CommonResponse.success("查询详情数据成功！",total);
    }

    /**
     * 项目部商务经理月度报告：竣工工程结算额
     */
    @RequestMapping(value = "queryProjectreportSettlement", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryProjectreportSettlement(Long contractId) {
        QueryWrapper<SettlementFinalizedEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("contract_id",contractId);
        List<SettlementFinalizedEntity> list = settlementFinalizedService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            SettlementFinalizedEntity SettlementFinalized = list.get(i);
            if(SettlementFinalized.getSettlementValue() != null){
                total = total.add(SettlementFinalized.getSettlementValue());
            }
        }
        return CommonResponse.success("查询详情数据成功！",total);
    }

    /**
     * 项目月度成本分析报告：工程分包结算
     */
    @RequestMapping(value = "querySettlementBookStatement", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> querySettlementBookStatement(Long projectId,String code,String name) {
        QueryWrapper<SettlementBookStatementDetailEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("listing_code",code);
        queryWrapper.eq("part_project_name",name);
        List<SettlementBookStatementDetailEntity> list = settlementBookStatementDetailService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            SettlementBookStatementDetailEntity SettlementBookStatementDetailEntity = list.get(i);
            if(SettlementBookStatementDetailEntity.getQuantities() != null || SettlementBookStatementDetailEntity.getIntaxUnitprice() != null ||SettlementBookStatementDetailEntity.getIntaxAddition() != null){
                total = total.add(SettlementBookStatementDetailEntity.getQuantities());
                total = total.add(SettlementBookStatementDetailEntity.getIntaxUnitprice());
                total = total.add(SettlementBookStatementDetailEntity.getIntaxAddition());
            }

        }
        return CommonResponse.success("查询详情数据成功！",total);
    }

    /**
     * 项目月度成本分析报告
     * 获取结算书金额
     * status - 0 查询工程量清单结算表金额
     * status - 1 查询结算汇总表金额
     */
    @RequestMapping(value = "queryLabor", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String,LaborCostVO>> queryLabor(@RequestBody LaborCostRequestVO laborCostRequestVO) throws ParseException {
        Map<String,LaborCostVO> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        Date time = sdf.parse(laborCostRequestVO.getReportingTime());
        String date = sdf1.format(time);
        if(laborCostRequestVO.getStatus() == null && laborCostRequestVO.getList().size() > 0){
            for(LaborCostRequestDetailVO entity : laborCostRequestVO.getList()){
                LaborCostVO vo = settlementBookStatementDetailService.getEngineering(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),entity.getSubitemCode(),entity.getSection(),date);
                map.put(entity.getSubitemCode()+entity.getSection(),vo);
            }
            List<LaborCostVO> vo1 = settlementBookStatementDetailService.getSum(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),date);
            for(int i = 0;i < vo1.size(); i++){
               map.put("结算"+i,vo1.get(i));
            }

        }
        if(laborCostRequestVO.getStatus() != null && laborCostRequestVO.getStatus().equals("0")){
            List<LaborCostVO> vo1 = settlementBookStatementDetailService.getSum(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),date);
            for(int i = 0;i < vo1.size(); i++){
                map.put("结算"+i,vo1.get(i));
            }
        }
        logger.info("返回数据="+ map.toString());
        return CommonResponse.success("查询数据成功!",map);

    }
    /**
     * 成本管理-根据项目、时间、合同类型查询工程项目结算书工程清单结算所有数据
     */
    @RequestMapping(value = "queryStatementAll", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<LaborCostVO>> queryStatementAll(@RequestParam String projectId,@RequestParam String contractType,@RequestParam String time){
        List<LaborCostVO> statementAll = settlementBookStatementDetailService.getStatementAll(projectId, contractType, time);
        return CommonResponse.success("查询数据成功",statementAll);
    }

}
