package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookListDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookListDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookMaterialDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookListDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工程分包结算书-材料节超分析表
 */
@Controller
@RequestMapping("settlementBookSuperanalysisExport")
public class ExcelSettlementBookSuperanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementBookMaterialDetailService settlementBookMaterialDetailService;

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportSuperanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromPage(@RequestBody List<SettlementBookMaterialDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SettlementBookMaterialDetailVO subpackagematerialanalysisdetailVO = list.get(i);
                long sort = i + 1;
                subpackagematerialanalysisdetailVO.setSort(sort);
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookVisaScheduleDetailSuperanalysis-export.xlsx", beans, response);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportSuperanalysisFromDataBase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromDatabase(@RequestBody SettlementBookMaterialDetailVO subpackagematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper<SettlementBookMaterialDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackagematerialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<SettlementBookMaterialDetailEntity> list = settlementBookMaterialDetailService.list(queryWrapper);
        List<SettlementBookMaterialDetailVO> subpackagematerialanalysisdetailVOList = BeanMapper.mapList(list, SettlementBookMaterialDetailVO.class);
        if (subpackagematerialanalysisdetailVOList != null && subpackagematerialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < subpackagematerialanalysisdetailVOList.size(); i++) {
                SettlementBookMaterialDetailVO subpackagematerialanalysisdetailVO = subpackagematerialanalysisdetailVOList.get(i);
                long sort = i + 1;
                subpackagematerialanalysisdetailVO.setSort(sort);
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookVisaScheduleDetailUtilities-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/superanalysisExcelDown")
    @ResponseBody
    public void downloadSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "settlementBookVisaScheduleDetailSuperanalysis-import.xlsx", "材料节超分析表模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/superanalysisExcelUpload", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SettlementBookMaterialDetailVO> successList = new ArrayList<>();
        List<SettlementBookMaterialDetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, String> map = new HashMap<>();
        HashMap<String, String> map1 = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SettlementBookMaterialDetailVO subpackagematerialanalysisdetailVO = new SettlementBookMaterialDetailVO();
                    subpackagematerialanalysisdetailVO.setId(IdWorker.getId());//id
                    subpackagematerialanalysisdetailVO.setBillCodeB(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资编码
                    subpackagematerialanalysisdetailVO.setSectionB(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 物资名称
                    subpackagematerialanalysisdetailVO.setMaterialNameB(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 物资名称
                    subpackagematerialanalysisdetailVO.setUnitsB(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 物资名称
//                    subpackagematerialanalysisdetailVO.setDosageCollar(StringUtils.isNotBlank(datas.get(8)) ? datas.get(8) : null); // 备注
                    /**
                     * 非空校验
                     */
                    if (StringUtils.isEmpty(datas.get(3))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("材料名称不能为空!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    }
                    if (StringUtils.isEmpty(datas.get(5))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("领用量不能为空!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    }
                    if (StringUtils.isEmpty(datas.get(6))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("结算量不能为空!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    }
                    if (StringUtils.isEmpty(datas.get(7))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("节超量不能为空!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("采购单价不能为空!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    }

                    /**
                     * 数字格式校验
                     */
                    if (!NumberUtil.isNumber(String.valueOf(datas.get(5)))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("领用量输入格式错误!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    } else {
                        String[] split = datas.get(5).split("\\.");
                        subpackagematerialanalysisdetailVO.setDosageCollarB(Long.parseLong(String.valueOf(split[0]))); // 供货数量
                    }

                    if (!NumberUtil.isNumber(String.valueOf(datas.get(6)))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("结算量输入格式错误!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    } else {
                        String[] split = datas.get(6).split("\\.");
                        subpackagematerialanalysisdetailVO.setSettlementNumB(Long.parseLong(String.valueOf(split[0]))); // 供货数量
                    }
                    if (!NumberUtil.isNumber(String.valueOf(datas.get(7)))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("节超量输入格式错误!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    } else {
                        String[] split = datas.get(7).split("\\.");
                        subpackagematerialanalysisdetailVO.setSectionNumB(Long.parseLong(String.valueOf(split[0]))); // 供货数量
                    }
                    if (!NumberUtil.isNumber(String.valueOf(datas.get(8)))) {
                        subpackagematerialanalysisdetailVO.setErrorMessage("采购单价输入格式错误!");
                        errorList.add(subpackagematerialanalysisdetailVO);
                        continue;
                    } else {
                        subpackagematerialanalysisdetailVO.setExtaxPurchasingpriceB(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : BigDecimal.ZERO); // 合同单价(含税)(元)
                    }
                    if (StringUtils.isBlank(datas.get(9))) {
                        //节超量
                        Long sectionNumB = subpackagematerialanalysisdetailVO.getSectionNumB();
                        //采购单价
                        BigDecimal extaxPurchasingpriceB = subpackagematerialanalysisdetailVO.getExtaxPurchasingpriceB();
                        //计算节超金额
                        BigDecimal extaxSectionpriceB = new BigDecimal(sectionNumB).multiply(extaxPurchasingpriceB);
                        subpackagematerialanalysisdetailVO.setExtaxSectionpriceB( extaxSectionpriceB); // 合同单价(含税)(元)
                    }else {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(9)))) {
                            subpackagematerialanalysisdetailVO.setErrorMessage("节超金额输入格式错误!");
                            errorList.add(subpackagematerialanalysisdetailVO);
                            continue;
                        }else {
                            subpackagematerialanalysisdetailVO.setExtaxSectionpriceB(new BigDecimal(datas.get(9)));
                        }
                    }
                    successList.add(subpackagematerialanalysisdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
