package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 工程分包结算书-工程量清单结算表
 */
@Controller
@RequestMapping("settlementBookStatementExport")
public class ExcelSettlementBookStatementController {

    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;

    @Autowired
    private IOutcontractApi outcontractApi;

    @Qualifier("com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;

    /**
     * 工程量清单结算表导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportStateFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void exportStateFromPage(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        List<SettlementBookStatementDetailVO> records = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SettlementBookStatementDetailVO statementDetailVO = list.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
                records.add(statementDetailVO);
                if(statementDetailVO.getChildren()!=null&&statementDetailVO.getChildren().size()>0){
                    this.splitList(statementDetailVO.getChildren(),records);
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    /**
     * 导出遍历加上所有子表
     * @param list
     * @param records
     */
    private void splitList(List<SettlementBookStatementDetailVO> list,List<SettlementBookStatementDetailVO> records) {
        for(SettlementBookStatementDetailVO vo : list){
            String source = vo.getSource();
            if("1".equals(source)){//来源：1合同内 2合同外
                source = "合同内";
            }else if("2".equals(source)){
                source = "合同外";
            }
            vo.setSource(source);
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }
    }

    /**
     * 工程量清单结算表导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportStateFromDataBase", method = RequestMethod.POST)
    @ResponseBody
    public void exportStateFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper<SettlementBookStatementDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", settlementBookVO.getId());
        queryWrapper.eq("dr", 0);
        List<SettlementBookStatementDetailEntity> list = statementDetailService.list(queryWrapper);
        List<SettlementBookStatementDetailVO> statementDetailVOList = BeanMapper.mapList(list, SettlementBookStatementDetailVO.class);
        if (statementDetailVOList != null && statementDetailVOList.size() > 0) {
            for (int i = 0; i < statementDetailVOList.size(); i++) {
                SettlementBookStatementDetailVO statementDetailVO = statementDetailVOList.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    /**
     * 工程量清单结算表导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/stateExcelDown")
    @ResponseBody
    public void stateExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SettlementBookStatementDetail-import.xlsx", "工程量清单结算表模板");
    }

    /**
     * 工程量清单结算表导入
     */
    @RequestMapping(value = "/statementExcelUpload", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> statementExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId,boolean isExport) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SettlementBookStatementDetailVO> successList = new ArrayList<>();
        List<SettlementBookStatementDetailVO> errorList = new ArrayList<>();
        HashMap<String, SettlementBookStatementDetailVO> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            Map<String,SettlementBookStatementDetailVO> mapperMap = new HashMap<>();
            List<SettlementBookStatementDetailVO> list =  new ArrayList<>();
            //合同id查询分包月度报量及申请报告中的数据以便比对导入的数据
            CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO>> listCommonResponse
                    = subcontractingvolumeApi.querySubcontractingvolumeDetailByContractId(contractId);
            if (listCommonResponse.isSuccess()){
                List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO> data = listCommonResponse.getData();
                list = BeanMapper.mapList(data, SettlementBookStatementDetailVO.class);
                for (SettlementBookStatementDetailVO VO : list) {
                    //根据清单编码 区段 合同除税单价做为唯一标识比对导入的数据 如果导入数据没有查到的数据则添加到导入的数据中一并返回给前端
                    String listCode = VO.getListingCode();
                    String section1 = VO.getSection();
                    String extaxUnitprice = VO.getExtaxUnitprice().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                    String intaxUnitprice = VO.getIntaxUnitprice().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                    String key = listCode +"_"+ section1+"_" + extaxUnitprice+"_"+intaxUnitprice;
                    if ("1".equals(VO.getSource())){
                        VO.setSource("合同内");
                    }else {
                        VO.setSource("合同外");
                    }
                    VO.setId(IdWorker.getId());
                    mapperMap.put(key,VO);
                }
            }
            //定义标记标记是否提示错误提前退出
            boolean flag = true;
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    String listingCode = datas.get(0);//清单编码
                    String section = datas.get(1);//区段
                    String partProjectName = datas.get(2);//分部分项工程名称
                    String subitemDesc = datas.get(3);//子目特征描述
                    String units = datas.get(4);//单位
                    String quantities = datas.get(5);//工程量
                    String cumulativeEngineeringQuantity = datas.get(6);//累计报量工程量
                    String thisEngineeringQuantity = datas.get(7);//本次报量工程量
                    String extaxUnitprice = datas.get(8);//合同单价(除税)
                    String intaxUnitprice = datas.get(9);//合同单价(含税)
                    String exsettlementUnitprice = datas.get(10);// 结算单价(除税)
                    String insettlementUnitprice = datas.get(11);// 结算单价(含税)
                    String source = datas.get(14);// 来源
                    String remarks = datas.get(15);// 备注
                    SettlementBookStatementDetailVO statementDetailVO = new SettlementBookStatementDetailVO();
                    statementDetailVO.setId(IdWorker.getId());
                    statementDetailVO.setSort(Long.valueOf(i));
                    statementDetailVO.setTid(String.valueOf(IdWorker.getId()));
                    statementDetailVO.setUnits(units);//单位
                    statementDetailVO.setRemarks(remarks);
                    statementDetailVO.setSource(source);
                    statementDetailVO.setSubitemDesc(subitemDesc);
                    statementDetailVO.setListingCode(listingCode);
                    statementDetailVO.setSection(section);
                    statementDetailVO.setPartProjectName(partProjectName);
                    //唯一标识确定是否修改分包月度报量的值
                    String key = listingCode + "_" + section + "_" + new BigDecimal(extaxUnitprice).setScale(2,BigDecimal.ROUND_HALF_UP) + "_" + new BigDecimal(intaxUnitprice).setScale(2,BigDecimal.ROUND_HALF_UP);
                    //设置innercode
                    statementDetailVO.setInnercode(key);//清单编码确定唯一性
                    //校验清单编码
                    if (StringUtils.isBlank(listingCode)){
                        statementDetailVO.setErrorMsg("'清单编码'不能为空");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else {
                        int arr[] = new int[]{2,4,6,9};
                        if (Arrays.binarySearch(arr,listingCode.length()) < 0){
                            statementDetailVO.setErrorMsg("'清单编码'只能为2，4，6，9位");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }else {
                            statementDetailVO.setListingCode(listingCode);
                            if ("01".equals(listingCode) && partProjectName != null && partProjectName.contains("装饰")) {
                                statementDetailVO.setInnercode("a1" + "_" + section);
                            }
                            //判断是否是装饰工程的子节点编码
                            if (listingCode.length() >= 4) {
                                //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                                String code = listingCode.substring(0, 4);
                                if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                                    //若是的话，将内码改为a1xx
                                    statementDetailVO.setInnercode("a1" + listingCode.substring(2, listingCode.length()) + "_" + section);
                                }
                            }
                        }
                    }
                    if (StringUtils.isBlank(section)){
                        statementDetailVO.setErrorMsg("'区段'不能为空");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }
                    if (StringUtils.isBlank(partProjectName)){
                        statementDetailVO.setErrorMsg("'分部分项工程名称'不能为空");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else {
                        statementDetailVO.setPartProjectName(partProjectName);
                    }
                    //重复性校验
                    SettlementBookStatementDetailVO mapVO = map.get(statementDetailVO.getInnercode());
                    if (mapVO == null) {
                        map.put(statementDetailVO.getInnercode(), statementDetailVO);
                    } else {
                        statementDetailVO.setErrorMsg("'清单编码','区段','合同除税单价','合同含税单价'组合不能重复！");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }
                    SettlementBookStatementDetailVO VO = mapperMap.get(key);
                    //校验累计报量工程量
                    if(StringUtils.isBlank(cumulativeEngineeringQuantity)){
                        statementDetailVO.setErrorMsg("'累计报量工程量'不能为空");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else {
                        if (!NumberUtil.isNumber(cumulativeEngineeringQuantity)) {
                            statementDetailVO.setErrorMsg("'累计报量工程量'格式错误");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        } else {
                            if (VO != null){
                                //校验是否修改分包月度报量带过来的字段值
                                if (new BigDecimal(cumulativeEngineeringQuantity).compareTo(VO.getCumulativeEngineeringQuantity()) != 0){
                                    statementDetailVO.setCumulativeEngineeringQuantity(new BigDecimal(cumulativeEngineeringQuantity));
                                    statementDetailVO.setErrorMsg("'累计报量工程量'不允许修改");
                                    errorList.add(statementDetailVO);
                                    flag = false;
                                    continue;
                                }else {
                                    statementDetailVO.setCumulativeEngineeringQuantity(new BigDecimal(cumulativeEngineeringQuantity));
                                }
                            }else {
                                statementDetailVO.setCumulativeEngineeringQuantity(new BigDecimal(cumulativeEngineeringQuantity));
                            }
                        }
                    }
                    //校验工程量和本次报量工程量
                    if(StringUtils.isBlank(quantities) && StringUtils.isBlank(thisEngineeringQuantity)){
                        statementDetailVO.setErrorMsg("'工程量和本次报量工程量'不能同时为空");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else {
                        if (!StringUtils.isBlank(quantities)) {
                            if (!NumberUtil.isNumber(quantities)){
                                statementDetailVO.setErrorMsg("'工程量'格式错误");
                                errorList.add(statementDetailVO);
                                flag = false;
                                continue;
                            }else {
                                statementDetailVO.setQuantities(new BigDecimal(quantities));
                                BigDecimal thisQuantity = new BigDecimal(quantities).subtract(new BigDecimal(cumulativeEngineeringQuantity));
                                statementDetailVO.setThisEngineeringQuantity(thisQuantity);
                            }
                        }
                        if (!StringUtils.isBlank(thisEngineeringQuantity)) {
                            if (!NumberUtil.isNumber(thisEngineeringQuantity)) {
                                statementDetailVO.setErrorMsg("'本次报量工程量'格式错误");
                                errorList.add(statementDetailVO);
                                flag = false;
                                continue;
                            }else {
                                statementDetailVO.setThisEngineeringQuantity(new BigDecimal(thisEngineeringQuantity));
                                BigDecimal sumQuantity = new BigDecimal(thisEngineeringQuantity).add(new BigDecimal(cumulativeEngineeringQuantity));
                                statementDetailVO.setQuantities(sumQuantity);
                            }
                        }
                    }

                    //格式校验：结算除税单价、结算含税单价
                    if(StringUtils.isBlank(exsettlementUnitprice)){
                        statementDetailVO.setErrorMsg("'结算除税单价'不能为空");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else {
                        if (!NumberUtil.isNumber(exsettlementUnitprice)) {
                            statementDetailVO.setErrorMsg("'结算除税单价'格式错误");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        } else {
                            if (VO != null){
                                //校验是否修改分包月度报量带过来的字段值
                                if (new BigDecimal(exsettlementUnitprice).compareTo(VO.getExsettlementUnitprice()) != 0){
                                    statementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                                    statementDetailVO.setErrorMsg("'结算除税单价'不允许修改");
                                    errorList.add(statementDetailVO);
                                    flag = false;
                                    continue;
                                }else {
                                    statementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                                }
                            }else {
                                statementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                            }
                        }
                    }

                    if(StringUtils.isBlank(insettlementUnitprice)){
                        statementDetailVO.setErrorMsg("'结算含税单价'不能为空");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else {
                        if (!NumberUtil.isNumber(insettlementUnitprice)) {
                            statementDetailVO.setErrorMsg("'结算含税单价'格式错误");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        } else {
                            if (VO != null){
                                //校验是否修改分包月度报量带过来的字段值
                                if (new BigDecimal(insettlementUnitprice).compareTo(VO.getInsettlementUnitprice()) != 0){
                                    statementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                                    statementDetailVO.setErrorMsg("'结算含税单价'不允许修改");
                                    errorList.add(statementDetailVO);
                                    flag = false;
                                    continue;
                                }else {
                                    statementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                                }
                            }else {
                                statementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                            }
                        }
                    }
                    if(StringUtils.isBlank(extaxUnitprice)){//合同单价(除税)
                        statementDetailVO.setErrorMsg("'合同单价(除税)'不能为空！");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else{
                        if(!NumberUtil.isNumber(extaxUnitprice)){
                            statementDetailVO.setErrorMsg("'合同单价(除税)'格式错误");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }else{
                            if (VO != null){
                                //校验是否修改分包月度报量带过来的字段值
                                if (new BigDecimal(extaxUnitprice).compareTo(VO.getExtaxUnitprice()) != 0){
                                    statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                                    statementDetailVO.setErrorMsg("'合同单价(除税)'不允许修改");
                                    errorList.add(statementDetailVO);
                                    flag = false;
                                    continue;
                                }else {
                                    statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                                }
                            }else {
                                statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                            }
                        }
                    }
                    if(StringUtils.isBlank(intaxUnitprice)){
                        statementDetailVO.setErrorMsg("'合同单价(含税)'不能为空！");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }else{
                        if(!NumberUtil.isNumber(intaxUnitprice)){
                            statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                            statementDetailVO.setErrorMsg("'合同单价(含税)'格式错误");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }else{
                            if (VO != null){
                                //校验是否修改分包月度报量带过来的字段值
                                if (new BigDecimal(intaxUnitprice).compareTo(VO.getIntaxUnitprice()) != 0){
                                    statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                                    statementDetailVO.setErrorMsg("'合同单价(含税)'不允许修改");
                                    errorList.add(statementDetailVO);
                                    flag = false;
                                    continue;
                                }else {
                                    statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                                }
                            }else {
                                statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                            }
                        }
                    }
                    //结算单价除税
                    BigDecimal exsettlementUnitpriceB = statementDetailVO.getExsettlementUnitprice();
                    //合同单价除税
                    BigDecimal extaxUnitpriceB = statementDetailVO.getExtaxUnitprice();
                    if (extaxUnitpriceB.compareTo(exsettlementUnitpriceB) == -1){
                        statementDetailVO.setErrorMsg("'结算单价除税'不能大于'合同单价除税'");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }
                    //结算单价含税
                    BigDecimal insettlementUnitpriceB = statementDetailVO.getInsettlementUnitprice();
                    //合同单价含税
                    BigDecimal intaxUnitpriceB = statementDetailVO.getIntaxUnitprice();
                    if (intaxUnitpriceB.compareTo(insettlementUnitpriceB) == -1){
                        statementDetailVO.setErrorMsg("'结算单价含税'不能大于'合同单价含税'");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }
                    //工程量
                    BigDecimal quantitiesB = statementDetailVO.getQuantities();
                    //累计报量工程量
                    BigDecimal cumulativeEngineeringQuantityB = statementDetailVO.getCumulativeEngineeringQuantity();
                    //本期报量工程量
                    BigDecimal thisEngineeringQuantityB = statementDetailVO.getThisEngineeringQuantity();
                    //本期报量金额(除税)
                    BigDecimal thisAmountsNotax = thisEngineeringQuantityB.multiply(exsettlementUnitpriceB);
                    //本期报量金额(含税)
                    BigDecimal thisAmountsTax = thisEngineeringQuantityB.multiply(insettlementUnitpriceB);
                    //累计报量金额(除税)
                    BigDecimal accruingAmountsNotax = cumulativeEngineeringQuantityB.multiply(exsettlementUnitpriceB);
                    //累计报量金额(含税)
                    BigDecimal accruingAmountsTax = cumulativeEngineeringQuantityB.multiply(insettlementUnitpriceB);
                    //合价除税
                    BigDecimal extaxAdditionB = quantitiesB.multiply(exsettlementUnitpriceB);
                    //合价含税
                    BigDecimal intaxAdditionB = quantitiesB.multiply(insettlementUnitpriceB);
                    statementDetailVO.setThisAmountsNotax(thisAmountsNotax);
                    statementDetailVO.setThisAmountsTax(thisAmountsTax);
                    statementDetailVO.setAccruingAmountsNotax(accruingAmountsNotax);
                    statementDetailVO.setAccruingAmountsTax(accruingAmountsTax);
                    statementDetailVO.setExtaxAddition(extaxAdditionB);
                    statementDetailVO.setIntaxAddition(intaxAdditionB);
                    successList.add(statementDetailVO);
                    //当查询到的分包月度报量数据不为空时且根据唯一标识获取到了查到的数并做是否修改的校验
                    //移除这个查到并校验的数据则剩下的数据可以认为是客户删除的数据
                    if (!list.isEmpty() && VO != null){
                        list.remove(VO);
                    }
                }
            }
            if (!list.isEmpty() && flag && isExport){
                int i = 1;
                for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : list) {
                    settlementBookStatementDetailVO.setErrorMsg("此数据为从分包月度报量获取数据，不允许删除");
                    settlementBookStatementDetailVO.setSort(Long.valueOf(i));
                    errorList.add(settlementBookStatementDetailVO);
                    i++;
                }
            }
        }
        List<SettlementBookStatementDetailVO> resList = new ArrayList<>();
        if (!successList.isEmpty()){
            //按子目编码排序
            Collections.sort(successList, new Comparator<SettlementBookStatementDetailVO>() {
                @Override
                public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                    return (o1.getListingCode() + o1.getPartProjectName()).compareTo(o2.getListingCode() + o2.getPartProjectName());
                }
            });
            //设置tid和tpid
            resList = setTidAndTpid(successList, map);
            //构建树
            resList = createTreeData(resList);
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            SettlementBookStatementDetailVO settlementBookStatementDetailVO = vos.get(i);
            //设置父级id
            String innercode = settlementBookStatementDetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                settlementBookStatementDetailVO.setTpid(pid.toString());
            } else {
                settlementBookStatementDetailVO.setTpid("");
            }
        }

        return vos;
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        List<SettlementBookStatementDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SettlementBookStatementDetailVO> listMap = new HashMap<>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SettlementBookStatementDetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = (List<SettlementBookStatementDetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }
}
