package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("settlementBook")
public class SettlementBookBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISettlementBookStatementDetailService settlementBookStatementDetailService;
	@Autowired
	private ISettlementBookService service;
	@Autowired
	private CostanalysisApi costanalysisApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		SettlementBookEntity entity = service.getOne(queryWrapper);
		if(costanalysisApi.isGenerate(entity.getProjectId(),entity.getCreateTime()).getData()){
			return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
		}else{
			return CommonResponse.success();
		}
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		SettlementBookEntity entity = service.getOne(queryWrapper);
		if(costanalysisApi.isGenerate(entity.getProjectId(),entity.getCreateTime()).getData()){
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}else{
			return CommonResponse.success();
		}
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		QueryWrapper<SettlementBookStatementDetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", billId);
		queryWrapper.eq("dr", "0");
		List<SettlementBookStatementDetailEntity> detailEntities = settlementBookStatementDetailService.list(queryWrapper);
		if(detailEntities != null && detailEntities.size() > 0){
			for (int i = 0; i < detailEntities.size(); i++) {
				SettlementBookStatementDetailEntity detail = detailEntities.get(i);
				detail.setBillState(state);//更新子表审批状态
			}

			settlementBookStatementDetailService.saveOrUpdateBatch(detailEntities);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		SettlementBookEntity entity = service.getOne(queryWrapper);
		if(costanalysisApi.isGenerate(entity.getProjectId(),entity.getCreateTime()).getData()){
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}else{
			return CommonResponse.success();
		}
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
