package com.ejianc.business.settlementmanage.service;

import com.ejianc.business.settlementmanage.bean.ConsultotherfinalEntity;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 咨询及其他类合同最终结算单
 *
 * @author generator
 *
 */
public interface IConsultotherfinalService extends IBaseService<ConsultotherfinalEntity> {
    /**
     * 查询资讯类最终结算清单本期除税合价
     * @param projectId
     * @return
     */
    BigDecimal queryConsultotherfinal(Long projectId, String monthStr);

    /**
     * 计算子表相关的本期金额数据
     * @param entity
     * @return
     */
    ConsultotherfinalEntity calculateDetailCurrentAmount(ConsultotherfinalEntity entity);

    /**
     * 根据接口返回的子表的数据 将list转换为map  key 为名称+除税单价+含税单价
     * @param contractId
     * @param date
     * @return
     */
    Map<String,ConsultotherfinaldetailVO> queryConsultDetailCumPastMap(Long contractId,String date);

    /**
     * 根据接口返回的其他扣款子表的数据 将list转换为map  key 为名称+除税单价+含税单价
     * @param contractId
     * @param date
     * @return
     */
    Map<String, ConsultotherfinalodetailVO> queryConsultOtherDetailCumPastMap(Long contractId, String date);



}
