package com.ejianc.business.settlementmanage.service;

import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;

import java.util.Map;

/**
 * 工程分包结算书子表-支出明细-材料节超分析表
 * 
 * @author generator
 * 
 */
public interface ISettlementBookMaterialDetailService extends IBaseService<SettlementBookMaterialDetailEntity> {
    /**
     * 根据合同id查询分包月度报量及申请报告的物资节超数据
     * 并将查询到的数据组装成编码+区段+除税单价+含税单价为key的map数据方便比对哪些数据是从分包月度报量带过来的
     * @param contractId
     * @return
     */
    Map<String, SettlementBookMaterialDetailVO> querySubcontractingvolumeMaterialByContractId(Long contractId);
}
