package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.bean.DesignSettlementDetailEntity;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.business.settlementmanage.vo.DesignSettlementDetailVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.DesignSettlementMapper;
import com.ejianc.business.settlementmanage.bean.DesignSettlementEntity;
import com.ejianc.business.settlementmanage.service.IDesignSettlementService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设计类结算单-主表
 * 
 * @author generator
 * 
 */
@Service("designSettlementService")
public class DesignSettlementServiceImpl extends BaseServiceImpl<DesignSettlementMapper, DesignSettlementEntity> implements IDesignSettlementService{
    @Autowired
    private DesignSettlementMapper mapper;
    @Autowired
    private DesignAndConsultApi designAndConsultApi;
    @Override
    public BigDecimal queryDesignSettlement(Long projectId,String monthStr) {
        BigDecimal curExtaxPrice = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS = mapper.queryDesignSettlement(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.add(totalPrice);
        }
        return curExtaxPrice;
    }

    @Override
    public DesignSettlementEntity calculateDetailCurrentAmount(DesignSettlementEntity entity) {
        //咨询类结算单的子表
        List<DesignSettlementDetailEntity> designSettlementDetailEntities = entity.getDesignSettlementDetailEntities();
        if (!designSettlementDetailEntities.isEmpty()){
            for (DesignSettlementDetailEntity designSettlementDetailEntity : designSettlementDetailEntities) {
                if (!"del".equals(designSettlementDetailEntity.getRowState())){
                    //累计除税金额
                    BigDecimal cumExtaxPrice = designSettlementDetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : designSettlementDetailEntity.getCumExtaxPrice();
                    //累计含税金额
                    BigDecimal cumIntaxPrice = designSettlementDetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : designSettlementDetailEntity.getCumIntaxPrice();
                    designSettlementDetailEntity.setCurExtaxPrice(designSettlementDetailEntity.getAuditExtaxAmount().subtract(cumExtaxPrice));
                    designSettlementDetailEntity.setCurIntaxPrice(designSettlementDetailEntity.getAuditIntaxAmount().subtract(cumIntaxPrice));
                }
            }
        }
        return entity;
    }

    @Override
    public Map<String, DesignSettlementDetailVO> queryDesignDetailCumPastMap(Long contractId, String date) {
        Map<String, DesignSettlementDetailVO> map = new HashMap<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO>> listCommonResponse =
                designAndConsultApi.queryDesignDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()){
            if (!listCommonResponse.getData().isEmpty()){
                List<DesignSettlementDetailVO> designSettlementDetailVOS =
                        BeanMapper.mapList(listCommonResponse.getData(), DesignSettlementDetailVO.class);
                for (DesignSettlementDetailVO designSettlementDetailVO : designSettlementDetailVOS) {
                    String key = designSettlementDetailVO.getProjectName() +
                            designSettlementDetailVO.getAuditExtaxAddition().setScale(2,BigDecimal.ROUND_HALF_UP) +
                            designSettlementDetailVO.getAuditIntaxAddition().setScale(2,BigDecimal.ROUND_HALF_UP);
                    map.put(key,designSettlementDetailVO);
                }
            }
        }else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }
}
