package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.SettlementBookMaterialDetailMapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookMaterialDetailService;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工程分包结算书子表-支出明细-材料节超分析表
 * 
 * @author generator
 * 
 */
@Service("settlementBookMaterialDetailService")
public class SettlementBookMaterialDetailServiceImpl extends BaseServiceImpl<SettlementBookMaterialDetailMapper, SettlementBookMaterialDetailEntity> implements ISettlementBookMaterialDetailService{
    @Qualifier("com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;


    @Override
    public Map<String, SettlementBookMaterialDetailVO> querySubcontractingvolumeMaterialByContractId(Long contractId) {
        Map<String, SettlementBookMaterialDetailVO> map = new HashMap<>();
        //请求查询物资节超服务
        List<SettlementBookMaterialDetailVO> materialDetailVOList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO>> materialResponse =
                subcontractingvolumeApi.querySubcontractingvolumeMaterialByContractId(contractId);
        if (materialResponse.isSuccess()){
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO> data =
                    materialResponse.getData();
            materialDetailVOList = BeanMapper.mapList(data,SettlementBookMaterialDetailVO.class);
            for (SettlementBookMaterialDetailVO settlementBookMaterialDetailVO : materialDetailVOList) {
                settlementBookMaterialDetailVO.setIsEditState("否");
                String key = settlementBookMaterialDetailVO.getBillCodeB() +
                            settlementBookMaterialDetailVO.getSectionB() +
                            settlementBookMaterialDetailVO.getExtaxPurchasingpriceB().setScale(2, RoundingMode.HALF_UP) +
                            settlementBookMaterialDetailVO.getIntaxPurchasingprice().setScale(2,RoundingMode.HALF_UP);
                map.put(key,settlementBookMaterialDetailVO);
            }
        }else {
            throw new BusinessException(materialResponse.getMsg());
        }
        return map;
    }
}
