package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookMaterialDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.SettlementBookMapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;

import java.math.RoundingMode;
import java.util.Map;

/**
 * 工程分包结算书-主表
 * 
 * @author generator
 * 
 */
@Service("settlementBookService")
public class SettlementBookServiceImpl extends BaseServiceImpl<SettlementBookMapper, SettlementBookEntity> implements ISettlementBookService{
    @Autowired
    private ISettlementBookMaterialDetailService materialDetailService;
    @Autowired
    private ISettlementBookOtherDetailService otherDetailService;


    @Override
    public SettlementBookEntity checkMaterialAndOtherFromSubcontractingvolume(SettlementBookEntity entity) {
        Map<String, SettlementBookMaterialDetailVO> materialMap =
                materialDetailService.querySubcontractingvolumeMaterialByContractId(entity.getContractId());
        for (SettlementBookMaterialDetailEntity settlementBookMaterialDetailEntity : entity.getSettlementBookMaterialDetailEntities()) {
            String key = settlementBookMaterialDetailEntity.getBillCodeB() +
                    settlementBookMaterialDetailEntity.getSectionB() +
                    settlementBookMaterialDetailEntity.getExtaxPurchasingpriceB().setScale(2, RoundingMode.HALF_UP) +
                    settlementBookMaterialDetailEntity.getIntaxPurchasingprice().setScale(2,RoundingMode.HALF_UP);
            SettlementBookMaterialDetailVO settlementBookMaterialDetailVO = materialMap.get(key);
            if (settlementBookMaterialDetailVO != null){
            //    证明是带过来的数 这时需要比较有没有修改 如果修改则需要将这条数据做标记
            //   保存数据的节超量
                Long sectionNumB = settlementBookMaterialDetailEntity.getSectionNumB() == null ? 0 : settlementBookMaterialDetailEntity.getSectionNumB();
                //带过来的原始的节超量
                Long sectionNumBOriginal = settlementBookMaterialDetailVO.getSectionNumB() == null ? 0 : settlementBookMaterialDetailVO.getSectionNumB();
                if (!sectionNumB.equals(sectionNumBOriginal)){
                //    比较两个节超量的数值有变化 证明有修改 所以标记这条数据
                }
            }else {
            //    证明数据是新增的 这时无需比较  直接标记这条数据即可
            }
        }
        Map<String, SettlementBookOtherDetailVO> otherDetailVOMap =
                otherDetailService.querySubcontractingvolumeOtherByContractId(entity.getContractId());
        for (SettlementBookOtherDetailEntity settlementBookOtherDetailEntity : entity.getSettlementBookOtherDetailEntities()) {
            String key = settlementBookOtherDetailEntity.getWithholdingOther() +
                    settlementBookOtherDetailEntity.getDeductionsName() +
                    settlementBookOtherDetailEntity.getExtaxUnitpriceC().setScale(2, RoundingMode.HALF_UP) +
                    settlementBookOtherDetailEntity.getIntaxPriceC().setScale(2,RoundingMode.HALF_UP);
            SettlementBookOtherDetailVO settlementBookOtherDetailVO = otherDetailVOMap.get(key);
            if (settlementBookOtherDetailVO != null){
                //证明是带过来的数 这时需要比较有没有修改 如果修改则需要将这条数据做标记
                //保存数据的数量字段

            }else {
                //证明数据是新增的 这时无需比较 直接标记这条数据即可
            }
        }
        return entity;
    }
}
