/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookSummaryDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISubcontractCountersignedService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.middlemeasurement.api.CostApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.middlemeasurement.vo.OverusedeductionRequestVO;
import com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO;
import com.ejianc.foundation.middlemeasurement.vo.SubVO;
import com.ejianc.foundation.middlemeasurement.vo.SubVOList;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlementBook"})
public class SettlementBookController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SubcontractingApi subcontractingApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.CostApi")
    @Autowired
    private CostApi costApi;
    private static final String BILL_CODE = "settlementmanage-settlement-book";
    @Autowired
    private ISettlementBookService service;
    @Autowired
    private ISubcontractCountersignedService subcontractCountersignedService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementBookVO> saveOrUpdate(@RequestBody SettlementBookVO saveorUpdateVO) {
        OverusedeductionRequestVO overusedeductionRequestVO;
        Object list1;
        Object overusedeductionVO;
        Object list;
        SettlementBookEntity entity = (SettlementBookEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SettlementBookEntity.class));
        BigDecimal bigDecimal = new BigDecimal(0.0);
        BigDecimal bigDecimal1 = new BigDecimal(0.0);
        BigDecimal bigDecimal2 = new BigDecimal(0.0);
        BigDecimal bigDecimal3 = new BigDecimal(0.0);
        this.checkSubcontract(entity.getContractId());
        this.checkFormUniqueByMonth(entity);
        entity = this.checkBillCodeUniq(entity);
        List<SettlementBookStatementDetailEntity> settlementBookStatementDetailEntities = entity.getSettlementBookStatementDetailEntities();
        if (!settlementBookStatementDetailEntities.isEmpty() && settlementBookStatementDetailEntities.size() > 0) {
            String section;
            ArrayList<SubVOList> subVOList = new ArrayList<SubVOList>();
            for (SettlementBookStatementDetailEntity settlementBookStatementDetailEntity : settlementBookStatementDetailEntities) {
                String listingCode = settlementBookStatementDetailEntity.getListingCode();
                section = settlementBookStatementDetailEntity.getSection();
                Long contractId = entity.getContractId();
                SubVOList list2 = new SubVOList();
                list2.setSubitemCode(listingCode);
                list2.setSection(section);
                list2.setContractId(contractId);
                subVOList.add(list2);
            }
            CommonResponse amount = this.subcontractingApi.getAmount(subVOList);
            if (amount.getCode() == 0) {
                for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                    BigDecimal thisAmountsTax;
                    BigDecimal intaxAddition;
                    BigDecimal thisAmountsNotax;
                    BigDecimal extaxAddition;
                    BigDecimal thisQuantity;
                    BigDecimal quantities;
                    section = settlementBookStatementDetail.getSection();
                    String listingCode = settlementBookStatementDetail.getListingCode();
                    SubVO subVO = (SubVO)((Map)amount.getData()).get(listingCode + section);
                    if (subVO != null) {
                        BigDecimal quantities2;
                        BigDecimal examineCumulativeAmounts = subVO.getExamineCumulativeAmounts() == null ? new BigDecimal(0.0) : subVO.getExamineCumulativeAmounts();
                        BigDecimal examineCumulativeTaxAmounts = subVO.getExamineCumulativeTaxAmounts() == null ? new BigDecimal(0.0) : subVO.getExamineCumulativeTaxAmounts();
                        settlementBookStatementDetail.setAccruingAmountsNotax(examineCumulativeAmounts);
                        settlementBookStatementDetail.setAccruingAmountsTax(examineCumulativeTaxAmounts);
                        BigDecimal extaxAddition2 = settlementBookStatementDetail.getExtaxAddition() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getExtaxAddition();
                        BigDecimal intaxAddition2 = settlementBookStatementDetail.getIntaxAddition() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getIntaxAddition();
                        BigDecimal subtract = intaxAddition2.subtract(examineCumulativeTaxAmounts);
                        BigDecimal subtract1 = extaxAddition2.subtract(examineCumulativeAmounts);
                        settlementBookStatementDetail.setThisAmountsNotax(subtract1);
                        settlementBookStatementDetail.setThisAmountsTax(subtract);
                        BigDecimal examineCumulativeQuantity = subVO.getExamineCumulativeQuantity() == null ? new BigDecimal(0.0) : subVO.getExamineCumulativeQuantity();
                        settlementBookStatementDetail.setCumulativeEngineeringQuantity(examineCumulativeQuantity);
                        BigDecimal bigDecimal4 = quantities2 = settlementBookStatementDetail.getQuantities() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getQuantities();
                        if (examineCumulativeQuantity == null) {
                            BigDecimal thisQuantity2 = quantities2.subtract(new BigDecimal(0.0));
                            settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity2);
                            continue;
                        }
                        BigDecimal thisQuantity2 = quantities2.subtract(examineCumulativeQuantity);
                        settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity2);
                        continue;
                    }
                    BigDecimal bigDecimal5 = quantities = settlementBookStatementDetail.getQuantities() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getQuantities();
                    if (settlementBookStatementDetail.getCumulativeEngineeringQuantity() == null) {
                        thisQuantity = quantities.subtract(new BigDecimal(0.0));
                        settlementBookStatementDetail.setCumulativeEngineeringQuantity(new BigDecimal(0.0));
                        settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                    } else {
                        thisQuantity = quantities.subtract(settlementBookStatementDetail.getCumulativeEngineeringQuantity());
                        settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                    }
                    BigDecimal bigDecimal6 = extaxAddition = settlementBookStatementDetail.getExtaxAddition() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getExtaxAddition();
                    if (settlementBookStatementDetail.getAccruingAmountsNotax() == null) {
                        thisAmountsNotax = extaxAddition.subtract(new BigDecimal(0.0));
                        settlementBookStatementDetail.setAccruingAmountsNotax(new BigDecimal(0.0));
                        settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                    } else {
                        thisAmountsNotax = extaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsNotax());
                        settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                    }
                    BigDecimal bigDecimal7 = intaxAddition = settlementBookStatementDetail.getIntaxAddition() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getIntaxAddition();
                    if (settlementBookStatementDetail.getAccruingAmountsTax() == null) {
                        thisAmountsTax = intaxAddition.subtract(new BigDecimal(0.0));
                        settlementBookStatementDetail.setAccruingAmountsTax(new BigDecimal(0.0));
                        settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
                        continue;
                    }
                    thisAmountsTax = intaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsTax());
                    settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
                }
            }
            entity.setSettlementBookStatementDetailEntities(settlementBookStatementDetailEntities);
        }
        if (!entity.getSettlementBookMaterialDetailEntities().isEmpty() && entity.getSettlementBookMaterialDetailEntities().size() > 0) {
            list = new ArrayList();
            for (SettlementBookMaterialDetailEntity settlementBookMaterialDetailEntity : entity.getSettlementBookMaterialDetailEntities()) {
                overusedeductionVO = new com.ejianc.business.settlementmanage.vo.OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(settlementBookMaterialDetailEntity.getBillCodeB());
                overusedeductionVO.setSection(settlementBookMaterialDetailEntity.getSectionB());
                overusedeductionVO.setUnitPrice(settlementBookMaterialDetailEntity.getExtaxPurchasingpriceB());
                overusedeductionVO.setTaxUnitPrice(settlementBookMaterialDetailEntity.getIntaxPurchasingprice());
                list.add(overusedeductionVO);
            }
            list1 = BeanMapper.mapList(list, OverusedeductionVO.class);
            CommonResponse commonResponse = this.costApi.queryOveruse((List)list1);
            if (commonResponse.isSuccess()) {
                for (SettlementBookMaterialDetailEntity entity2 : entity.getSettlementBookMaterialDetailEntities()) {
                    overusedeductionRequestVO = (OverusedeductionRequestVO)((Map)commonResponse.getData()).get(entity2.getBillCodeB() + entity2.getSectionB() + entity2.getExtaxPurchasingpriceB() + entity2.getIntaxPurchasingprice());
                    if (overusedeductionRequestVO != null) {
                        entity2.setCumExtaxSectionprice(overusedeductionRequestVO.getAmounts());
                        entity2.setCumIntaxSectionprice(overusedeductionRequestVO.getTaxAmounts());
                        if (entity2.getExtaxSectionpriceB() == null) {
                            entity2.setCurExtaxSectionprice(new BigDecimal(0.0));
                        } else {
                            entity2.setCurExtaxSectionprice(entity2.getExtaxSectionpriceB().subtract(entity2.getCumExtaxSectionprice()));
                        }
                        if (entity2.getIntaxSectionprice() == null) {
                            entity2.setCurIntaxSectionprice(new BigDecimal(0.0));
                        } else {
                            entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                        }
                    } else {
                        entity2.setCumExtaxSectionprice(new BigDecimal(0.0));
                        entity2.setCumIntaxSectionprice(new BigDecimal(0.0));
                        entity2.setCurExtaxSectionprice(entity2.getExtaxSectionpriceB().subtract(entity2.getCumExtaxSectionprice()));
                        entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                    }
                    bigDecimal = bigDecimal.add(entity2.getCurExtaxSectionprice());
                    bigDecimal1 = bigDecimal1.add(entity2.getCurIntaxSectionprice());
                }
            }
        }
        if (!entity.getSettlementBookOtherDetailEntities().isEmpty() && entity.getSettlementBookOtherDetailEntities().size() > 0) {
            list = new ArrayList();
            for (SettlementBookOtherDetailEntity settlementBookOtherDetailEntity : entity.getSettlementBookOtherDetailEntities()) {
                overusedeductionVO = new com.ejianc.business.settlementmanage.vo.OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(settlementBookOtherDetailEntity.getWithholdingOther());
                overusedeductionVO.setSection(settlementBookOtherDetailEntity.getDeductionsName());
                overusedeductionVO.setUnitPrice(settlementBookOtherDetailEntity.getExtaxUnitpriceC());
                overusedeductionVO.setTaxUnitPrice(settlementBookOtherDetailEntity.getIntaxUnitpriceC());
                list.add(overusedeductionVO);
            }
            list1 = BeanMapper.mapList((Iterable)list, OverusedeductionVO.class);
            CommonResponse commonResponse = this.costApi.queryOther((List)list1);
            if (commonResponse.isSuccess()) {
                for (SettlementBookOtherDetailEntity entity4 : entity.getSettlementBookOtherDetailEntities()) {
                    overusedeductionRequestVO = (OverusedeductionRequestVO)((Map)commonResponse.getData()).get(entity4.getWithholdingOther() + entity4.getDeductionsName() + entity4.getExtaxUnitpriceC() + entity4.getIntaxUnitpriceC());
                    if (overusedeductionRequestVO != null) {
                        entity4.setCumExtaxPrice(overusedeductionRequestVO.getAmounts());
                        entity4.setCumIntaxPrice(overusedeductionRequestVO.getTaxAmounts());
                        if (entity4.getExtaxPriceC() == null) {
                            entity4.setCurExtaxPrice(new BigDecimal(0.0));
                        } else {
                            entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        }
                        if (entity4.getIntaxPriceC() == null) {
                            entity4.setCurIntaxPrice(new BigDecimal(0.0));
                        } else {
                            entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                        }
                    } else {
                        entity4.setCumExtaxPrice(new BigDecimal(0.0));
                        entity4.setCumIntaxPrice(new BigDecimal(0.0));
                        entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                    }
                    bigDecimal2 = bigDecimal2.add(entity4.getCurExtaxPrice());
                    bigDecimal3 = bigDecimal3.add(entity4.getCurIntaxPrice());
                }
            }
        }
        if (!entity.getSettlementBookSummaryDetailEntities().isEmpty() && entity.getSettlementBookSummaryDetailEntities().size() > 0) {
            for (SettlementBookSummaryDetailEntity entity5 : entity.getSettlementBookSummaryDetailEntities()) {
                if (entity5.getProjectName().equals("\u6750\u6599\u8282\u8d85")) {
                    entity5.setExtaxPrice(bigDecimal);
                    entity5.setIntaxPrice(bigDecimal1);
                }
                if (!entity5.getProjectName().equals("\u5176\u4ed6\u6263\u6b3e")) continue;
                entity5.setExtaxPrice(bigDecimal2);
                entity5.setIntaxPrice(bigDecimal3);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SettlementBookVO vo = (SettlementBookVO)((Object)BeanMapper.map((Object)((Object)entity), SettlementBookVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private void checkSubcontract(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pro = this.subcontractCountersignedService.list((Wrapper)queryWrapper);
        if (pro.isEmpty()) {
            throw new BusinessException("\u8bf7\u5148\u521b\u5efa\"\u5206\u5305\u7ed3\u7b97\u6761\u4ef6\u4f1a\u7b7e\u5355\"!");
        }
    }

    private void checkFormUniqueByMonth(SettlementBookEntity entity) {
        int count1;
        int count;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        String date = sf.format(entity.getOrderMonth());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrapper.le((Object)"DATE_FORMAT( order_month, '%Y-%m' )", (Object)date);
        queryWrapper.eq((Object)"bill_state", (Object)0);
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((count = this.service.count((Wrapper)queryWrapper)) > 0) {
            throw new BusinessException("\u6b64\u5408\u540c\u5b58\u5728\u5f80\u671f\u5df2\u4fdd\u5b58\u672a\u63d0\u4ea4\u7ed3\u7b97\u5355,\u8bf7\u5148\u63d0\u4ea4\u5f80\u671f\u672a\u63d0\u4ea4\u7ed3\u7b97\u5355");
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrapper1.eq((Object)"DATE_FORMAT( order_month, '%Y-%m' )", (Object)date);
        if (entity.getId() != null) {
            queryWrapper1.ne((Object)"id", (Object)entity.getId());
        }
        if ((count1 = this.service.count((Wrapper)queryWrapper1)) > 0) {
            throw new BusinessException("\u6b64\u5408\u540c\u5f53\u524d\u6708\u4efd\u5df2\u5b58\u5728\u7ed3\u7b97\u5355\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SettlementBookEntity checkBillCodeUniq(SettlementBookEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            if (entity.getId() != null && entity.getId() != 0L) {
                queryWrapperBillCode.ne((Object)"id", (Object)entity.getId());
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)).size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementBookVO> queryDetail(Long id) {
        SettlementBookEntity entity = (SettlementBookEntity)((Object)this.service.selectById(id));
        SettlementBookVO vo = (SettlementBookVO)((Object)BeanMapper.map((Object)((Object)entity), SettlementBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementBookVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List settlementBookVOList = BeanMapper.mapList((Iterable)list, SettlementBookVO.class);
        for (int i = 0; i < settlementBookVOList.size(); ++i) {
            String billStateStr;
            SettlementBookVO settlementBookVO = (SettlementBookVO)((Object)settlementBookVOList.get(i));
            if (settlementBookVO.getCreateTime() != null) {
                settlementBookVO.setCreateTimeShow(DateUtils.dateSimple2(settlementBookVO.getCreateTime()));
            }
            if ((billStateStr = settlementBookVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u9a73\u56de";
            }
            settlementBookVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", settlementBookVOList);
        ExcelExport.getInstance().export("SettlementBook-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettlementBookData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> refSettlementBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/querySubcontractingvolumeByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, List>> querySubcontractingvolumeMaterialByContractId(@RequestParam(value="contractId") Long contractId) {
        HashMap map = new HashMap();
        List statementDetailVOList = new ArrayList();
        CommonResponse statementResponse = this.subcontractingvolumeApi.querySubcontractingvolumeDetailByContractId(contractId);
        if (statementResponse.isSuccess()) {
            List data = (List)statementResponse.getData();
            statementDetailVOList = BeanMapper.mapList((Iterable)data, SettlementBookStatementDetailVO.class);
            for (SettlementBookStatementDetailVO VO : statementDetailVOList) {
                VO.setId(IdWorker.getId());
                VO.setIsDeleted("\u5426");
            }
        } else {
            throw new BusinessException(statementResponse.getMsg());
        }
        map.put("statementDetailVOList", statementDetailVOList);
        List materialDetailVOList = new ArrayList();
        CommonResponse materialResponse = this.subcontractingvolumeApi.querySubcontractingvolumeMaterialByContractId(contractId);
        if (materialResponse.isSuccess()) {
            List data = (List)materialResponse.getData();
            materialDetailVOList = BeanMapper.mapList((Iterable)data, SettlementBookMaterialDetailVO.class);
            for (SettlementBookMaterialDetailVO settlementBookMaterialDetailVO : materialDetailVOList) {
                settlementBookMaterialDetailVO.setIsEditState("\u5426");
            }
        } else {
            throw new BusinessException(materialResponse.getMsg());
        }
        map.put("materialDetailVOList", materialDetailVOList);
        List otherDetailVOArrayList = new ArrayList();
        CommonResponse otherResponse = this.subcontractingvolumeApi.querySubcontractingvolumeOtherByContractId(contractId);
        if (otherResponse.isSuccess()) {
            List data = (List)otherResponse.getData();
            otherDetailVOArrayList = BeanMapper.mapList((Iterable)data, SettlementBookOtherDetailVO.class);
            for (SettlementBookOtherDetailVO settlementBookOtherDetailVO : otherDetailVOArrayList) {
                settlementBookOtherDetailVO.setId(IdWorker.getId());
                settlementBookOtherDetailVO.setIsEditState("\u5426");
            }
        } else {
            throw new BusinessException(otherResponse.getMsg());
        }
        map.put("otherDetailVOArrayList", otherDetailVOArrayList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u6708\u5ea6\u62a5\u91cf\u76f8\u5173\u6570\u636e\u6210\u529f", map);
    }
}

