/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"settlementBookOtherExport"})
public class ExcelSettlementBookOtherController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookOtherDetailService otherDetailService;

    @RequestMapping(value={"/exportOtherFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportOtherFromPage(@RequestBody List<SettlementBookOtherDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SettlementBookOtherDetailVO detailVO = list.get(i);
                detailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List<SettlementBookOtherDetailVO>> beans = new HashMap<String, List<SettlementBookOtherDetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookOtherDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/exportOtherFromDataBase"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportOtherFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)settlementBookVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.otherDetailService.list((Wrapper)queryWrapper);
        List detailVOList = BeanMapper.mapList((Iterable)list, SettlementBookOtherDetailVO.class);
        if (detailVOList != null && detailVOList.size() > 0) {
            for (int i = 0; i < detailVOList.size(); ++i) {
                SettlementBookOtherDetailVO detailVO = (SettlementBookOtherDetailVO)((Object)detailVOList.get(i));
                detailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settlementBookOtherDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/otherExcelDown"})
    @ResponseBody
    public void otherExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"settlementBookOtherDetail-import.xlsx", (String)"\u5de5\u7a0b\u91cf\u4f9d\u636e\u6a21\u677f");
    }

    @RequestMapping(value={"/otherExcelUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> otherExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SettlementBookOtherDetailVO> successList = new ArrayList<SettlementBookOtherDetailVO>();
        ArrayList<SettlementBookOtherDetailVO> errorList = new ArrayList<SettlementBookOtherDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal numberC;
                List datas = (List)result.get(i);
                String withholdingOther = (String)datas.get(1);
                String deductionsName = (String)datas.get(2);
                String units = (String)datas.get(3);
                String number = (String)datas.get(4);
                String extaxUnitprice = (String)datas.get(5);
                String intaxUnitprice = (String)datas.get(6);
                String extaxprice = (String)datas.get(7);
                String intaxprice = (String)datas.get(8);
                String remarks = (String)datas.get(9);
                SettlementBookOtherDetailVO otherDetailVO = new SettlementBookOtherDetailVO();
                otherDetailVO.setId(IdWorker.getId());
                otherDetailVO.setSort(Long.valueOf(i));
                otherDetailVO.setWithholdingOther(withholdingOther);
                otherDetailVO.setUnitsC(units);
                otherDetailVO.setDeductionsName(deductionsName);
                otherDetailVO.setRemarksC(remarks);
                if (StringUtils.isBlank((CharSequence)deductionsName)) {
                    otherDetailVO.setErrorMsg("\u6263\u6b3e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(otherDetailVO);
                    continue;
                }
                otherDetailVO.setDeductionsName(deductionsName);
                if (StringUtils.isBlank((CharSequence)number)) {
                    otherDetailVO.setErrorMsg("'\u6570\u91cf'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(otherDetailVO);
                    continue;
                }
                if (!NumberUtil.isNumber((String)number)) {
                    otherDetailVO.setErrorMsg("'\u6570\u91cf'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(otherDetailVO);
                    continue;
                }
                otherDetailVO.setNumber(new BigDecimal(number));
                if (StringUtils.isBlank((CharSequence)extaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(otherDetailVO);
                    continue;
                }
                if (!NumberUtil.isNumber((String)extaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef");
                    errorList.add(otherDetailVO);
                    continue;
                }
                otherDetailVO.setExtaxUnitpriceC(new BigDecimal(extaxUnitprice));
                if (StringUtils.isBlank((CharSequence)intaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(otherDetailVO);
                    continue;
                }
                if (!NumberUtil.isNumber((String)intaxUnitprice)) {
                    otherDetailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef");
                    errorList.add(otherDetailVO);
                    continue;
                }
                otherDetailVO.setIntaxUnitpriceC(new BigDecimal(intaxUnitprice));
                if (StringUtils.isBlank((CharSequence)extaxprice)) {
                    BigDecimal extaxUnitpriceC = otherDetailVO.getExtaxUnitpriceC();
                    numberC = otherDetailVO.getNumber();
                    BigDecimal extaxPriceB = extaxUnitpriceC.multiply(numberC);
                    otherDetailVO.setExtaxPriceC(extaxPriceB);
                } else {
                    if (!NumberUtil.isNumber((String)extaxprice)) {
                        otherDetailVO.setErrorMsg("\u9664\u7a0e\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                        errorList.add(otherDetailVO);
                        continue;
                    }
                    otherDetailVO.setExtaxPriceC(new BigDecimal(extaxprice));
                }
                if (StringUtils.isBlank((CharSequence)intaxprice)) {
                    BigDecimal intaxUnitpriceC = otherDetailVO.getIntaxUnitpriceC();
                    numberC = otherDetailVO.getNumber();
                    BigDecimal intaxPriceB = intaxUnitpriceC.multiply(numberC);
                    otherDetailVO.setIntaxPriceC(intaxPriceB);
                } else {
                    if (!NumberUtil.isNumber((String)intaxprice)) {
                        otherDetailVO.setErrorMsg("\u542b\u7a0e\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                        errorList.add(otherDetailVO);
                        continue;
                    }
                    otherDetailVO.setIntaxPriceC(new BigDecimal(intaxprice));
                }
                successList.add(otherDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

