/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.ConsultotherfinalEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalodetailEntity;
import com.ejianc.business.settlementmanage.mapper.ConsultotherfinalMapper;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalService;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="consultotherfinalService")
public class ConsultotherfinalServiceImpl
extends BaseServiceImpl<ConsultotherfinalMapper, ConsultotherfinalEntity>
implements IConsultotherfinalService {
    @Autowired
    private ConsultotherfinalMapper mapper;
    @Autowired
    private DesignAndConsultApi designAndConsultApi;

    @Override
    public BigDecimal queryConsultotherfinal(Long projectId, String monthStr) {
        BigDecimal curExtaxPrice = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS = this.mapper.queryConsultotherfinal(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.add(totalPrice);
        }
        List<CostManageVO> costManageVOS1 = this.mapper.queryConsultotherfinaloDetail(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS1) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.subtract(totalPrice);
        }
        return curExtaxPrice;
    }

    @Override
    public ConsultotherfinalEntity calculateDetailCurrentAmount(ConsultotherfinalEntity entity) {
        List<ConsultotherfinalodetailEntity> consultotherfinalodetailEntities;
        List<ConsultotherfinaldetailEntity> consultotherfinaldetailEntities = entity.getConsultotherfinaldetailEntities();
        if (!consultotherfinaldetailEntities.isEmpty()) {
            for (ConsultotherfinaldetailEntity consultotherfinaldetailEntity : consultotherfinaldetailEntities) {
                if ("del".equals(consultotherfinaldetailEntity.getRowState())) continue;
                BigDecimal cumExtaxPrice = consultotherfinaldetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumExtaxPrice();
                BigDecimal cumIntaxPrice = consultotherfinaldetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumIntaxPrice();
                consultotherfinaldetailEntity.setCurExtaxPrice(consultotherfinaldetailEntity.getAmounts().subtract(cumExtaxPrice));
                consultotherfinaldetailEntity.setCurIntaxPrice(consultotherfinaldetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
            }
        }
        if (!(consultotherfinalodetailEntities = entity.getConsultotherfinalodetailEntities()).isEmpty()) {
            for (ConsultotherfinalodetailEntity consultotherfinalodetailEntity : consultotherfinalodetailEntities) {
                if ("del".equals(consultotherfinalodetailEntity.getRowState())) continue;
                BigDecimal cumExtaxPrice = consultotherfinalodetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumExtaxPrice();
                BigDecimal cumIntaxPrice = consultotherfinalodetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumIntaxPrice();
                consultotherfinalodetailEntity.setCurExtaxPrice(consultotherfinalodetailEntity.getAmounts().subtract(cumExtaxPrice));
                consultotherfinalodetailEntity.setCurIntaxPrice(consultotherfinalodetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
            }
        }
        return entity;
    }

    @Override
    public Map<String, ConsultotherfinaldetailVO> queryConsultDetailCumPastMap(Long contractId, String date) {
        HashMap<String, ConsultotherfinaldetailVO> map = new HashMap<String, ConsultotherfinaldetailVO>();
        CommonResponse listCommonResponse = this.designAndConsultApi.queryConsultDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()) {
            List consultotherfinaldetailVOS = BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), ConsultotherfinaldetailVO.class);
            for (ConsultotherfinaldetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getSubitemName() + consultotherfinaldetailVO.getUnitprice().setScale(2, 4) + consultotherfinaldetailVO.getTaxUnitprice().setScale(2, 4);
                map.put(key, consultotherfinaldetailVO);
            }
        } else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public Map<String, ConsultotherfinalodetailVO> queryConsultOtherDetailCumPastMap(Long contractId, String date) {
        HashMap<String, ConsultotherfinalodetailVO> map = new HashMap<String, ConsultotherfinalodetailVO>();
        CommonResponse listCommonResponse = this.designAndConsultApi.queryConsultOtherDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()) {
            List consultotherfinaldetailVOS = BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), ConsultotherfinalodetailVO.class);
            for (ConsultotherfinalodetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getExpenseName() + consultotherfinaldetailVO.getoUnitPrice().setScale(2, 4) + consultotherfinaldetailVO.getoTaxUnitPrice().setScale(2, 4);
                map.put(key, consultotherfinaldetailVO);
            }
        } else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }
}

