/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.mapper.SettlementBookMapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookMaterialDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.RoundingMode;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementBookService")
public class SettlementBookServiceImpl
extends BaseServiceImpl<SettlementBookMapper, SettlementBookEntity>
implements ISettlementBookService {
    @Autowired
    private ISettlementBookMaterialDetailService materialDetailService;
    @Autowired
    private ISettlementBookOtherDetailService otherDetailService;

    @Override
    public SettlementBookEntity checkMaterialAndOtherFromSubcontractingvolume(SettlementBookEntity entity) {
        Map<String, SettlementBookMaterialDetailVO> materialMap = this.materialDetailService.querySubcontractingvolumeMaterialByContractId(entity.getContractId());
        for (SettlementBookMaterialDetailEntity settlementBookMaterialDetailEntity : entity.getSettlementBookMaterialDetailEntities()) {
            Long sectionNumBOriginal;
            Long sectionNumB;
            String key = settlementBookMaterialDetailEntity.getBillCodeB() + settlementBookMaterialDetailEntity.getSectionB() + settlementBookMaterialDetailEntity.getExtaxPurchasingpriceB().setScale(2, RoundingMode.HALF_UP) + settlementBookMaterialDetailEntity.getIntaxPurchasingprice().setScale(2, RoundingMode.HALF_UP);
            SettlementBookMaterialDetailVO settlementBookMaterialDetailVO = materialMap.get(key);
            if (settlementBookMaterialDetailVO != null && (sectionNumB = Long.valueOf(settlementBookMaterialDetailEntity.getSectionNumB() == null ? 0L : settlementBookMaterialDetailEntity.getSectionNumB())).equals(sectionNumBOriginal = Long.valueOf(settlementBookMaterialDetailVO.getSectionNumB() == null ? 0L : settlementBookMaterialDetailVO.getSectionNumB()))) continue;
        }
        Map<String, SettlementBookOtherDetailVO> otherDetailVOMap = this.otherDetailService.querySubcontractingvolumeOtherByContractId(entity.getContractId());
        for (SettlementBookOtherDetailEntity settlementBookOtherDetailEntity : entity.getSettlementBookOtherDetailEntities()) {
            String key = settlementBookOtherDetailEntity.getWithholdingOther() + settlementBookOtherDetailEntity.getDeductionsName() + settlementBookOtherDetailEntity.getExtaxUnitpriceC().setScale(2, RoundingMode.HALF_UP) + settlementBookOtherDetailEntity.getIntaxPriceC().setScale(2, RoundingMode.HALF_UP);
            SettlementBookOtherDetailVO settlementBookOtherDetailVO = otherDetailVOMap.get(key);
            if (settlementBookOtherDetailVO == null) continue;
        }
        return entity;
    }
}

