package com.ejianc.business.settlementmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.service.*;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinalOtherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinaldetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 咨询及其他类合同最终结算单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("consultotherfinal")
public class ConsultotherfinalController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;

	@Autowired
	private IOutcontractApi outcontractApi;
	@Autowired
	private DesignAndConsultApi designAndConsultApi;

	@Autowired
	private SessionManager sessionManager;

	private static final String BILL_CODE = "Subcontractingvolume_Open_Apply_Code";// 此处需要根据实际修改

	@Autowired
	private IConsultotherfinalService service;
	@Autowired
	private IConsultotherfinaldetailService consultotherfinaldetailService;
	@Autowired
	private IConsultotherfinalodetailService consultotherfinalodetailService;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<ConsultotherfinalVO> saveOrUpdate(@RequestBody ConsultotherfinalVO saveorUpdateVO) {
		ConsultotherfinalEntity entity = BeanMapper.map(saveorUpdateVO, ConsultotherfinalEntity.class);

		//校验：同一合同，只能存在一份自由态或审批中的单据
		checkBillStateUniq(entity.getId(), entity.getContractId(), true);

		//校验：单据编号唯一性
		entity = checkBillCodeUniq(entity);
		entity = service.totalForm(entity);
		service.saveOrUpdate(entity, false);
		ConsultotherfinalVO vo = BeanMapper.map(entity, ConsultotherfinalVO.class);

		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * 同一合同，只能存在一份自由态或审批中的单据
	 * @param id
	 * @param contractId
	 * @param isShowError 是否需要校验（初始化数据不需要，切换合同或保存需要）
	 */
	private void checkBillStateUniq(Long id, Long contractId, boolean isShowError) {
		//创建条件构造器
		QueryWrapper<ConsultotherfinalEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
		queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		if(id != null){
			queryWrapper.ne("id", id);
		}
		List<ConsultotherfinalEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			throw new BusinessException("同一合同只能存在一份自由态或审批中的\"咨询及其他类合同最终结算单\"!");
		}
	}

	/**
	 * 单据编码唯一性校验
	 * @param entity
	 */
	private ConsultotherfinalEntity checkBillCodeUniq(ConsultotherfinalEntity entity) {
		if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
			if(billCode.isSuccess()) {
				entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}else {
			//单据编码唯一性
			QueryWrapper<ConsultotherfinalEntity> queryWrapperBillCode = new QueryWrapper<>();
			queryWrapperBillCode.eq("bill_code", entity.getBillCode());
			queryWrapperBillCode.eq("dr", "0");
			Long id = entity.getId();
			if(id != null){
				queryWrapperBillCode.ne("id", id);
			}
			List<ConsultotherfinalEntity> proBillCode = service.list(queryWrapperBillCode);
			if(proBillCode != null && proBillCode.size() > 0){
				throw new BusinessException("单据编码已存在，请重新录入!");
			}
		}

		return entity;
	}

	/**
	 * 页面子表新增参照合同价后
	 * 查询累计
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/refreshDetailData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> refreshDetailData(@RequestBody List<ConsultotherfinaldetailVO> list, HttpServletResponse response) {
		JSONObject json = new JSONObject();

		for (int i = 0; i < list.size(); i++) {
			ConsultotherfinaldetailVO sonsultotherdetailVO = list.get(i);
			String rowState = sonsultotherdetailVO.getRowState();
			if("add".equals(rowState)){
				//查询该清单编码往期累计
				//创建条件构造器
				QueryWrapper<ConsultotherfinaldetailEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("contract_id", sonsultotherdetailVO.getContractId());
				queryWrapper.eq("subitem_name", sonsultotherdetailVO.getSubitemName());
				queryWrapper.eq("spec", sonsultotherdetailVO.getSpec());
				queryWrapper.eq("unit", sonsultotherdetailVO.getUnit());
				queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
				queryWrapper.eq("dr", "0");
				queryWrapper.orderByDesc("create_time");//最新往期
				queryWrapper.last("limit 1");
				List<ConsultotherfinaldetailEntity> pastDetails = consultotherfinaldetailService.list(queryWrapper);
				if(pastDetails != null && pastDetails.size() > 0){
					ConsultotherfinaldetailEntity pastSubcontractingvolumedetail = pastDetails.get(0);
					//数量（分包商上报累计）
					sonsultotherdetailVO.setCumulativeQuantity(pastSubcontractingvolumedetail.getCumulativeQuantity());
					//除税金额（分包商上报累计）
					sonsultotherdetailVO.setCumulativeAmounts(pastSubcontractingvolumedetail.getCumulativeAmounts());
					//含税金额（分包商上报累计）
					sonsultotherdetailVO.setCumulativeTaxAmounts(pastSubcontractingvolumedetail.getCumulativeTaxAmounts());
					//数量（项目部审核累计）
					sonsultotherdetailVO.setExamineCumulativeQuantity(pastSubcontractingvolumedetail.getExamineCumulativeQuantity());
					//除税金额（项目部审核累计）
					sonsultotherdetailVO.setExamineCumulativeAmounts(pastSubcontractingvolumedetail.getExamineCumulativeAmounts());
					//含税金额（项目部审核累计）
					sonsultotherdetailVO.setExamineCumulativeTaxAmounts(pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts());
				}

				sonsultotherdetailVO.setRowState("edit");
			}
		}

		json.put("dataSource", list);

		return CommonResponse.success(json);
	}

	/**
	 * @Description  查询往期
	 * @param contractId
	 */
	@RequestMapping(value = "/pastData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ConsultotherfinalVO> pastData(Long id, Long contractId, boolean isShowError) {
		if(isShowError){
			//校验：同一合同，只能存在一份自由态或审批中的单据
			checkBillStateUniq(id, contractId, isShowError);
		}

		//本期日期
		Date currentDate = new Date(System.currentTimeMillis());
		if(id != null && "".equals(id)){//更新
			ConsultotherfinalEntity entity = service.selectById(id);
			currentDate = entity.getCreateTime();
		}

		return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
	}

	/**
	 * 获取往期审批通过的合计数据
	 *
	 * @param contractId 合同id
	 * @param currentDate 本期日期
	 */
	private ConsultotherfinalVO getPastTotalData(Long contractId, Date currentDate) {
		//创建条件构造器
		QueryWrapper<ConsultotherfinalEntity> queryWrapperTotal = new QueryWrapper<>();
		queryWrapperTotal.eq("contract_id", contractId);
		queryWrapperTotal.eq("dr", 0);
		queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
		queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
		queryWrapperTotal.orderByDesc("create_time");
		queryWrapperTotal.last("limit 1");

		List<ConsultotherfinalEntity> proTotal = service.list(queryWrapperTotal);

		ConsultotherfinalVO vo = new ConsultotherfinalVO();
		if(proTotal != null && proTotal.size() > 0){
			ConsultotherfinalEntity pastEntity = proTotal.get(0);
			vo = BeanMapper.map(pastEntity, ConsultotherfinalVO.class);
		}

		vo.setContractId(contractId);
		return vo;
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ConsultotherfinalVO> queryDetail(Long id) {
		ConsultotherfinalEntity entity = service.selectById(id);
		ConsultotherfinalVO vo = BeanMapper.map(entity, ConsultotherfinalVO.class);

		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<ConsultotherfinalVO> vos) {
		service.removeByIds(vos.stream().map(ConsultotherfinalVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<ConsultotherfinalVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		IPage<ConsultotherfinalEntity> page = service.queryPage(param, false);
		IPage<ConsultotherfinalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsultotherfinalVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * @Description 导出
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);
		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
		List<ConsultotherfinalEntity> list = service.queryList(param);
		//时间转换
		List<ConsultotherfinalVO> consultotherfinalVOList = BeanMapper.mapList(list, ConsultotherfinalVO.class);
		for (int i = 0; i < consultotherfinalVOList.size(); i++) {
			ConsultotherfinalVO consultotherfinalVO = consultotherfinalVOList.get(i);
			consultotherfinalVO.setSort(String.valueOf(i+1));
			if (consultotherfinalVO.getReportingTime()!=null){
				consultotherfinalVO.setReportingTimeShow(DateUtils.dateSimple2(consultotherfinalVO.getReportingTime()));
			}

			String billStateStr = consultotherfinalVO.getBillState().toString();
			if (billStateStr != null){
				if("0".equals(billStateStr)){//自由态
					billStateStr = "自由态";
				}else if("1".equals(billStateStr)){//已提交
					billStateStr = "已提交";
				}else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
					billStateStr = "审批中";
				}else if("3".equals(billStateStr)){//审批通过
					billStateStr = "审批通过";
				}else if("4".equals(billStateStr)){//驳回
					billStateStr = "驳回";
				}

				consultotherfinalVO.setBillStateStr(billStateStr);
			}
		}
		// todo:字段翻译等等
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", consultotherfinalVOList);
		ExcelExport.getInstance().export("consultother-export.xlsx", beans, response);
	}

	/**
	 * 获取RPC数据
	 * resp 返回值
	 * isMustSuc 是否必须成功
	 * errMsg 失败提示
	 */
	private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
		if(isMustSuc && !resp.isSuccess()) {
			throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
		}
		return resp.getData();
	}


	/**
	 * @Description 参照
	 * @param
	 * @Return void
	 */
	@RequestMapping(value = "/refSubcontractingvolumeData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<ConsultotherfinalVO>> refSubcontractingvolumeData(@RequestParam Integer pageNumber,
																				  @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
		QueryParam param = new QueryParam();
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");

		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			if(_con.get("projectId")!=null){
				param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
			}
		}

		//未被引用
		param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

		//审批通过
		param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

		IPage<ConsultotherfinalEntity> page = service.queryPage(param, false);
		IPage<ConsultotherfinalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<ConsultotherfinalVO> consultotherfinalVOList = BeanMapper.mapList(page.getRecords(), ConsultotherfinalVO.class);

		pageData.setRecords(consultotherfinalVOList);

		return CommonResponse.success("查询参照数据成功！", pageData);
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, ConsultotherfinaldetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			if (pcode.length() == 2) {
				//最上级
				return null;
			} else if (pcode.length() == 4) {
				String ppcode = pcode.substring(0, 2);
				return this.setPid(ppcode, map);
			} else if (pcode.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode, map);
			} else if (pcode.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode, map);
			} else {
				return null;
			}
		}
	}

	/**
	 * 根据合同id和日期查询往期过程单的子表和其他扣款的往期累计数据
	 * @param contractId
	 * @param date
	 * @return
	 */
	@RequestMapping(value = "/queryPastData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Map<String,List>> queryPastData(@RequestParam(value = "contractId") Long contractId,@RequestParam(value = "date") String date){
		Map<String,List> map = new HashMap<>();
		CommonResponse<List<ConsultfinaldetailVO>> listCommonResponse =
				designAndConsultApi.queryConsultDetailCumPast(contractId, date);
		if (listCommonResponse.isSuccess()){
			List<ConsultotherfinaldetailVO> consultotherfinaldetailVOS =
					BeanMapper.mapList(listCommonResponse.getData(), ConsultotherfinaldetailVO.class);
			for (ConsultotherfinaldetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
				consultotherfinaldetailVO.setIsEditState("否");
			}
			map.put("consultotherfinaldetailVOS",consultotherfinaldetailVOS);
		}else {
			throw new BusinessException(listCommonResponse.getMsg());
		}
		CommonResponse<List<ConsultfinalOtherdetailVO>> listCommonResponse1 =
				designAndConsultApi.queryConsultOtherDetailCumPast(contractId, date);
		if (listCommonResponse1.isSuccess()){
			List<ConsultotherfinalodetailVO> consultotherfinalodetailVOS =
					BeanMapper.mapList(listCommonResponse1.getData(), ConsultotherfinalodetailVO.class);
			for (ConsultotherfinalodetailVO consultotherfinalodetailVO : consultotherfinalodetailVOS) {
				consultotherfinalodetailVO.setIsEditState("否");
			}
			map.put("consultotherfinalodetailVOS",consultotherfinalodetailVOS);
		}else {
			throw new BusinessException(listCommonResponse1.getMsg());
		}
		return CommonResponse.success("查询咨询类往期数据成功",map);
	}
}
