package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.mapper.ConsultotherfinaldetailMapper;
import com.ejianc.business.settlementmanage.service.IConsultotherfinaldetailService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 咨询及其他类合同最终结算单-计价明细
 *
 * @author generator
 *
 */
@Service("consultotherfinaldetailService")
public class ConsultotherfinaldetailServiceImpl extends BaseServiceImpl<ConsultotherfinaldetailMapper, ConsultotherfinaldetailEntity> implements IConsultotherfinaldetailService{

    @Override
    public Map<String, BigDecimal> totalForm(List<ConsultotherfinaldetailEntity> list) {
        Map<String, BigDecimal> map = new HashMap<>();
        //本期合计除税
        BigDecimal currentTotal = BigDecimal.ZERO;
        //本期合计含税
        BigDecimal currentTaxTotal = BigDecimal.ZERO;
        //累计合计除税
        BigDecimal cumulativeAmounts = BigDecimal.ZERO;
        //累计合计含税
        BigDecimal cumulativeTaxAmounts = BigDecimal.ZERO;
        //本期合同内合计除税
        BigDecimal currentTotalContract = BigDecimal.ZERO;
        //本期合同内合计含税
        BigDecimal currentTaxTotalContract = BigDecimal.ZERO;
        //累计合同外合计除税
        BigDecimal cumulativeAmountsContract = BigDecimal.ZERO;
        //累计合同外合计含税
        BigDecimal cumulativeTaxAmountsContract = BigDecimal.ZERO;
        //本期合同外合计除税
        BigDecimal currentTotalContractOut = BigDecimal.ZERO;
        //本期合同外合计含税
        BigDecimal currentTaxTotalContractOut = BigDecimal.ZERO;
        //累计合同外合计除税
        BigDecimal cumulativeAmountsContractOut = BigDecimal.ZERO;
        //累计合同外合计含税
        BigDecimal cumulativeTaxAmountsContractOut = BigDecimal.ZERO;
        if (!list.isEmpty()){
            for (ConsultotherfinaldetailEntity entity : list) {
                currentTotal = currentTotal.add(BigDecimalUtils.ofNullable(entity.getCurExtaxPrice()));
                currentTaxTotal = currentTaxTotal.add(BigDecimalUtils.ofNullable(entity.getCurIntaxPrice()));
                cumulativeAmounts = cumulativeAmounts.add(BigDecimalUtils.ofNullable(entity.getAmounts()));
                cumulativeTaxAmounts = cumulativeTaxAmounts.add(BigDecimalUtils.ofNullable(entity.getTaxAmounts()));
                if ("1".equals(entity.getSource())){
                    currentTotalContract = currentTotalContract.add(BigDecimalUtils.ofNullable(entity.getCurExtaxPrice()));
                    currentTaxTotalContract = currentTaxTotalContract.add(BigDecimalUtils.ofNullable(entity.getCurIntaxPrice()));
                    cumulativeAmountsContract = cumulativeAmountsContract.add(BigDecimalUtils.ofNullable(entity.getAmounts()));
                    cumulativeTaxAmountsContract = cumulativeTaxAmountsContract.add(BigDecimalUtils.ofNullable(entity.getTaxAmounts()));
                }else if ("2".equals(entity.getSource())){
                    currentTotalContractOut = currentTotalContractOut.add(BigDecimalUtils.ofNullable(entity.getCurExtaxPrice()));
                    currentTaxTotalContractOut = currentTaxTotalContractOut.add(BigDecimalUtils.ofNullable(entity.getCurIntaxPrice()));
                    cumulativeAmountsContractOut = cumulativeAmountsContractOut.add(BigDecimalUtils.ofNullable(entity.getAmounts()));
                    cumulativeTaxAmountsContractOut = cumulativeTaxAmountsContractOut.add(BigDecimalUtils.ofNullable(entity.getTaxAmounts()));
                }
            }
        }
        map.put("currentTotal",currentTotal);
        map.put("currentTaxTotal",currentTaxTotal);
        map.put("cumulativeAmounts",cumulativeAmounts);
        map.put("cumulativeTaxAmounts",cumulativeTaxAmounts);
        map.put("currentTotalContract",currentTotalContract);
        map.put("currentTaxTotalContract",currentTaxTotalContract);
        map.put("cumulativeAmountsContract",cumulativeAmountsContract);
        map.put("cumulativeTaxAmountsContract",cumulativeTaxAmountsContract);
        map.put("currentTotalContractOut",currentTotalContractOut);
        map.put("currentTaxTotalContractOut",currentTaxTotalContractOut);
        map.put("cumulativeAmountsContractOut",cumulativeAmountsContractOut);
        map.put("cumulativeTaxAmountsContractOut",cumulativeTaxAmountsContractOut);
        return map;
    }
}
