package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.ConsultotherfinalodetailEntity;
import com.ejianc.business.settlementmanage.mapper.ConsultotherfinalodetailMapper;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalodetailService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 咨询及其他类合同最终结算单-其他扣款
 *
 * @author generator
 *
 */
@Service("consultotherfinalodetailService")
public class ConsultotherfinalodetailServiceImpl extends BaseServiceImpl<ConsultotherfinalodetailMapper, ConsultotherfinalodetailEntity> implements IConsultotherfinalodetailService {

    @Override
    public Map<String, BigDecimal> totalForm(List<ConsultotherfinalodetailEntity> list) {
        Map<String, BigDecimal> map = new HashMap<>();
        //本期合计除税
        BigDecimal currentTotal = BigDecimal.ZERO;
        //本期合计含税
        BigDecimal currentTaxTotal = BigDecimal.ZERO;
        //累计合计除税
        BigDecimal cumulativeAmounts = BigDecimal.ZERO;
        //累计合计含税
        BigDecimal cumulativeTaxAmounts = BigDecimal.ZERO;
        for (ConsultotherfinalodetailEntity entity : list) {
            currentTotal = currentTotal.add(BigDecimalUtils.ofNullable(entity.getCurExtaxPrice()));
            currentTaxTotal = currentTaxTotal.add(BigDecimalUtils.ofNullable(entity.getCurIntaxPrice()));
            cumulativeAmounts = cumulativeAmounts.add(BigDecimalUtils.ofNullable(entity.getAmounts()));
            cumulativeTaxAmounts = cumulativeTaxAmounts.add(BigDecimalUtils.ofNullable(entity.getTaxAmounts()));
        }
        map.put("currentTotal",currentTotal);
        map.put("currentTaxTotal",currentTaxTotal);
        map.put("cumulativeAmounts",cumulativeAmounts);
        map.put("cumulativeTaxAmounts",cumulativeTaxAmounts);
        return map;
    }
}
