package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.vo.LaborCostVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.SettlementBookStatementDetailMapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;

import java.util.List;

/**
 * 工程分包结算书子表-收入明细表-工程量清单结算表
 * 
 * @author generator
 * 
 */
@Service("settlementBookStatementDetailService")
public class SettlementBookStatementDetailServiceImpl extends BaseServiceImpl<SettlementBookStatementDetailMapper, SettlementBookStatementDetailEntity> implements ISettlementBookStatementDetailService{

    @Autowired
    private SettlementBookStatementDetailMapper settlementBookStatementDetailMapper;

    @Override
    public LaborCostVO getEngineering(String contractType, Long projectId, String subitemCode, String section, String reportingTime) {
        LaborCostVO vo = settlementBookStatementDetailMapper.getEngineering(contractType,projectId,subitemCode,section,reportingTime);
        return vo;
    }

    @Override
    public List<LaborCostVO> getSum(String contractType, Long projectId, String reportingTime) {
        List<LaborCostVO> vo = settlementBookStatementDetailMapper.getSum(contractType,projectId,reportingTime);
        return vo;
    }

    @Override
    public List<LaborCostVO> getStatementAll(String projectId, String contractType, String time) {
        List<LaborCostVO> statementAll = settlementBookStatementDetailMapper.getStatementAll(projectId, contractType, time);
        return statementAll;
    }
}
