package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementFinalizedEntity;
import com.ejianc.business.settlementmanage.service.ISettlementCountersignService;
import com.ejianc.business.settlementmanage.service.ISettlementFinalizedService;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.business.settlementmanage.vo.SettlementFinalizedVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Calendar;

@RestController
@RequestMapping("/api/settlementCountersign")
public class SettlementApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementCountersignService settlementCountersignService;

    @Autowired
    private ISettlementFinalizedService settlementFinalizedService;

    /**
         * 根据合同id查询 总包结算会审会签记录表
     * @Description querySettleById
     *  根据创建时间倒序,取最新生效的一条数据,成本管理使用
     */
    @RequestMapping(value = "/querySettleById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCountersignVO> querySettleById(Long contractId) {
        SettlementCountersignVO settlementCountersignVO = settlementCountersignService.querySettleById(contractId);
        return CommonResponse.success("查询详情数据成功！",settlementCountersignVO);
    }

    /**
     *查询已完成工程数额字段
     * @param contractId
     * @param reportTime
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/selectByContractIdTime", method = RequestMethod.GET)
    public CommonResponse<SettlementFinalizedVO> selectByContractIdTime(@RequestParam(value = "contractId") Long contractId, @RequestParam String reportTime){
        QueryWrapper<SettlementFinalizedEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", 1, 3);
        queryWrapper.eq("dr", 0);
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//        String month = sdf.format(reportTime);
        //当月
        String start = reportTime.substring(0, 7) + "-01";
        //当月最后一天
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(reportTime.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(reportTime.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf1.format(cal.getTime());
        queryWrapper.le("business_date", end);
        queryWrapper.ge("business_date", start);
        SettlementFinalizedEntity settlementFinalizedEntity = settlementFinalizedService.getOne(queryWrapper);
        SettlementFinalizedVO result = new SettlementFinalizedVO();
        if(settlementFinalizedEntity!=null){
            result = BeanMapper.map(settlementFinalizedEntity, SettlementFinalizedVO.class);
        }
        return CommonResponse.success("查询数据成功！",result);
    }
}
