package com.ejianc.business.settlementmanage.service;

import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.business.settlementmanage.vo.DesignSettlementDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.settlementmanage.bean.DesignSettlementEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 设计类结算单-主表
 * 
 * @author generator
 * 
 */
public interface IDesignSettlementService extends IBaseService<DesignSettlementEntity> {
    /**
     * 查询设计类最终结算清单本期合价
     * @param projectId
     * @return
     */
    BigDecimal queryDesignSettlement(Long projectId, String monthStr);

    /**
     * 计算本期的子表的金额字段数据
     * @param entity
     * @return
     */
    DesignSettlementEntity calculateDetailCurrentAmount(DesignSettlementEntity entity);

    /**
     * 根据接口返回的子表的数据 将list转换为map  key 为名称+除税单价+含税单价
     * @param contractId
     * @param date
     * @return
     */
    Map<String, DesignSettlementDetailVO> queryDesignDetailCumPastMap(Long contractId, String date);

    /**
     * @Description //TODO 更新单据数据的归集状态
     * @param projectId  项目id
     * @param state     状态
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);
}
