package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.MaterialPurchaseSettlementMapper;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseSettlementEntity;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseSettlementService;

import javax.annotation.Resource;
import java.util.List;

/**
 * 物资采购结算-主表
 * 
 * @author generator
 * 
 */
@Service("materialPurchaseSettlementService")
public class MaterialPurchaseSettlementServiceImpl extends BaseServiceImpl<MaterialPurchaseSettlementMapper, MaterialPurchaseSettlementEntity> implements IMaterialPurchaseSettlementService{
    @Resource
    private IMaterialPurchaseSettlementService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<MaterialPurchaseSettlementEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( date, '%Y-%m' )",monthStr);
        List<MaterialPurchaseSettlementEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (MaterialPurchaseSettlementEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<MaterialPurchaseSettlementEntity> query = new LambdaQueryWrapper<MaterialPurchaseSettlementEntity>()
                .eq(MaterialPurchaseSettlementEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(date, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(MaterialPurchaseSettlementEntity::getIsSettlement)
                        .or().eq(MaterialPurchaseSettlementEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("物资采购结算有往期未归集的数据");
        LambdaQueryWrapper<MaterialPurchaseSettlementEntity> query1 = new LambdaQueryWrapper<MaterialPurchaseSettlementEntity>()
                .eq(MaterialPurchaseSettlementEntity::getProjectId, projectId)
                .ne(MaterialPurchaseSettlementEntity::getBillState, 3)
                .ne(MaterialPurchaseSettlementEntity::getBillState, 1)
                .apply("DATE_FORMAT(date, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("物资采购结算有本期审批未通过的数据");
        return true;
    }
}
