/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSetDetailService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSettlementVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"turnoverLeaseSettlementExport"})
public class ExcelTurnoverLeaseSettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITurnoverLeaseSetDetailService turnoverLeaseSetDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @RequestMapping(value={"/downloadTurnoverLeaseSettlementDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadTurnoverLeaseSettlementDetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"TurnoverLeaseSetDetail-import.xlsx", (String)"\u5468\u8f6c\u79df\u8d41\u7ed3\u7b97\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportTurnoverLeaseSettlementDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTurnoverLeaseSettlementDetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<TurnoverLeaseSetDetailVO> successList = new ArrayList<TurnoverLeaseSetDetailVO>();
        ArrayList<TurnoverLeaseSetDetailVO> errorList = new ArrayList<TurnoverLeaseSetDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 1; i < result.size(); ++i) {
                String errorMessage;
                int num = 0;
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = new TurnoverLeaseSetDetailVO();
                List datas = (List)result.get(i);
                turnoverLeaseSetDetailVO.setId(IdWorker.getId());
                turnoverLeaseSetDetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? (String)datas.get(10) : null);
                try {
                    String errorMessage2;
                    Date data1 = DateUtils.Date((String)datas.get(1));
                    String str = ExcelTurnoverLeaseSettlementController.dateToStr(data1);
                    str = str.substring(0, 7);
                    if (map.get(str) != null && StringUtils.isNotEmpty((CharSequence)str) && str.equals(map.get(str))) {
                        errorMessage2 = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage2 == null) {
                            errorMessage2 = "";
                        }
                        errorMessage2 = errorMessage2 + "\u6708\u4efd\u91cd\u590d\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage2);
                        ++num;
                    } else if (!DateUtils.grepDate((String)datas.get(1))) {
                        errorMessage2 = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage2 == null) {
                            errorMessage2 = "";
                        }
                        errorMessage2 = errorMessage2 + "\u6708\u4efd\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage2);
                        ++num;
                    } else {
                        map.put(str, str);
                        turnoverLeaseSetDetailVO.setMonths(DateUtils.Date((String)datas.get(1)));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (datas.get(2) != null && !"".equals(datas.get(2))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(2)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u79df\u8d41\u5408\u4ef7(\u542b\u7a0e)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setIntaxLeasePrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? new BigDecimal((String)datas.get(2)) : null);
                    }
                }
                if (datas.get(3) != null && !"".equals(datas.get(3))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(3)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u79df\u8d41\u5408\u4ef7(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setExtaxLeasePrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                    }
                }
                if (datas.get(4) != null && !"".equals(datas.get(4))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(4)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u8d54\u507f\u91d1\u989d(\u542b\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setIntaxCompensationPayable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                    }
                }
                if (datas.get(5) != null && !"".equals(datas.get(5))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(5)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u8d54\u507f\u91d1\u989d(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setExtaxCompensationPayable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                    }
                }
                if (datas.get(6) != null && !"".equals(datas.get(6))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(6)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u4fee\u7406\u8d39\u7b49\u5176\u5b83\u8d39\u7528(\u542b\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setIntaxRepair(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(6)) : null);
                    }
                }
                if (datas.get(7) != null && !"".equals(datas.get(7))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(7)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u4fee\u7406\u8d39\u7b49\u5176\u5b83\u8d39\u7528(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setExtaxRepair(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(7)) : null);
                    }
                }
                if (datas.get(8) != null && !"".equals(datas.get(8))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(8)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u6708\u5ea6\u7ed3\u7b97\u8d39\u7528(\u542b\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setIntaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                    }
                }
                if (datas.get(9) != null && !"".equals(datas.get(9))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(9)))) {
                        errorMessage = turnoverLeaseSetDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u6708\u5ea6\u7ed3\u7b97\u8d39\u7528(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        turnoverLeaseSetDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        turnoverLeaseSetDetailVO.setExtaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                    }
                }
                if (datas.get(8) != null && !"".equals(datas.get(8))) {
                    turnoverLeaseSetDetailVO.setIntaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                } else if (num == 0) {
                    BigDecimal intaxMonthlySettlementAmount = null;
                    if (datas.get(2) != null && !"".equals(datas.get(2))) {
                        intaxMonthlySettlementAmount = new BigDecimal((String)datas.get(2));
                    }
                    if (datas.get(4) != null && !"".equals(datas.get(4))) {
                        intaxMonthlySettlementAmount = intaxMonthlySettlementAmount != null && num == 0 ? intaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(4))) : new BigDecimal((String)datas.get(4));
                    }
                    if (datas.get(6) != null && !"".equals(datas.get(6))) {
                        intaxMonthlySettlementAmount = intaxMonthlySettlementAmount != null && num == 0 ? intaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(6))) : new BigDecimal((String)datas.get(6));
                    }
                    if (intaxMonthlySettlementAmount != null && num == 0) {
                        turnoverLeaseSetDetailVO.setIntaxMonthlySettlementAmount(intaxMonthlySettlementAmount);
                    }
                }
                if (datas.get(9) != null && !"".equals(datas.get(9))) {
                    turnoverLeaseSetDetailVO.setExtaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                } else if (num == 0) {
                    BigDecimal extaxMonthlySettlementAmount = null;
                    if (datas.get(3) != null && !"".equals(datas.get(3))) {
                        extaxMonthlySettlementAmount = new BigDecimal((String)datas.get(3));
                    }
                    if (datas.get(5) != null && !"".equals(datas.get(5))) {
                        extaxMonthlySettlementAmount = extaxMonthlySettlementAmount != null && num == 0 ? extaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(5))) : new BigDecimal((String)datas.get(5));
                    }
                    if (datas.get(7) != null && !"".equals(datas.get(7))) {
                        extaxMonthlySettlementAmount = extaxMonthlySettlementAmount != null && num == 0 ? extaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(7))) : new BigDecimal((String)datas.get(7));
                    }
                    if (extaxMonthlySettlementAmount != null && num == 0) {
                        turnoverLeaseSetDetailVO.setExtaxMonthlySettlementAmount(extaxMonthlySettlementAmount);
                    }
                }
                if (num > 0) {
                    errorList.add(turnoverLeaseSetDetailVO);
                    continue;
                }
                successList.add(turnoverLeaseSetDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    @RequestMapping(value={"/excelExportTurnoverLeaseSettlementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTurnoverLeaseSettlementFromPage(@RequestBody List<TurnoverLeaseSetDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = list.get(i);
                turnoverLeaseSetDetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<TurnoverLeaseSetDetailVO>> beans = new HashMap<String, List<TurnoverLeaseSetDetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TurnoverLeaseSetDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportTurnoverLeaseSettlementDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTurnoverLeaseSettlementDatabase(@RequestBody TurnoverLeaseSettlementVO turnoverLeaseSettlementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)turnoverLeaseSettlementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.turnoverLeaseSetDetailService.list((Wrapper)queryWrapper);
        List tnrnoverLeaseSetDetailVOList = BeanMapper.mapList((Iterable)list, TurnoverLeaseSetDetailVO.class);
        if (tnrnoverLeaseSetDetailVOList != null && tnrnoverLeaseSetDetailVOList.size() > 0) {
            for (int i = 0; i < tnrnoverLeaseSetDetailVOList.size(); ++i) {
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = (TurnoverLeaseSetDetailVO)((Object)tnrnoverLeaseSetDetailVOList.get(i));
                turnoverLeaseSetDetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", tnrnoverLeaseSetDetailVOList);
        ExcelExport.getInstance().export("TurnoverLeaseSetDetail-export.xlsx", beans, response);
    }
}

