/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalodetailEntity;
import com.ejianc.business.settlementmanage.mapper.ConsultotherfinalMapper;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinaldetailService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalodetailService;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="consultotherfinalService")
public class ConsultotherfinalServiceImpl
extends BaseServiceImpl<ConsultotherfinalMapper, ConsultotherfinalEntity>
implements IConsultotherfinalService {
    @Autowired
    private IConsultotherfinalodetailService consultotherfinalodetailService;
    @Autowired
    private IConsultotherfinaldetailService consultotherfinaldetailService;
    @Autowired
    private IConsultotherfinalService service;
    @Autowired
    private ConsultotherfinalMapper mapper;
    @Autowired
    private DesignAndConsultApi designAndConsultApi;

    @Override
    public BigDecimal queryConsultotherfinal(Long projectId, String monthStr) {
        BigDecimal curExtaxPrice = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS = this.mapper.queryConsultotherfinal(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.add(totalPrice);
        }
        List<CostManageVO> costManageVOS1 = this.mapper.queryConsultotherfinaloDetail(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS1) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.subtract(totalPrice);
        }
        return curExtaxPrice;
    }

    @Override
    public ConsultotherfinalEntity calculateDetailCurrentAmount(ConsultotherfinalEntity entity) {
        List<ConsultotherfinalodetailEntity> consultotherfinalodetailEntities;
        List<ConsultotherfinaldetailEntity> consultotherfinaldetailEntities = entity.getConsultotherfinaldetailEntities();
        if (!consultotherfinaldetailEntities.isEmpty()) {
            for (ConsultotherfinaldetailEntity consultotherfinaldetailEntity : consultotherfinaldetailEntities) {
                if ("del".equals(consultotherfinaldetailEntity.getRowState())) continue;
                BigDecimal cumExtaxPrice = consultotherfinaldetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumExtaxPrice();
                BigDecimal cumIntaxPrice = consultotherfinaldetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumIntaxPrice();
                consultotherfinaldetailEntity.setCurExtaxPrice(consultotherfinaldetailEntity.getAmounts().subtract(cumExtaxPrice));
                consultotherfinaldetailEntity.setCurIntaxPrice(consultotherfinaldetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
            }
        }
        if (!(consultotherfinalodetailEntities = entity.getConsultotherfinalodetailEntities()).isEmpty()) {
            for (ConsultotherfinalodetailEntity consultotherfinalodetailEntity : consultotherfinalodetailEntities) {
                if ("del".equals(consultotherfinalodetailEntity.getRowState())) continue;
                BigDecimal cumExtaxPrice = consultotherfinalodetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumExtaxPrice();
                BigDecimal cumIntaxPrice = consultotherfinalodetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumIntaxPrice();
                consultotherfinalodetailEntity.setCurExtaxPrice(consultotherfinalodetailEntity.getAmounts().subtract(cumExtaxPrice));
                consultotherfinalodetailEntity.setCurIntaxPrice(consultotherfinalodetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
            }
        }
        return entity;
    }

    @Override
    public Map<String, ConsultotherfinaldetailVO> queryConsultDetailCumPastMap(Long contractId, String date) {
        HashMap<String, ConsultotherfinaldetailVO> map = new HashMap<String, ConsultotherfinaldetailVO>();
        CommonResponse listCommonResponse = this.designAndConsultApi.queryConsultDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()) {
            List consultotherfinaldetailVOS = BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), ConsultotherfinaldetailVO.class);
            for (ConsultotherfinaldetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getSubitemName() + consultotherfinaldetailVO.getUnitprice().setScale(2, 4) + consultotherfinaldetailVO.getTaxUnitprice().setScale(2, 4);
                map.put(key, consultotherfinaldetailVO);
            }
        } else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public Map<String, ConsultotherfinalodetailVO> queryConsultOtherDetailCumPastMap(Long contractId, String date) {
        HashMap<String, ConsultotherfinalodetailVO> map = new HashMap<String, ConsultotherfinalodetailVO>();
        CommonResponse listCommonResponse = this.designAndConsultApi.queryConsultOtherDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()) {
            List consultotherfinaldetailVOS = BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), ConsultotherfinalodetailVO.class);
            for (ConsultotherfinalodetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getExpenseName() + consultotherfinaldetailVO.getoUnitPrice().setScale(2, 4) + consultotherfinaldetailVO.getoTaxUnitPrice().setScale(2, 4);
                map.put(key, consultotherfinaldetailVO);
            }
        } else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public ConsultotherfinalEntity totalForm(ConsultotherfinalEntity entity) {
        Map<String, BigDecimal> map = this.consultotherfinaldetailService.totalForm(entity.getConsultotherfinaldetailEntities());
        Map<String, BigDecimal> map1 = this.consultotherfinalodetailService.totalForm(entity.getConsultotherfinalodetailEntities());
        BigDecimal currentTotal = map.get("currentTotal").subtract(map1.get("currentTotal"));
        BigDecimal currentTaxTotal = map.get("currentTaxTotal").subtract(map1.get("currentTaxTotal"));
        BigDecimal cumulativeAmounts = map.get("cumulativeAmounts").subtract(map1.get("cumulativeAmounts"));
        BigDecimal cumulativeTaxAmounts = map.get("cumulativeTaxAmounts").subtract(map1.get("cumulativeTaxAmounts"));
        entity.setCurrentTotal(currentTotal);
        entity.setTaxCurrentTotal(currentTaxTotal);
        entity.setCumulativeTotal(cumulativeAmounts);
        entity.setTaxCumulativeTotal(cumulativeTaxAmounts);
        entity.setTaxDeductionAmount(map1.get("currentTaxTotal"));
        entity.setDeductionAmount(map1.get("currentTotal"));
        entity.setTaxCurrentContract(map.get("currentTaxTotalContract"));
        entity.setCurrentContract(map.get("currentTotalContract"));
        entity.setTaxCumulativeContract(map.get("cumulativeTaxAmountsContract"));
        entity.setCumulativeContract(map.get("cumulativeAmountsContract"));
        entity.setCurrentContractout(map.get("currentTotalContractOut"));
        entity.setTaxCurrentContractout(map.get("currentTaxTotalContractOut"));
        entity.setCumulativeContractout(map.get("cumulativeAmountsContractOut"));
        entity.setTaxCumulativeContractout(map.get("cumulativeTaxAmountsContractOut"));
        return entity;
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( reporting_time, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (ConsultotherfinalEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConsultotherfinalEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(ConsultotherfinalEntity::getIsSettlement)).or()).eq(ConsultotherfinalEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u6700\u7ec8\u7ed3\u7b97\u5355\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConsultotherfinalEntity::getProjectId, (Object)projectId)).ne(ConsultotherfinalEntity::getBillState, (Object)3)).ne(ConsultotherfinalEntity::getBillState, (Object)1)).apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u6700\u7ec8\u7ed3\u7b97\u5355\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }
}

