/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.DesignSettlementDetailEntity;
import com.ejianc.business.settlementmanage.bean.DesignSettlementEntity;
import com.ejianc.business.settlementmanage.mapper.DesignSettlementMapper;
import com.ejianc.business.settlementmanage.service.IDesignSettlementService;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.business.settlementmanage.vo.DesignSettlementDetailVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="designSettlementService")
public class DesignSettlementServiceImpl
extends BaseServiceImpl<DesignSettlementMapper, DesignSettlementEntity>
implements IDesignSettlementService {
    @Autowired
    private DesignSettlementMapper mapper;
    @Autowired
    private IDesignSettlementService service;
    @Autowired
    private DesignAndConsultApi designAndConsultApi;

    @Override
    public BigDecimal queryDesignSettlement(Long projectId, String monthStr) {
        BigDecimal curExtaxPrice = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS = this.mapper.queryDesignSettlement(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.add(totalPrice);
        }
        return curExtaxPrice;
    }

    @Override
    public DesignSettlementEntity calculateDetailCurrentAmount(DesignSettlementEntity entity) {
        List<DesignSettlementDetailEntity> designSettlementDetailEntities = entity.getDesignSettlementDetailEntities();
        if (!designSettlementDetailEntities.isEmpty()) {
            for (DesignSettlementDetailEntity designSettlementDetailEntity : designSettlementDetailEntities) {
                if ("del".equals(designSettlementDetailEntity.getRowState())) continue;
                BigDecimal cumExtaxPrice = designSettlementDetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : designSettlementDetailEntity.getCumExtaxPrice();
                BigDecimal cumIntaxPrice = designSettlementDetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : designSettlementDetailEntity.getCumIntaxPrice();
                designSettlementDetailEntity.setCurExtaxPrice(designSettlementDetailEntity.getAuditExtaxAmount().subtract(cumExtaxPrice));
                designSettlementDetailEntity.setCurIntaxPrice(designSettlementDetailEntity.getAuditIntaxAmount().subtract(cumIntaxPrice));
            }
        }
        return entity;
    }

    @Override
    public Map<String, DesignSettlementDetailVO> queryDesignDetailCumPastMap(Long contractId, String date) {
        HashMap<String, DesignSettlementDetailVO> map = new HashMap<String, DesignSettlementDetailVO>();
        CommonResponse listCommonResponse = this.designAndConsultApi.queryDesignDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()) {
            if (!((List)listCommonResponse.getData()).isEmpty()) {
                List designSettlementDetailVOS = BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), DesignSettlementDetailVO.class);
                for (DesignSettlementDetailVO designSettlementDetailVO : designSettlementDetailVOS) {
                    String key = designSettlementDetailVO.getProjectName() + designSettlementDetailVO.getAuditExtaxAddition().setScale(2, 4) + designSettlementDetailVO.getAuditIntaxAddition().setScale(2, 4);
                    map.put(key, designSettlementDetailVO);
                }
            }
        } else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( sending_date, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (DesignSettlementEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesignSettlementEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(sending_date, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(DesignSettlementEntity::getIsSettlement)).or()).eq(DesignSettlementEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u8bbe\u8ba1\u7c7b\u7ed3\u7b97\u5355\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DesignSettlementEntity::getProjectId, (Object)projectId)).ne(DesignSettlementEntity::getBillState, (Object)3)).ne(DesignSettlementEntity::getBillState, (Object)1)).apply("DATE_FORMAT(sending_date, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u8bbe\u8ba1\u7c7b\u7ed3\u7b97\u5355\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }
}

