/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class IdCardUtils {
    public static final Pattern NUMBERS = Pattern.compile("\\d+");
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    static final Map<Integer, String> zoneNum = new HashMap<Integer, String>();
    static final int[] PARITYBIT;
    static final int[] POWER_LIST;

    public static Exception isValidatedAllIdcard(String idcard) throws Exception {
        boolean ret = IdCardUtils.isIdcard(idcard);
        if (!ret) {
            throw new Exception("\u8eab\u4efd\u8bc1\u683c\u5f0f\u6709\u8bef");
        }
        return null;
    }

    public static boolean isIdcard(String idCard) {
        if (idCard == null || idCard.length() != 15 && idCard.length() != 18) {
            return false;
        }
        if (!zoneNum.containsKey(Integer.valueOf(idCard.substring(0, 2)))) {
            return false;
        }
        String year = idCard.length() == 15 ? "19" + idCard.substring(6, 8) : idCard.substring(6, 10);
        int iyear = Integer.parseInt(year);
        if (iyear < 1900 || iyear > Calendar.getInstance().get(1)) {
            return false;
        }
        String month = idCard.length() == 15 ? idCard.substring(8, 10) : idCard.substring(10, 12);
        int imonth = Integer.parseInt(month);
        if (imonth < 1 || imonth > 12) {
            return false;
        }
        String day = idCard.length() == 15 ? idCard.substring(10, 12) : idCard.substring(12, 14);
        int iday = Integer.parseInt(day);
        if (iday < 1 || iday > 31) {
            return false;
        }
        if (!IdCardUtils.isValidDate(year + month + day)) {
            return false;
        }
        int power = 0;
        char[] cs = idCard.toUpperCase().toCharArray();
        for (int i = 0; i < cs.length && (i != cs.length - 1 || cs[i] != 'X'); ++i) {
            if (cs[i] < '0' || cs[i] > '9') {
                return false;
            }
            if (i >= cs.length - 1) continue;
            power += (cs[i] - 48) * POWER_LIST[i];
        }
        if (idCard.length() == 15) {
            return true;
        }
        return cs[cs.length - 1] == PARITYBIT[power % 11];
    }

    public static boolean isValidDate(String inDate) {
        if (inDate == null) {
            return false;
        }
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMdd");
        if (inDate.trim().length() != dataFormat.toPattern().length()) {
            return false;
        }
        dataFormat.setLenient(false);
        try {
            dataFormat.parse(inDate.trim());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private static Date toBirthDay(String birthday) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.parseInt(birthday.substring(0, 4)));
            calendar.set(2, Integer.parseInt(birthday.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(birthday.substring(6, 8)));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    private static Date strToDate(String str, String dateFormat) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        try {
            if (dateFormat == null || dateFormat.length() == 0) {
                dateFormat = "yyyy-MM-dd HH:mm:ss";
            }
            SimpleDateFormat fmt = new SimpleDateFormat(dateFormat);
            return fmt.parse(str.trim());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int year(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(1);
    }

    private static char getCheckCode18(int iSum) {
        switch (iSum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'x';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static char getCheckCode18(String code17) {
        int sum = IdCardUtils.getPowerSum(code17.toCharArray());
        return IdCardUtils.getCheckCode18(sum);
    }

    private static int getPowerSum(char[] iArr) {
        int iSum = 0;
        if (POWER_LIST.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                iSum += Integer.valueOf(String.valueOf(iArr[i])) * POWER_LIST[i];
            }
        }
        return iSum;
    }

    public static String convertIdCard(String idCard) {
        int sYear;
        if (idCard.length() != 15) {
            return null;
        }
        if (IdCardUtils.isMatch(NUMBERS, idCard)) {
            String birthday = idCard.substring(6, 12);
            Date birthDate = IdCardUtils.strToDate(birthday, "yyMMdd");
            sYear = IdCardUtils.year(birthDate);
            if (sYear > 2000) {
                sYear -= 100;
            }
        } else {
            return null;
        }
        StringBuilder idCard18 = new StringBuilder().append(idCard, 0, 6).append(sYear).append(idCard.substring(8));
        char sVal = IdCardUtils.getCheckCode18(idCard18.toString());
        idCard18.append(sVal);
        return idCard18.toString();
    }

    public static Date getBirthDay(String idno) {
        if (!IdCardUtils.isIdcard(idno)) {
            return null;
        }
        if (idno.length() == 15) {
            idno = IdCardUtils.convertIdCard(idno);
        }
        return IdCardUtils.toBirthDay(idno.substring(6, 14));
    }

    public static String getBirthDayStr(String idno) {
        if (!IdCardUtils.isIdcard(idno)) {
            return null;
        }
        if (idno.length() == 15) {
            idno = IdCardUtils.convertIdCard(idno);
        }
        Date birthday = IdCardUtils.toBirthDay(idno.substring(6, 14));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(birthday);
    }

    public static String getGender(String idno) {
        if (!IdCardUtils.isIdcard(idno)) {
            return "-1";
        }
        if (idno.length() == 15) {
            idno = IdCardUtils.convertIdCard(idno);
        }
        return Integer.parseInt(idno.substring(16, 17)) % 2 == 0 ? "1" : "0";
    }

    public static void main(String[] args) {
        String idc = "130503670401001";
        boolean idcard = IdCardUtils.isIdcard(idc);
        if (idcard) {
            System.out.println("\u8eab\u4efd\u8bc1\u53f7\u7801\u5408\u89c4");
            Date birthDay = IdCardUtils.getBirthDay(idc);
            System.out.println("\u5f53\u524d\u8eab\u4efd\u8bc1\u7684\u751f\u65e5\u4e3a\uff1a" + IdCardUtils.getBirthDayStr(idc));
            String gender = IdCardUtils.getGender(idc);
            if ("0".equals(gender)) {
                System.out.println("\u5f53\u524d\u8eab\u4efd\u8bc1\u7684\u6027\u522b\u4e3a\uff1a\u7537\u6027");
            } else if ("1".equals(gender)) {
                System.out.println("\u5f53\u524d\u8eab\u4efd\u8bc1\u7684\u6027\u522b\u4e3a\uff1a\u5973\u6027");
            } else {
                System.out.println("\u5f53\u524d\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        } else {
            System.out.println("\u8eab\u4efd\u8bc1\u683c\u5f0f\u6709\u8bef");
        }
    }

    static {
        zoneNum.put(11, "\u5317\u4eac");
        zoneNum.put(12, "\u5929\u6d25");
        zoneNum.put(13, "\u6cb3\u5317");
        zoneNum.put(14, "\u5c71\u897f");
        zoneNum.put(15, "\u5185\u8499\u53e4");
        zoneNum.put(21, "\u8fbd\u5b81");
        zoneNum.put(22, "\u5409\u6797");
        zoneNum.put(23, "\u9ed1\u9f99\u6c5f");
        zoneNum.put(31, "\u4e0a\u6d77");
        zoneNum.put(32, "\u6c5f\u82cf");
        zoneNum.put(33, "\u6d59\u6c5f");
        zoneNum.put(34, "\u5b89\u5fbd");
        zoneNum.put(35, "\u798f\u5efa");
        zoneNum.put(36, "\u6c5f\u897f");
        zoneNum.put(37, "\u5c71\u4e1c");
        zoneNum.put(41, "\u6cb3\u5357");
        zoneNum.put(42, "\u6e56\u5317");
        zoneNum.put(43, "\u6e56\u5357");
        zoneNum.put(44, "\u5e7f\u4e1c");
        zoneNum.put(45, "\u5e7f\u897f");
        zoneNum.put(46, "\u6d77\u5357");
        zoneNum.put(50, "\u91cd\u5e86");
        zoneNum.put(51, "\u56db\u5ddd");
        zoneNum.put(52, "\u8d35\u5dde");
        zoneNum.put(53, "\u4e91\u5357");
        zoneNum.put(54, "\u897f\u85cf");
        zoneNum.put(61, "\u9655\u897f");
        zoneNum.put(62, "\u7518\u8083");
        zoneNum.put(63, "\u9752\u6d77");
        zoneNum.put(64, "\u5b81\u590f");
        zoneNum.put(65, "\u65b0\u7586");
        zoneNum.put(71, "\u53f0\u6e7e");
        zoneNum.put(81, "\u9999\u6e2f");
        zoneNum.put(82, "\u6fb3\u95e8");
        zoneNum.put(91, "\u56fd\u5916");
        PARITYBIT = new int[]{49, 48, 88, 57, 56, 55, 54, 53, 52, 51, 50};
        POWER_LIST = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    }
}

