package com.ejianc.business.settlementmanage.controller.api;

import com.ejianc.business.settlementmanage.service.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author yupengjie
 * @createDate 2023/1/12
 * @description Api做为成本分析模块对涉及单据的数据归集状态操作 包括更新归集状态 以及查询是否归集
 */
@RestController
@RequestMapping("/api/settlementStateApi")
public class SettlementStateApiController {
    /**咨询及其他结算单*/
    @Resource
    private IConsultotherfinalService consultotherfinalService;
    /**设计结算单*/
    @Resource
    private IDesignSettlementService designSettlementService;
    /**机械租赁结算*/
    @Resource
    private IMachinerySettlementService machinerySettlementService;
    /**物资采购结算*/
    @Resource
    private IMaterialPurchaseSettlementService materialPurchaseSettlementService;
    /**工程分包结算*/
    @Resource
    private ISettlementBookService settlementBookService;
    /***
     * @Description //TODO 更新月度成本分析设计结算相关单据的归集状态
     *设计结算相关单据 ：咨询及其他结算单  设计结算单  机械租赁结算   物资采购结算  工程分包结算
     * @param projectId 项目id
     * @param state    归集状态
     * @param monthStr 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @Transactional(rollbackFor = Exception.class)
    @RequestMapping(value = "/updateSettlementState", method = RequestMethod.GET)
    public CommonResponse<String> updateMidSettlementState(Long projectId, Integer state, String monthStr){
        consultotherfinalService.updateSettlementState(projectId,state,monthStr);
        designSettlementService.updateSettlementState(projectId,state,monthStr);
        machinerySettlementService.updateSettlementState(projectId,state,monthStr);
        materialPurchaseSettlementService.updateSettlementState(projectId,state,monthStr);
        settlementBookService.updateSettlementState(projectId,state,monthStr);
        return CommonResponse.success("更新归集状态成功");
    }
    /***
     * @Description //TODO 查询校验是否存在往期单据中未归集的数据
     *设计结算相关单据 ：咨询及其他结算单  设计结算单  机械租赁结算   物资采购结算  工程分包结算
     * @param projectId  项目id
     * @param monthStr    要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/queryIsSettlement", method = RequestMethod.GET)
    public CommonResponse<String> queryIsSettlement(Long projectId, String monthStr){
        consultotherfinalService.queryIsSettlement(projectId,monthStr);
        designSettlementService.queryIsSettlement(projectId,monthStr);
        machinerySettlementService.queryIsSettlement(projectId,monthStr);
        materialPurchaseSettlementService.queryIsSettlement(projectId,monthStr);
        settlementBookService.queryIsSettlement(projectId,monthStr);
        return CommonResponse.success();
    }
}
