package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.bean.DesignSettlementDetailEntity;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.business.settlementmanage.vo.DesignSettlementDetailVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.DesignSettlementMapper;
import com.ejianc.business.settlementmanage.bean.DesignSettlementEntity;
import com.ejianc.business.settlementmanage.service.IDesignSettlementService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设计类结算单-主表
 * 
 * @author generator
 * 
 */
@Service("designSettlementService")
public class DesignSettlementServiceImpl extends BaseServiceImpl<DesignSettlementMapper, DesignSettlementEntity> implements IDesignSettlementService{
    @Autowired
    private DesignSettlementMapper mapper;
    @Autowired
    private IDesignSettlementService service;
    @Autowired
    private DesignAndConsultApi designAndConsultApi;
    @Override
    public BigDecimal queryDesignSettlement(Long projectId,String monthStr) {
        BigDecimal curExtaxPrice = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS = mapper.queryDesignSettlement(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.add(totalPrice);
        }
        return curExtaxPrice;
    }

    @Override
    public DesignSettlementEntity calculateDetailCurrentAmount(DesignSettlementEntity entity) {
        //咨询类结算单的子表
        List<DesignSettlementDetailEntity> designSettlementDetailEntities = entity.getDesignSettlementDetailEntities();
        if (!designSettlementDetailEntities.isEmpty()){
            for (DesignSettlementDetailEntity designSettlementDetailEntity : designSettlementDetailEntities) {
                if (!"del".equals(designSettlementDetailEntity.getRowState())){
                    //累计除税金额
                    BigDecimal cumExtaxPrice = designSettlementDetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : designSettlementDetailEntity.getCumExtaxPrice();
                    //累计含税金额
                    BigDecimal cumIntaxPrice = designSettlementDetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : designSettlementDetailEntity.getCumIntaxPrice();
                    designSettlementDetailEntity.setCurExtaxPrice(designSettlementDetailEntity.getAuditExtaxAmount().subtract(cumExtaxPrice));
                    designSettlementDetailEntity.setCurIntaxPrice(designSettlementDetailEntity.getAuditIntaxAmount().subtract(cumIntaxPrice));
                }
            }
        }
        return entity;
    }

    @Override
    public Map<String, DesignSettlementDetailVO> queryDesignDetailCumPastMap(Long contractId, String date) {
        Map<String, DesignSettlementDetailVO> map = new HashMap<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO>> listCommonResponse =
                designAndConsultApi.queryDesignDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()){
            if (!listCommonResponse.getData().isEmpty()){
                List<DesignSettlementDetailVO> designSettlementDetailVOS =
                        BeanMapper.mapList(listCommonResponse.getData(), DesignSettlementDetailVO.class);
                for (DesignSettlementDetailVO designSettlementDetailVO : designSettlementDetailVOS) {
                    String key = designSettlementDetailVO.getProjectName() +
                            designSettlementDetailVO.getAuditExtaxAddition().setScale(2,BigDecimal.ROUND_HALF_UP) +
                            designSettlementDetailVO.getAuditIntaxAddition().setScale(2,BigDecimal.ROUND_HALF_UP);
                    map.put(key,designSettlementDetailVO);
                }
            }
        }else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<DesignSettlementEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( sending_date, '%Y-%m' )",monthStr);
        List<DesignSettlementEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (DesignSettlementEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<DesignSettlementEntity> query = new LambdaQueryWrapper<DesignSettlementEntity>()
                .eq(DesignSettlementEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(sending_date, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(DesignSettlementEntity::getIsSettlement)
                        .or().eq(DesignSettlementEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("设计类结算单有往期未归集的数据");
        LambdaQueryWrapper<DesignSettlementEntity> query1 = new LambdaQueryWrapper<DesignSettlementEntity>()
                .eq(DesignSettlementEntity::getProjectId, projectId)
                .ne(DesignSettlementEntity::getBillState, 3)
                .ne(DesignSettlementEntity::getBillState, 1)
                .apply("DATE_FORMAT(sending_date, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("设计类结算单有本期审批未通过的数据");
        return true;
    }
}
