package com.ejianc.business.settlementmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settlementmanage.bean.*;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISubcontractCountersignedService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.*;
import com.ejianc.foundation.middlemeasurement.api.CostApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.middlemeasurement.vo.OverusedeductionRequestVO;
import com.ejianc.foundation.middlemeasurement.vo.SubVO;
import com.ejianc.foundation.middlemeasurement.vo.SubVOList;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工程分包结算书-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("settlementBook")
public class SettlementBookController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private SubcontractingApi subcontractingApi;
    @Qualifier("com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;
    @Qualifier("com.ejianc.foundation.middlemeasurement.api.CostApi")
    @Autowired
    private CostApi costApi;

    private static final String BILL_CODE = "settlementmanage-settlement-book";//此处需要根据实际修改

    @Autowired
    private ISettlementBookService service;

    @Autowired
    private ISubcontractCountersignedService subcontractCountersignedService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementBookVO> saveOrUpdate(@RequestBody SettlementBookVO saveorUpdateVO) {
        SettlementBookEntity entity = BeanMapper.map(saveorUpdateVO, SettlementBookEntity.class);
        BigDecimal bigDecimal = new BigDecimal(0.00);//超用扣款本期金额除税
        BigDecimal bigDecimal1 = new BigDecimal(0.00);//超用扣款本期金额含税
        BigDecimal bigDecimal2 = new BigDecimal(0.00);//其他及代扣款本期金额除税
        BigDecimal bigDecimal3 = new BigDecimal(0.00);//其他及代扣款本期金额含税
        //校验：没有创建分包结算条件会签单不能新增单据
        checkSubcontract(entity.getContractId());
        //校验单据是否存在往期自由态的单据
        checkFormUniqueByMonth(entity);
        //单据编码唯一性校验
        entity = checkBillCodeUniq(entity);
        List<SettlementBookStatementDetailEntity> settlementBookStatementDetailEntities = entity.getSettlementBookStatementDetailEntities();
        if (!settlementBookStatementDetailEntities.isEmpty() && settlementBookStatementDetailEntities.size() > 0) {
            List<SubVOList> subVOList = new ArrayList<>();
            for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                String listingCode = settlementBookStatementDetail.getListingCode();
                String section = settlementBookStatementDetail.getSection();
                Long contractId = entity.getContractId();
                SubVOList list = new SubVOList();
                list.setSubitemCode(listingCode);
                list.setSection(section);
                list.setContractId(contractId);
                subVOList.add(list);
            }
            CommonResponse<Map<String, SubVO>> amount = subcontractingApi.getAmount(subVOList);
            if (amount.getCode() == 0) {
                for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                    String section = settlementBookStatementDetail.getSection();
                    String listingCode = settlementBookStatementDetail.getListingCode();
                    SubVO subVO = amount.getData().get(listingCode + section);
                    if(subVO != null ){
                        //累计除税
                        BigDecimal examineCumulativeAmounts = subVO.getExamineCumulativeAmounts() == null ? new BigDecimal(0.00) : subVO.getExamineCumulativeAmounts();
                        //累计含税
                        BigDecimal examineCumulativeTaxAmounts = subVO.getExamineCumulativeTaxAmounts() == null ? new BigDecimal(0.00) : subVO.getExamineCumulativeTaxAmounts();
                        settlementBookStatementDetail.setAccruingAmountsNotax(examineCumulativeAmounts);
                        settlementBookStatementDetail.setAccruingAmountsTax(examineCumulativeTaxAmounts);
                        //除税合价
                        BigDecimal extaxAddition = settlementBookStatementDetail.getExtaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getExtaxAddition();
                        //含税合价
                        BigDecimal intaxAddition = settlementBookStatementDetail.getIntaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getIntaxAddition();
                        //本次报价（含税）
                        BigDecimal subtract = intaxAddition.subtract(examineCumulativeTaxAmounts);
                        //本次报价（除税）
                        BigDecimal subtract1 = extaxAddition.subtract(examineCumulativeAmounts);
                        //除税本次
                        settlementBookStatementDetail.setThisAmountsNotax(subtract1);
                        settlementBookStatementDetail.setThisAmountsTax(subtract);
                        //累计报量金额
                        BigDecimal examineCumulativeQuantity = subVO.getExamineCumulativeQuantity() == null ? new BigDecimal(0.00) : subVO.getExamineCumulativeQuantity();
                        settlementBookStatementDetail.setCumulativeEngineeringQuantity(examineCumulativeQuantity);
                        //工程量
                        BigDecimal quantities = settlementBookStatementDetail.getQuantities() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getQuantities();
                        if (examineCumulativeQuantity == null){
                            BigDecimal thisQuantity = quantities.subtract(new BigDecimal(0.00));
                            settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                        }else{
                            BigDecimal thisQuantity = quantities.subtract(examineCumulativeQuantity);
                            settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                        }
                    }else{
                        //本期报量工程量 thisEngineeringQuantity  = 工程量 quantities  - 累计报量工程量 cumulativeEngineeringQuantity
                        BigDecimal quantities = settlementBookStatementDetail.getQuantities() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getQuantities();
                        if (settlementBookStatementDetail.getCumulativeEngineeringQuantity() == null){
                            BigDecimal thisQuantity = quantities.subtract(new BigDecimal(0.00));
                            settlementBookStatementDetail.setCumulativeEngineeringQuantity(new BigDecimal(0.00));
                            settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                        }else{
                            BigDecimal thisQuantity = quantities.subtract(settlementBookStatementDetail.getCumulativeEngineeringQuantity());
                            settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                        }
                        //本次报量金额（除税）thisAmountsNotax = 合价（除税） extaxAddition  - 累积报量金额（除税） accruingAmountsNotax
                        BigDecimal extaxAddition = settlementBookStatementDetail.getExtaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getExtaxAddition();
                        if (settlementBookStatementDetail.getAccruingAmountsNotax() == null){
                            BigDecimal thisAmountsNotax = extaxAddition.subtract(new BigDecimal(0.00));
                            settlementBookStatementDetail.setAccruingAmountsNotax(new BigDecimal(0.00));
                            settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                        }else{
                            BigDecimal thisAmountsNotax = extaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsNotax());
                            settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                        }
                        //本期报量金额（含税） thisAmountsTax = 合价（含税） intaxAddition - 累积报量金额（含税） accruingAmountsTax
                        BigDecimal intaxAddition = settlementBookStatementDetail.getIntaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getIntaxAddition();
                        if (settlementBookStatementDetail.getAccruingAmountsTax() == null){
                            BigDecimal thisAmountsTax = intaxAddition.subtract(new BigDecimal(0.00));
                            settlementBookStatementDetail.setAccruingAmountsTax(new BigDecimal(0.00));
                            settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
                        }else {
                            BigDecimal thisAmountsTax = intaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsTax());
                            settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
                        }
                    }
                }
            }
            entity.setSettlementBookStatementDetailEntities(settlementBookStatementDetailEntities);
        }
        //查询分包报量超用扣款
        if(!entity.getSettlementBookMaterialDetailEntities().isEmpty() && entity.getSettlementBookMaterialDetailEntities().size() > 0){
            List<OverusedeductionVO> list = new ArrayList<>();
            for(SettlementBookMaterialDetailEntity entity1 : entity.getSettlementBookMaterialDetailEntities()){
                OverusedeductionVO overusedeductionVO = new OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(entity1.getBillCodeB());
                overusedeductionVO.setSection(entity1.getSectionB());
                overusedeductionVO.setUnitPrice(entity1.getExtaxPurchasingpriceB());
                overusedeductionVO.setTaxUnitPrice(entity1.getIntaxPurchasingprice());
                list.add(overusedeductionVO);
            }
            List<com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO> list1 = BeanMapper.mapList(list,com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO.class);
            CommonResponse<Map<String, OverusedeductionRequestVO>> mapCommonResponse = costApi.queryOveruse(list1);
            if(mapCommonResponse.isSuccess()){
                for(SettlementBookMaterialDetailEntity entity2 : entity.getSettlementBookMaterialDetailEntities()){
                    OverusedeductionRequestVO overusedeductionRequestVO = mapCommonResponse.getData().get(entity2.getBillCodeB() + entity2.getSectionB()+entity2.getExtaxPurchasingpriceB()+entity2.getIntaxPurchasingprice());
                    if(overusedeductionRequestVO != null){
                        entity2.setCumExtaxSectionprice(overusedeductionRequestVO.getAmounts());
                        entity2.setCumIntaxSectionprice(overusedeductionRequestVO.getTaxAmounts());
                        if(entity2.getExtaxSectionpriceB() == null){
                            entity2.setCurExtaxSectionprice(new BigDecimal(0.00));
                        }else{
                            entity2.setCurExtaxSectionprice(entity2.getExtaxSectionpriceB().subtract(entity2.getCumExtaxSectionprice()));
                        }

                        if(entity2.getIntaxSectionprice() == null){
                            entity2.setCurIntaxSectionprice(new BigDecimal(0.00));
                        }else{
                            entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                        }
                    }else{
                        entity2.setCumExtaxSectionprice(new BigDecimal(0.00));
                        entity2.setCumIntaxSectionprice(new BigDecimal(0.00));
                        entity2.setCurExtaxSectionprice(entity2.getExtaxSectionpriceB().subtract(entity2.getCumExtaxSectionprice()));
                        entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                    }
                    bigDecimal = bigDecimal.add(entity2.getCurExtaxSectionprice());
                    bigDecimal1 = bigDecimal1.add(entity2.getCurIntaxSectionprice());
                }
            }
        }
        //查询分包报量其他及代扣款
        if(!entity.getSettlementBookOtherDetailEntities().isEmpty() && entity.getSettlementBookOtherDetailEntities().size() > 0){
            List<OverusedeductionVO> list = new ArrayList<>();
            for(SettlementBookOtherDetailEntity entity3 : entity.getSettlementBookOtherDetailEntities()){
                OverusedeductionVO overusedeductionVO = new OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(entity3.getWithholdingOther());
                overusedeductionVO.setSection(entity3.getDeductionsName());
                overusedeductionVO.setUnitPrice(entity3.getExtaxUnitpriceC());
                overusedeductionVO.setTaxUnitPrice(entity3.getIntaxUnitpriceC());
                list.add(overusedeductionVO);
            }
            List<com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO> list1 = BeanMapper.mapList(list,com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO.class);
            CommonResponse<Map<String, OverusedeductionRequestVO>> mapCommonResponse = costApi.queryOther(list1);
            if(mapCommonResponse.isSuccess()){
                for(SettlementBookOtherDetailEntity entity4 : entity.getSettlementBookOtherDetailEntities()){
                    OverusedeductionRequestVO overusedeductionRequestVO = mapCommonResponse.getData().get(entity4.getWithholdingOther() + entity4.getDeductionsName()+entity4.getExtaxUnitpriceC()+entity4.getIntaxUnitpriceC());
                    if(overusedeductionRequestVO != null){
                        entity4.setCumExtaxPrice(overusedeductionRequestVO.getAmounts());
                        entity4.setCumIntaxPrice(overusedeductionRequestVO.getTaxAmounts());
                        if(entity4.getExtaxPriceC() == null){
                            entity4.setCurExtaxPrice(new BigDecimal(0.00));
                        }else{
                            entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        }

                        if(entity4.getIntaxPriceC() == null){
                            entity4.setCurIntaxPrice(new BigDecimal(0.00));
                        }else{
                            entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                        }
                    }else{
                        entity4.setCumExtaxPrice(new BigDecimal(0.00));
                        entity4.setCumIntaxPrice(new BigDecimal(0.00));
                        entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                    }
                    bigDecimal2 = bigDecimal2.add(entity4.getCurExtaxPrice());
                    bigDecimal3 = bigDecimal3.add(entity4.getCurIntaxPrice());
                }
            }
        }
        //汇总表同步数据
        if(!entity.getSettlementBookSummaryDetailEntities().isEmpty() && entity.getSettlementBookSummaryDetailEntities().size() > 0){
            for(SettlementBookSummaryDetailEntity entity5 : entity.getSettlementBookSummaryDetailEntities()){
                if(entity5.getProjectName().equals("材料节超")){
                    entity5.setExtaxPrice(bigDecimal);
                    entity5.setIntaxPrice(bigDecimal1);
                }
                if(entity5.getProjectName().equals("其他扣款")){
                    entity5.setExtaxPrice(bigDecimal2);
                    entity5.setIntaxPrice(bigDecimal3);
                }
            }
        }
        entity = service.totalForm(entity);
        service.saveOrUpdate(entity, false);
        SettlementBookVO vo = BeanMapper.map(entity, SettlementBookVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 新增工程分包结算书，没有创建分包结算条件会签单则不能新增
     *
     * @param
     * @param contractId
     */
    private void checkSubcontract(Long contractId) {
        QueryWrapper<SubcontractCountersignedEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
        List<SubcontractCountersignedEntity> pro = subcontractCountersignedService.list(queryWrapper);
        if (pro.isEmpty()) {
            throw new BusinessException("请先创建\"分包结算条件会签单\"!");
        }
    }

    /**
     * 校验结算书此合同小于等于年月是否存在自由态单据
     * @param entity
     */
    private void checkFormUniqueByMonth(SettlementBookEntity entity){
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        String date = sf.format(entity.getOrderMonth());
        QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", entity.getContractId());
        queryWrapper.le("DATE_FORMAT( order_month, '%Y-%m' )",date);
        queryWrapper.eq("bill_state", 0);//1直审 3审批通过
        if (entity.getId() != null)
            queryWrapper.ne("id",entity.getId());
        int count = service.count(queryWrapper);
        if (count > 0)
            throw new BusinessException("此合同存在往期已保存未提交结算单,请先提交往期未提交结算单");
        QueryWrapper<SettlementBookEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("contract_id", entity.getContractId());
        queryWrapper1.eq("DATE_FORMAT( order_month, '%Y-%m' )",date);
        if (entity.getId() != null)
            queryWrapper1.ne("id",entity.getId());
        int count1 = service.count(queryWrapper1);
        if (count1 > 0)
            throw new BusinessException("此合同当前月份已存在结算单，无法保存");


    }


    /**
     * 单据编码唯一性校验
     *
     * @param entity
     */
    private SettlementBookEntity checkBillCodeUniq(SettlementBookEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<SettlementBookEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            if (entity.getId() != null && entity.getId() != 0) {
                queryWrapperBillCode.ne("id", entity.getId());
            }
            List<SettlementBookEntity> proBillCode = service.list(queryWrapperBillCode);

            if (proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }
        return entity;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementBookVO> queryDetail(Long id) {
        SettlementBookEntity entity = service.selectById(id);
        SettlementBookVO vo = BeanMapper.map(entity, SettlementBookVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementBookVO> vos) {
        service.removeByIds(vos.stream().map(SettlementBookVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettlementBookEntity> page = service.queryPage(param, false);
        IPage<SettlementBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementBookVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<SettlementBookEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SettlementBookVO> settlementBookVOList = BeanMapper.mapList(list, SettlementBookVO.class);
        for (int i = 0; i < settlementBookVOList.size(); i++) {
            SettlementBookVO settlementBookVO = settlementBookVOList.get(i);
            if (settlementBookVO.getCreateTime() != null) {
                settlementBookVO.setCreateTimeShow(DateUtils.dateSimple2(settlementBookVO.getCreateTime()));
            }

            String billStateStr = settlementBookVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "审批驳回";
                }
                settlementBookVO.setBillStateStr(billStateStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settlementBookVOList);
        ExcelExport.getInstance().export("SettlementBook-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettlementBookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> refSettlementBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementBookEntity> page = service.queryPage(param, false);
        IPage<SettlementBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementBookVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 根据合同id查询分包月度报量子表和物资节超数据
     * @param contractId 合同id
     * @return
     */
    @RequestMapping(value = "/querySubcontractingvolumeByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,List>> querySubcontractingvolumeMaterialByContractId(@RequestParam(value = "contractId") Long contractId){
        Map<String,List> map = new HashMap<>();
        //请求分包月度报量及申请报告子表数据服务
        List<SettlementBookStatementDetailVO> statementDetailVOList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO>> statementResponse =
                subcontractingvolumeApi.querySubcontractingvolumeDetailByContractId(contractId);
        if (statementResponse.isSuccess()){
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO> data = statementResponse.getData();
            statementDetailVOList = BeanMapper.mapList(data, SettlementBookStatementDetailVO.class);
            for (SettlementBookStatementDetailVO VO : statementDetailVOList) {
                VO.setId(IdWorker.getId());
                VO.setIsDeleted("否");
            }
            map.put("statementDetailVOList",statementDetailVOList);
        }else {
            throw new BusinessException(statementResponse.getMsg());
        }
        //请求查询物资节超服务
        List<SettlementBookMaterialDetailVO> materialDetailVOList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO>> materialResponse =
                subcontractingvolumeApi.querySubcontractingvolumeMaterialByContractId(contractId);
        if (materialResponse.isSuccess()){
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO> data =
                    materialResponse.getData();
            materialDetailVOList = BeanMapper.mapList(data,SettlementBookMaterialDetailVO.class);
            for (SettlementBookMaterialDetailVO settlementBookMaterialDetailVO : materialDetailVOList) {
//                settlementBookMaterialDetailVO.setIsEditState("否");
                settlementBookMaterialDetailVO.setIsDeleted("否");
            }
            map.put("materialDetailVOList",materialDetailVOList);
        }else {
            throw new BusinessException(materialResponse.getMsg());
        }
        //其他扣款查询服务
        List<SettlementBookOtherDetailVO> otherDetailVOArrayList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO>> otherResponse =
                subcontractingvolumeApi.querySubcontractingvolumeOtherByContractId(contractId);
        if (otherResponse.isSuccess()){
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO> data =
                    otherResponse.getData();
            otherDetailVOArrayList = BeanMapper.mapList(data,SettlementBookOtherDetailVO.class);
            for (SettlementBookOtherDetailVO settlementBookOtherDetailVO : otherDetailVOArrayList) {
                settlementBookOtherDetailVO.setId(IdWorker.getId());
//                settlementBookOtherDetailVO.setIsEditState("否");
                settlementBookOtherDetailVO.setIsDeleted("否");
            }
            map.put("otherDetailVOArrayList",otherDetailVOArrayList);
        }else {
            throw new BusinessException(otherResponse.getMsg());
        }
        return CommonResponse.success("查询分包月度报量相关数据成功",map);
    }
}
