package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalodetailEntity;
import com.ejianc.business.settlementmanage.mapper.ConsultotherfinalMapper;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinaldetailService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalodetailService;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinalOtherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinaldetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 咨询及其他类合同最终结算单
 *
 * @author generator
 *
 */
@Service("consultotherfinalService")
public class ConsultotherfinalServiceImpl extends BaseServiceImpl<ConsultotherfinalMapper, ConsultotherfinalEntity> implements IConsultotherfinalService {

    @Autowired
    private IConsultotherfinalodetailService consultotherfinalodetailService;
    @Autowired
    private IConsultotherfinaldetailService consultotherfinaldetailService;
    @Autowired
    private IConsultotherfinalService service;
    @Autowired
    private ConsultotherfinalMapper mapper;
    @Autowired
    private DesignAndConsultApi designAndConsultApi;

    @Override
    public BigDecimal queryConsultotherfinal(Long projectId,String monthStr) {
        BigDecimal curExtaxPrice = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS = mapper.queryConsultotherfinal(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.add(totalPrice);
        }
        List<CostManageVO> costManageVOS1 = mapper.queryConsultotherfinaloDetail(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS1) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.subtract(totalPrice);
        }
        return curExtaxPrice;
    }

    @Override
    public ConsultotherfinalEntity calculateDetailCurrentAmount(ConsultotherfinalEntity entity) {
        //咨询类结算单的子表
        List<ConsultotherfinaldetailEntity> consultotherfinaldetailEntities = entity.getConsultotherfinaldetailEntities();
        if (!consultotherfinaldetailEntities.isEmpty()){
            for (ConsultotherfinaldetailEntity consultotherfinaldetailEntity : consultotherfinaldetailEntities) {
                if (!"del".equals(consultotherfinaldetailEntity.getRowState())){
                    //累计除税金额
                    BigDecimal cumExtaxPrice = consultotherfinaldetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumExtaxPrice();
                    //累计含税金额
                    BigDecimal cumIntaxPrice = consultotherfinaldetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumIntaxPrice();
                    consultotherfinaldetailEntity.setCurExtaxPrice(consultotherfinaldetailEntity.getAmounts().subtract(cumExtaxPrice));
                    consultotherfinaldetailEntity.setCurIntaxPrice(consultotherfinaldetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
                }
            }
        }
        //咨询类结算单的其他扣款子表
        List<ConsultotherfinalodetailEntity> consultotherfinalodetailEntities = entity.getConsultotherfinalodetailEntities();
        if (!consultotherfinalodetailEntities.isEmpty()){
            for (ConsultotherfinalodetailEntity consultotherfinalodetailEntity : consultotherfinalodetailEntities) {
                if (!"del".equals(consultotherfinalodetailEntity.getRowState())){
                    //累计除税金额
                    BigDecimal cumExtaxPrice = consultotherfinalodetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumExtaxPrice();
                    //累计含税金额
                    BigDecimal cumIntaxPrice = consultotherfinalodetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumIntaxPrice();
                    consultotherfinalodetailEntity.setCurExtaxPrice(consultotherfinalodetailEntity.getAmounts().subtract(cumExtaxPrice));
                    consultotherfinalodetailEntity.setCurIntaxPrice(consultotherfinalodetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
                }
            }
        }
        return entity;
    }

    @Override
    public Map<String, ConsultotherfinaldetailVO> queryConsultDetailCumPastMap(Long contractId, String date) {
        Map<String, ConsultotherfinaldetailVO> map = new HashMap<>();
        CommonResponse<List<ConsultfinaldetailVO>> listCommonResponse =
                designAndConsultApi.queryConsultDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()){
            List<ConsultotherfinaldetailVO> consultotherfinaldetailVOS =
                    BeanMapper.mapList(listCommonResponse.getData(), ConsultotherfinaldetailVO.class);
            for (ConsultotherfinaldetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getSubitemName() +
                        consultotherfinaldetailVO.getUnitprice().setScale(2,BigDecimal.ROUND_HALF_UP) +
                        consultotherfinaldetailVO.getTaxUnitprice().setScale(2,BigDecimal.ROUND_HALF_UP);
                map.put(key,consultotherfinaldetailVO);
            }
        }else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public Map<String, ConsultotherfinalodetailVO> queryConsultOtherDetailCumPastMap(Long contractId, String date) {
        Map<String, ConsultotherfinalodetailVO> map = new HashMap<>();
        CommonResponse<List<ConsultfinalOtherdetailVO>> listCommonResponse =
                designAndConsultApi.queryConsultOtherDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()){
            List<ConsultotherfinalodetailVO> consultotherfinaldetailVOS =
                    BeanMapper.mapList(listCommonResponse.getData(), ConsultotherfinalodetailVO.class);
            for (ConsultotherfinalodetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getExpenseName() +
                        consultotherfinaldetailVO.getoUnitPrice().setScale(2,BigDecimal.ROUND_HALF_UP) +
                        consultotherfinaldetailVO.getoTaxUnitPrice().setScale(2,BigDecimal.ROUND_HALF_UP);
                map.put(key,consultotherfinaldetailVO);
            }
        }else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public ConsultotherfinalEntity totalForm(ConsultotherfinalEntity entity) {
        //汇总子表的数据
        Map<String, BigDecimal> map = consultotherfinaldetailService.totalForm(entity.getConsultotherfinaldetailEntities());
        //汇总扣款的数据
        Map<String, BigDecimal> map1 = consultotherfinalodetailService.totalForm(entity.getConsultotherfinalodetailEntities());
        BigDecimal currentTotal = map.get("currentTotal").subtract(map1.get("currentTotal"));
        BigDecimal currentTaxTotal = map.get("currentTaxTotal").subtract(map1.get("currentTaxTotal"));
        BigDecimal cumulativeAmounts = map.get("cumulativeAmounts").subtract(map1.get("cumulativeAmounts"));
        BigDecimal cumulativeTaxAmounts = map.get("cumulativeTaxAmounts").subtract(map1.get("cumulativeTaxAmounts"));
        entity.setCurrentTotal(currentTotal);
        entity.setTaxCurrentTotal(currentTaxTotal);
        entity.setCumulativeTotal(cumulativeAmounts);
        entity.setTaxCumulativeTotal(cumulativeTaxAmounts);
        entity.setTaxDeductionAmount(map1.get("currentTaxTotal"));
        entity.setDeductionAmount(map1.get("currentTotal"));
        entity.setTaxCurrentContract(map.get("currentTaxTotalContract"));
        entity.setCurrentContract(map.get("currentTotalContract"));
        entity.setTaxCumulativeContract(map.get("cumulativeTaxAmountsContract"));
        entity.setCumulativeContract(map.get("cumulativeAmountsContract"));
        entity.setCurrentContractout(map.get("currentTotalContractOut"));
        entity.setTaxCurrentContractout(map.get("currentTaxTotalContractOut"));
        entity.setCumulativeContractout(map.get("cumulativeAmountsContractOut"));
        entity.setTaxCumulativeContractout(map.get("cumulativeTaxAmountsContractOut"));
        return entity;
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<ConsultotherfinalEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( reporting_time, '%Y-%m' )",monthStr);
        List<ConsultotherfinalEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (ConsultotherfinalEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<ConsultotherfinalEntity> query = new LambdaQueryWrapper<ConsultotherfinalEntity>()
                .eq(ConsultotherfinalEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(ConsultotherfinalEntity::getIsSettlement)
                        .or().eq(ConsultotherfinalEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("咨询及其他类合同最终结算单有往期未归集的数据");
        LambdaQueryWrapper<ConsultotherfinalEntity> query1 = new LambdaQueryWrapper<ConsultotherfinalEntity>()
                .eq(ConsultotherfinalEntity::getProjectId, projectId)
                .ne(ConsultotherfinalEntity::getBillState, 3)
                .ne(ConsultotherfinalEntity::getBillState, 1)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("咨询及其他类合同最终结算单有本期审批未通过的数据");
        return true;
    }
}
