package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.DesignSettlementEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.MachinerySettlementMapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementService;

import javax.annotation.Resource;
import java.util.List;

/**
 * 机械设备结算-主表
 * 
 * @author generator
 * 
 */
@Service("machinerySettlementService")
public class MachinerySettlementServiceImpl extends BaseServiceImpl<MachinerySettlementMapper, MachinerySettlementEntity> implements IMachinerySettlementService{
    @Resource
    private IMachinerySettlementService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<MachinerySettlementEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settlement_date, '%Y-%m' )",monthStr);
        List<MachinerySettlementEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (MachinerySettlementEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<MachinerySettlementEntity> query = new LambdaQueryWrapper<MachinerySettlementEntity>()
                .eq(MachinerySettlementEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settlement_date, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(MachinerySettlementEntity::getIsSettlement)
                        .or().eq(MachinerySettlementEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("机械设备结算有往期未归集的数据");
        LambdaQueryWrapper<MachinerySettlementEntity> query1 = new LambdaQueryWrapper<MachinerySettlementEntity>()
                .eq(MachinerySettlementEntity::getProjectId, projectId)
                .ne(MachinerySettlementEntity::getBillState, 3)
                .ne(MachinerySettlementEntity::getBillState, 1)
                .apply("DATE_FORMAT(settlement_date, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("机械设备结算有本期审批未通过的数据");
        return true;
    }
}
