package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.TurnoverLeaseSettlementMapper;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSettlementEntity;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSettlementService;

import java.util.Date;
import java.util.List;

/**
 * 周转租赁结算-主表
 * 
 * @author generator
 * 
 */
@Service("turnoverLeaseSettlementService")
public class TurnoverLeaseSettlementServiceImpl extends BaseServiceImpl<TurnoverLeaseSettlementMapper, TurnoverLeaseSettlementEntity> implements ITurnoverLeaseSettlementService{

    @Autowired
    private TurnoverLeaseSettlementMapper turnoverLeaseSettlementMapper;


    @Override
    public List<TurnoverLeaseSetDetailVO> queryDetailList(String settlementDate, Long projectId, Long contractId) {
        List<TurnoverLeaseSetDetailVO> turnoverLeaseSetDetailVOS = turnoverLeaseSettlementMapper.queryDetailList(settlementDate,projectId,contractId);
        if(CollectionUtils.isNotEmpty(turnoverLeaseSetDetailVOS)){
            for(TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO :turnoverLeaseSetDetailVOS ){
                turnoverLeaseSetDetailVO.setId(IdWorker.getId());
            }
        }
        return  turnoverLeaseSetDetailVOS;
    }
}
