/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookSummaryDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookSummaryDetailService;
import com.ejianc.business.settlementmanage.utils.MonthUtil;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookSumVo;
import com.ejianc.business.settlementmanage.vo.SubDetailVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/settlementBookStatementDetail"})
public class SettlementBookApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookService settlementBookService;
    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;
    @Autowired
    private ISettlementBookSummaryDetailService iSettlementBookSummaryDetailService;

    @RequestMapping(value={"/queryActualCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SettlementBookStatementDetailVO>> queryActualCost(Long projectId, String subitemCode, String section, String reportingMonth) {
        ArrayList<SettlementBookStatementDetailVO> resList = new ArrayList<SettlementBookStatementDetailVO>();
        if (StringUtils.isBlank((CharSequence)reportingMonth)) {
            return CommonResponse.error((String)"\u62a5\u544a\u6708\u4efd\u4e3a\u7a7a\uff01");
        }
        String[] strArr = reportingMonth.split("-");
        if (strArr.length > 1) {
            String year = strArr[0];
            String month = strArr[1];
            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
            String lastDay = MonthUtil.getLastDayOfMonth(year, month);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)projectId);
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.in((Object)"bill_state", new Object[]{"1", "3"});
            queryWrapper.ge((Object)"create_time", (Object)firstDay);
            queryWrapper.le((Object)"create_time", (Object)lastDay);
            List mList = this.settlementBookService.list((Wrapper)queryWrapper);
            if (mList != null && mList.size() > 0) {
                HashMap<String, SettlementBookStatementDetailVO> detailMap = new HashMap<String, SettlementBookStatementDetailVO>();
                for (SettlementBookEntity item : mList) {
                    int i;
                    List detailList;
                    QueryWrapper statementDetailQueryWrapper;
                    String contractType = item.getContractType();
                    if ("\u52b3\u52a1\u5206\u5305".equals(contractType)) {
                        statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq((Object)"mid", (Object)item.getId());
                        statementDetailQueryWrapper.eq((Object)"listing_code", (Object)subitemCode);
                        statementDetailQueryWrapper.eq((Object)"section", (Object)section);
                        statementDetailQueryWrapper.eq((Object)"dr", (Object)0);
                        detailList = this.settlementBookStatementDetailService.list((Wrapper)statementDetailQueryWrapper);
                        if (detailList == null || detailList.size() <= 0) continue;
                        for (i = 0; i < detailList.size(); ++i) {
                            SettlementBookStatementDetailVO mapDetailVo = (SettlementBookStatementDetailVO)((Object)detailMap.get(subitemCode + section));
                            SettlementBookStatementDetailVO settlementBookStatementDetailVO = new SettlementBookStatementDetailVO();
                            SettlementBookStatementDetailEntity detailEntity = (SettlementBookStatementDetailEntity)((Object)detailList.get(i));
                            SettlementBookStatementDetailVO detailVO = (SettlementBookStatementDetailVO)((Object)BeanMapper.map((Object)((Object)detailEntity), SettlementBookStatementDetailVO.class));
                            if (mapDetailVo == null) {
                                detailMap.put(subitemCode + section, detailVO);
                                continue;
                            }
                            BigDecimal mapExamineQuantity = mapDetailVo.getThisEngineeringQuantity() == null ? new BigDecimal(0) : mapDetailVo.getThisEngineeringQuantity();
                            BigDecimal mapExamineAmounts = mapDetailVo.getThisAmountsNotax() == null ? new BigDecimal(0) : mapDetailVo.getThisAmountsNotax();
                            BigDecimal mapExamineTaxAmounts = mapDetailVo.getThisAmountsTax() == null ? new BigDecimal(0) : mapDetailVo.getThisAmountsTax();
                            BigDecimal thisEngineeringQuantity = detailEntity.getThisEngineeringQuantity();
                            BigDecimal thisAmountsNotax = detailEntity.getThisAmountsNotax();
                            BigDecimal thisAmountsTax = detailEntity.getThisAmountsTax();
                            BigDecimal examineQuantityTotal = thisEngineeringQuantity.add(mapExamineQuantity);
                            BigDecimal examineAmountsTotal = thisAmountsNotax.add(mapExamineAmounts);
                            BigDecimal examineTaxAmountsTotal = thisAmountsTax.add(mapExamineTaxAmounts);
                            settlementBookStatementDetailVO.setThisEngineeringQuantity(examineQuantityTotal);
                            settlementBookStatementDetailVO.setThisAmountsNotax(examineAmountsTotal);
                            settlementBookStatementDetailVO.setThisAmountsTax(examineTaxAmountsTotal);
                            if (examineQuantityTotal.intValue() != 0) {
                                BigDecimal examineUnitprice = examineAmountsTotal.divide(examineQuantityTotal, 8, 4);
                                BigDecimal examineTaxUnitprice = examineTaxAmountsTotal.divide(examineQuantityTotal, 8, 4);
                                settlementBookStatementDetailVO.setExtaxUnitprice(examineUnitprice);
                                settlementBookStatementDetailVO.setIntaxUnitprice(examineTaxUnitprice);
                            }
                            detailMap.put(subitemCode + section, settlementBookStatementDetailVO);
                        }
                        continue;
                    }
                    if (!"\u4e13\u4e1a\u5206\u5305".equals(contractType)) continue;
                    statementDetailQueryWrapper = new QueryWrapper();
                    statementDetailQueryWrapper.eq((Object)"mid", (Object)item.getId());
                    statementDetailQueryWrapper.eq((Object)"listing_code", (Object)subitemCode);
                    statementDetailQueryWrapper.eq((Object)"section", (Object)section);
                    statementDetailQueryWrapper.eq((Object)"dr", (Object)0);
                    detailList = this.settlementBookStatementDetailService.list((Wrapper)statementDetailQueryWrapper);
                    if (detailList == null || detailList.size() <= 0) continue;
                    for (i = 0; i < detailList.size(); ++i) {
                        SettlementBookStatementDetailEntity detailEntity = (SettlementBookStatementDetailEntity)((Object)detailList.get(i));
                        SettlementBookStatementDetailVO detailVO = (SettlementBookStatementDetailVO)((Object)BeanMapper.map((Object)((Object)detailEntity), SettlementBookStatementDetailVO.class));
                        resList.add(detailVO);
                    }
                }
                for (Map.Entry next : detailMap.entrySet()) {
                    SettlementBookStatementDetailVO valueVo = (SettlementBookStatementDetailVO)((Object)next.getValue());
                    resList.add(valueVo);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @RequestMapping(value={"/queryActualSumCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementBookSumVo> queryActualSumCost(Long projectId, String reportingMonth) {
        BigDecimal total = new BigDecimal("0.00");
        SettlementBookSumVo settlementBookSumVo = new SettlementBookSumVo();
        if (StringUtils.isBlank((CharSequence)reportingMonth)) {
            return CommonResponse.error((String)"\u62a5\u544a\u6708\u4efd\u4e3a\u7a7a\uff01");
        }
        String[] strArr = reportingMonth.split("-");
        if (strArr.length > 1) {
            String year = strArr[0];
            String month = strArr[1];
            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
            String lastDay = MonthUtil.getLastDayOfMonth(year, month);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)projectId);
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.in((Object)"bill_state", new Object[]{"1", "3"});
            queryWrapper.ge((Object)"create_time", (Object)firstDay);
            queryWrapper.le((Object)"create_time", (Object)lastDay);
            List mList = this.settlementBookService.list((Wrapper)queryWrapper);
            if (mList != null && mList.size() > 0) {
                for (SettlementBookEntity item : mList) {
                    String contractType = item.getContractType();
                    QueryWrapper statementDetailQueryWrappers = new QueryWrapper();
                    statementDetailQueryWrappers.eq((Object)"mid", (Object)item.getId());
                    statementDetailQueryWrappers.eq((Object)"dr", (Object)0);
                    List detailList2 = this.iSettlementBookSummaryDetailService.list((Wrapper)statementDetailQueryWrappers);
                    if (detailList2.size() <= 0 || detailList2 == null) continue;
                    BigDecimal intaxPrice = ((SettlementBookSummaryDetailEntity)((Object)detailList2.get(4))).getIntaxPrice();
                    BigDecimal intaxPrice1 = ((SettlementBookSummaryDetailEntity)((Object)detailList2.get(6))).getIntaxPrice();
                    BigDecimal intaxPrice2 = ((SettlementBookSummaryDetailEntity)((Object)detailList2.get(7))).getIntaxPrice();
                    BigDecimal intaxPrice3 = ((SettlementBookSummaryDetailEntity)((Object)detailList2.get(8))).getIntaxPrice();
                    BigDecimal intaxPrice4 = intaxPrice.add(intaxPrice1);
                    BigDecimal intaxPrice5 = intaxPrice4.add(intaxPrice2);
                    BigDecimal intaxPrice6 = intaxPrice5.add(intaxPrice3);
                    total = total.add(intaxPrice6);
                    settlementBookSumVo.setId(item.getId());
                    settlementBookSumVo.setTotal(total);
                    settlementBookSumVo.setContractType(contractType);
                    SettlementBookSumVo settlementBookSumVo2 = (SettlementBookSumVo)BeanMapper.map((Object)settlementBookSumVo, SettlementBookSumVo.class);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)settlementBookSumVo);
    }

    @RequestMapping(value={"/getAccruingAmountsTax"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDetailVo> getAccruingAmountsTax(@RequestParam(value="projectId") Long projectId, @RequestParam Date reportingMonth) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String month = sdf.format(reportingMonth);
        String start = month.substring(0, 7) + "-01";
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(month.substring(0, 4)));
        cal.set(2, Integer.parseInt(month.substring(5, 7)) - 1);
        cal.set(5, cal.getActualMaximum(5));
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf1.format(cal.getTime());
        queryWrapper.le((Object)"create_time", (Object)end);
        queryWrapper.ge((Object)"create_time", (Object)start);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List list = this.settlementBookService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal(0.0);
        BigDecimal noTaxTotal = new BigDecimal(0.0);
        SubDetailVo subDetailVo = new SubDetailVo();
        if (!list.isEmpty() && list.size() > 0) {
            for (SettlementBookEntity settlementBookEntity : list) {
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"mid", (Object)settlementBookEntity.getId());
                queryWrapper1.in((Object)"bill_state", new Object[]{1, 3});
                List list1 = this.settlementBookStatementDetailService.list((Wrapper)queryWrapper1);
                if (list1.isEmpty() || list1.size() <= 0) continue;
                for (SettlementBookStatementDetailEntity settlementBookStatementDetailEntity : list1) {
                    BigDecimal thisAmountsTax = settlementBookStatementDetailEntity.getThisAmountsTax();
                    BigDecimal thisAmountsNotax = settlementBookStatementDetailEntity.getThisAmountsNotax();
                    if (thisAmountsTax != null) {
                        total = total.add(thisAmountsTax);
                    }
                    if (thisAmountsNotax == null) continue;
                    noTaxTotal = noTaxTotal.add(thisAmountsNotax);
                }
            }
        }
        subDetailVo.setThisAmountsTax(total);
        subDetailVo.setThisAmountsNotax(noTaxTotal);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)subDetailVo);
    }

    @RequestMapping(value={"queryContractIds"}, method={RequestMethod.GET})
    @ResponseBody
    private CommonResponse<Integer> queryContractIds(@RequestParam(value="contractId") Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List settlementBookEntityList = this.settlementBookService.list((Wrapper)queryWrapper);
        Integer total = 0;
        total = settlementBookEntityList.size() > 0 ? Integer.valueOf(1) : Integer.valueOf(0);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)total);
    }
}

