/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.mapper.SettlementBookMapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookMaterialDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementBookService")
public class SettlementBookServiceImpl
extends BaseServiceImpl<SettlementBookMapper, SettlementBookEntity>
implements ISettlementBookService {
    @Resource
    private ISettlementBookService service;
    @Autowired
    private ISettlementBookMaterialDetailService materialDetailService;
    @Autowired
    private ISettlementBookOtherDetailService otherDetailService;
    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;

    @Override
    public SettlementBookEntity checkMaterialAndOtherFromSubcontractingvolume(SettlementBookEntity entity) {
        Map<String, SettlementBookMaterialDetailVO> materialMap = this.materialDetailService.querySubcontractingvolumeMaterialByContractId(entity.getContractId());
        for (SettlementBookMaterialDetailEntity settlementBookMaterialDetailEntity : entity.getSettlementBookMaterialDetailEntities()) {
            BigDecimal sectionNumBOriginal;
            String key = settlementBookMaterialDetailEntity.getBillCode() + settlementBookMaterialDetailEntity.getSectionB() + settlementBookMaterialDetailEntity.getExtaxPurchasingprice().setScale(2, RoundingMode.HALF_UP) + settlementBookMaterialDetailEntity.getIntaxPurchasingprice().setScale(2, RoundingMode.HALF_UP);
            SettlementBookMaterialDetailVO settlementBookMaterialDetailVO = materialMap.get(key);
            if (settlementBookMaterialDetailVO == null) continue;
            BigDecimal sectionNumB = settlementBookMaterialDetailEntity.getSectionNum() == null ? BigDecimal.ZERO : settlementBookMaterialDetailEntity.getSectionNum();
            BigDecimal bigDecimal = sectionNumBOriginal = settlementBookMaterialDetailVO.getSectionNum() == null ? BigDecimal.ZERO : settlementBookMaterialDetailVO.getSectionNum();
            if (sectionNumB.equals(sectionNumBOriginal)) continue;
        }
        Map<String, SettlementBookOtherDetailVO> otherDetailVOMap = this.otherDetailService.querySubcontractingvolumeOtherByContractId(entity.getContractId());
        for (SettlementBookOtherDetailEntity settlementBookOtherDetailEntity : entity.getSettlementBookOtherDetailEntities()) {
            String key = settlementBookOtherDetailEntity.getWithholdingOther() + settlementBookOtherDetailEntity.getDeductionsName() + settlementBookOtherDetailEntity.getExtaxUnitpriceC().setScale(2, RoundingMode.HALF_UP) + settlementBookOtherDetailEntity.getIntaxPriceC().setScale(2, RoundingMode.HALF_UP);
            SettlementBookOtherDetailVO settlementBookOtherDetailVO = otherDetailVOMap.get(key);
            if (settlementBookOtherDetailVO == null) continue;
        }
        return entity;
    }

    @Override
    public SettlementBookEntity totalForm(SettlementBookEntity entity) {
        Map<String, BigDecimal> map = this.statementDetailService.totalForm(entity.getSettlementBookStatementDetailEntities());
        Map<String, BigDecimal> materialMap = this.materialDetailService.totalForm(entity.getSettlementBookMaterialDetailEntities());
        Map<String, BigDecimal> otherMap = this.otherDetailService.totalForm(entity.getSettlementBookOtherDetailEntities());
        BigDecimal amount = map.get("amount").subtract(materialMap.get("amount")).subtract(otherMap.get("amount"));
        BigDecimal taxAmount = map.get("taxAmount").subtract(materialMap.get("taxAmount")).subtract(otherMap.get("taxAmount"));
        entity.setReportExamount(amount);
        entity.setReportInamount(taxAmount);
        return entity;
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( order_month, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (SettlementBookEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SettlementBookEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(order_month, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(SettlementBookEntity::getIsSettlement)).or()).eq(SettlementBookEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u5de5\u7a0b\u5206\u5305\u7ed3\u7b97\u4e66\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SettlementBookEntity::getProjectId, (Object)projectId)).ne(SettlementBookEntity::getBillState, (Object)3)).ne(SettlementBookEntity::getBillState, (Object)1)).apply("DATE_FORMAT(order_month, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u5de5\u7a0b\u5206\u5305\u7ed3\u7b97\u4e66\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }
}

