/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSetDetailEntity;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSettlementEntity;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSettlementService;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="turnoverLeaseSettlement")
public class TurnoverLeaseSettlementBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITurnoverLeaseSettlementService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------------------------------\u63d0\u4ea4\u524d\u56de\u8c03-------------------------------------------");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------------------------------\u63d0\u4ea4\u5b8c\u56de\u8c03-------------------------------------------");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------------------------------\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03-------------------------------------------");
        TurnoverLeaseSettlementEntity entity = (TurnoverLeaseSettlementEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(entity.getTurnoverLeaseSetDetailEntities())) {
            ArrayList<Long> sourceIdList = new ArrayList<Long>();
            for (TurnoverLeaseSetDetailEntity detailEntity : entity.getTurnoverLeaseSetDetailEntities()) {
                sourceIdList.add(detailEntity.getSourceId());
            }
            this.service.updateFlag(sourceIdList);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------------------------------\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03-------------------------------------------");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------------------------------\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03-------------------------------------------");
        TurnoverLeaseSettlementEntity entity = (TurnoverLeaseSettlementEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(entity.getTurnoverLeaseSetDetailEntities())) {
            ArrayList<Long> sourceIdList = new ArrayList<Long>();
            for (TurnoverLeaseSetDetailEntity detailEntity : entity.getTurnoverLeaseSetDetailEntities()) {
                sourceIdList.add(detailEntity.getSourceId());
            }
            List<TurnoverLeaseSetDetailVO> list = this.service.queryIsFlag(sourceIdList);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO : list) {
                    if (null == turnoverLeaseSetDetailVO.getIsFlag() || turnoverLeaseSetDetailVO.getIsFlag() != 1) continue;
                    throw new BusinessException("\u8be5\u5355\u636e\u5f15\u7528\u7684\u4e2d\u95f4\u8ba1\u91cf\u5355\u5df2\u88ab\u5f15\u7528\u8fc7\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u505a\uff01");
                }
            }
            this.service.updateIsFlag(sourceIdList);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------------------------------\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03-------------------------------------------");
        TurnoverLeaseSettlementEntity entity = (TurnoverLeaseSettlementEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(entity.getTurnoverLeaseSetDetailEntities())) {
            ArrayList<Long> sourceIdList = new ArrayList<Long>();
            for (TurnoverLeaseSetDetailEntity detailEntity : entity.getTurnoverLeaseSetDetailEntities()) {
                sourceIdList.add(detailEntity.getSourceId());
            }
            this.service.updateFlag(sourceIdList);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

