package com.ejianc.business.settlementmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settlementmanage.bean.*;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISubcontractCountersignedService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.*;
import com.ejianc.foundation.middlemeasurement.api.CostApi;
import com.ejianc.foundation.middlemeasurement.api.MidSettlementStateApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.middlemeasurement.vo.OverusedeductionRequestVO;
import com.ejianc.foundation.middlemeasurement.vo.SubVO;
import com.ejianc.foundation.middlemeasurement.vo.SubVOList;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工程分包结算书-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("settlementBook")
public class SettlementBookController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private SubcontractingApi subcontractingApi;
    @Qualifier("com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;
    @Qualifier("com.ejianc.foundation.middlemeasurement.api.MidSettlementStateApi")
    @Autowired
    private MidSettlementStateApi midSettlementStateApi;
    @Qualifier("com.ejianc.foundation.middlemeasurement.api.CostApi")
    @Autowired
    private CostApi costApi;

    private static final String BILL_CODE = "settlementmanage-settlement-book";//此处需要根据实际修改

    @Autowired
    private ISettlementBookService service;

    @Autowired
    private ISubcontractCountersignedService subcontractCountersignedService;

    @Autowired
    private IOutcontractApi outcontractApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementBookVO> saveOrUpdate(@RequestBody SettlementBookVO saveorUpdateVO) {
        SettlementBookEntity entity = BeanMapper.map(saveorUpdateVO, SettlementBookEntity.class);
        BigDecimal bigDecimal = new BigDecimal(0.00);//超用扣款本期金额除税
        BigDecimal bigDecimal1 = new BigDecimal(0.00);//超用扣款本期金额含税
        BigDecimal bigDecimal2 = new BigDecimal(0.00);//其他及代扣款本期金额除税
        BigDecimal bigDecimal3 = new BigDecimal(0.00);//其他及代扣款本期金额含税
        //校验：没有创建分包结算条件会签单不能新增单据
        checkSubcontract(entity.getContractId());
        //校验单据是否存在往期自由态的单据
        checkFormUniqueByMonth(entity);
        //单据编码唯一性校验
     /*   entity = checkBillCodeUniq(entity);*/
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<SettlementBookStatementDetailEntity> settlementBookStatementDetailEntities = entity.getSettlementBookStatementDetailEntities();
        if (!settlementBookStatementDetailEntities.isEmpty() && settlementBookStatementDetailEntities.size() > 0) {
            List<SubVOList> subVOList = new ArrayList<>();
            for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                String listingCode = settlementBookStatementDetail.getListingCode();
                String section = settlementBookStatementDetail.getSection();
                Long contractId = entity.getContractId();
                SubVOList list = new SubVOList();
                list.setSubitemCode(listingCode);
                list.setSection(section);
                list.setContractId(contractId);
                subVOList.add(list);
            }
            for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                //本期报量工程量 thisEngineeringQuantity  = 工程量 quantities  - 累计报量工程量 cumulativeEngineeringQuantity
                BigDecimal quantities = settlementBookStatementDetail.getQuantities() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getQuantities();
                if (settlementBookStatementDetail.getCumulativeEngineeringQuantity() == null) {
                    BigDecimal thisQuantity = quantities.subtract(new BigDecimal(0.00));
                    settlementBookStatementDetail.setCumulativeEngineeringQuantity(new BigDecimal(0.00));
                    settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                } else {
                    BigDecimal thisQuantity = quantities.subtract(settlementBookStatementDetail.getCumulativeEngineeringQuantity());
                    settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                }
                //本次报量金额（除税）thisAmountsNotax = 合价（除税） extaxAddition  - 累积报量金额（除税） accruingAmountsNotax
                BigDecimal extaxAddition = settlementBookStatementDetail.getExtaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getExtaxAddition();
                if (settlementBookStatementDetail.getAccruingAmountsNotax() == null) {
                    BigDecimal thisAmountsNotax = extaxAddition.subtract(new BigDecimal(0.00));
                    settlementBookStatementDetail.setAccruingAmountsNotax(new BigDecimal(0.00));
                    settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                } else {
                    BigDecimal thisAmountsNotax = extaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsNotax());
                    settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                }
                //本期报量金额（含税） thisAmountsTax = 合价（含税） intaxAddition - 累积报量金额（含税） accruingAmountsTax
                BigDecimal intaxAddition = settlementBookStatementDetail.getIntaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getIntaxAddition();
                if (settlementBookStatementDetail.getAccruingAmountsTax() == null) {
                    BigDecimal thisAmountsTax = intaxAddition.subtract(new BigDecimal(0.00));
                    settlementBookStatementDetail.setAccruingAmountsTax(new BigDecimal(0.00));
                    settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
                } else {
                    BigDecimal thisAmountsTax = intaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsTax());
                    settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
                }
            }
      /*      CommonResponse<Map<String, SubVO>> amount = subcontractingApi.getAmount(subVOList);
            if (amount.getCode() == 0) {
                for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                    String section = settlementBookStatementDetail.getSection();
                    String listingCode = settlementBookStatementDetail.getListingCode();
                    SubVO subVO = amount.getData().get(listingCode + section);
                    if(subVO != null ){
                        //累计除税
                        BigDecimal examineCumulativeAmounts = subVO.getExamineCumulativeAmounts() == null ? new BigDecimal(0.00) : subVO.getExamineCumulativeAmounts();
                        //累计含税
                        BigDecimal examineCumulativeTaxAmounts = subVO.getExamineCumulativeTaxAmounts() == null ? new BigDecimal(0.00) : subVO.getExamineCumulativeTaxAmounts();
                        settlementBookStatementDetail.setAccruingAmountsNotax(examineCumulativeAmounts);
                        settlementBookStatementDetail.setAccruingAmountsTax(examineCumulativeTaxAmounts);
                        //除税合价
                        BigDecimal extaxAddition = settlementBookStatementDetail.getExtaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getExtaxAddition();
                        //含税合价
                        BigDecimal intaxAddition = settlementBookStatementDetail.getIntaxAddition() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getIntaxAddition();
                        //本次报价（含税）
                        BigDecimal subtract = intaxAddition.subtract(examineCumulativeTaxAmounts);
                        //本次报价（除税）
                        BigDecimal subtract1 = extaxAddition.subtract(examineCumulativeAmounts);
                        //除税本次
                        settlementBookStatementDetail.setThisAmountsNotax(subtract1);
                        settlementBookStatementDetail.setThisAmountsTax(subtract);
                        //累计报量金额
                        BigDecimal examineCumulativeQuantity = subVO.getExamineCumulativeQuantity() == null ? new BigDecimal(0.00) : subVO.getExamineCumulativeQuantity();
                        settlementBookStatementDetail.setCumulativeEngineeringQuantity(examineCumulativeQuantity);
                        //工程量
                        BigDecimal quantities = settlementBookStatementDetail.getQuantities() == null ? new BigDecimal(0.00) : settlementBookStatementDetail.getQuantities();
                        if (examineCumulativeQuantity == null){
                            BigDecimal thisQuantity = quantities.subtract(new BigDecimal(0.00));
                            settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                        }else{
                            BigDecimal thisQuantity = quantities.subtract(examineCumulativeQuantity);
                            settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                        }
                    }else{

                    }
                }
            }*/
            entity.setSettlementBookStatementDetailEntities(settlementBookStatementDetailEntities);
        }
        //查询分包报量超用扣款
        if(!entity.getSettlementBookMaterialDetailEntities().isEmpty() && entity.getSettlementBookMaterialDetailEntities().size() > 0){
            List<OverusedeductionVO> list = new ArrayList<>();
            for(SettlementBookMaterialDetailEntity entity1 : entity.getSettlementBookMaterialDetailEntities()){
                OverusedeductionVO overusedeductionVO = new OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(entity1.getBillCode());
                overusedeductionVO.setSection(entity1.getSectionB());
                overusedeductionVO.setUnitPrice(entity1.getExtaxPurchasingprice());
                overusedeductionVO.setTaxUnitPrice(entity1.getIntaxPurchasingprice());
                list.add(overusedeductionVO);
            }
            List<com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO> list1 = BeanMapper.mapList(list,com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO.class);
            CommonResponse<Map<String, OverusedeductionRequestVO>> mapCommonResponse = costApi.queryOveruse(list1);
            if(mapCommonResponse.isSuccess()){
                for(SettlementBookMaterialDetailEntity entity2 : entity.getSettlementBookMaterialDetailEntities()){
                    OverusedeductionRequestVO overusedeductionRequestVO = mapCommonResponse.getData().get(entity2.getBillCode() + entity2.getSectionB()+entity2.getExtaxPurchasingprice()+entity2.getIntaxPurchasingprice());
                    if(overusedeductionRequestVO != null){
                        entity2.setCumExtaxSectionprice(overusedeductionRequestVO.getAmounts());
                        entity2.setCumIntaxSectionprice(overusedeductionRequestVO.getTaxAmounts());
                        if(entity2.getExtaxSectionprice() == null){
                            entity2.setCurExtaxSectionprice(new BigDecimal(0.00));
                        }else{
                            entity2.setCurExtaxSectionprice(entity2.getExtaxSectionprice().subtract(entity2.getCumExtaxSectionprice()));
                        }

                        if(entity2.getIntaxSectionprice() == null){
                            entity2.setCurIntaxSectionprice(new BigDecimal(0.00));
                        }else{
                            entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                        }
                    }else{
                        entity2.setCumExtaxSectionprice(new BigDecimal(0.00));
                        entity2.setCumIntaxSectionprice(new BigDecimal(0.00));
                        entity2.setCurExtaxSectionprice(entity2.getExtaxSectionprice().subtract(entity2.getCumExtaxSectionprice()));
                        entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                    }
                    bigDecimal = bigDecimal.add(entity2.getCurExtaxSectionprice());
                    bigDecimal1 = bigDecimal1.add(entity2.getCurIntaxSectionprice());
                }
            }
        }
        //查询分包报量其他及代扣款
        if(!entity.getSettlementBookOtherDetailEntities().isEmpty() && entity.getSettlementBookOtherDetailEntities().size() > 0){
            List<OverusedeductionVO> list = new ArrayList<>();
            for(SettlementBookOtherDetailEntity entity3 : entity.getSettlementBookOtherDetailEntities()){
                OverusedeductionVO overusedeductionVO = new OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(entity3.getWithholdingOther());
                overusedeductionVO.setSection(entity3.getDeductionsName());
                overusedeductionVO.setUnitPrice(entity3.getExtaxUnitpriceC());
                overusedeductionVO.setTaxUnitPrice(entity3.getIntaxUnitpriceC());
                list.add(overusedeductionVO);
            }
            List<com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO> list1 = BeanMapper.mapList(list,com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO.class);
            CommonResponse<Map<String, OverusedeductionRequestVO>> mapCommonResponse = costApi.queryOther(list1);
            if(mapCommonResponse.isSuccess()){
                for(SettlementBookOtherDetailEntity entity4 : entity.getSettlementBookOtherDetailEntities()){
                    OverusedeductionRequestVO overusedeductionRequestVO = mapCommonResponse.getData().get(entity4.getWithholdingOther() + entity4.getDeductionsName()+entity4.getExtaxUnitpriceC()+entity4.getIntaxUnitpriceC());
                    if(overusedeductionRequestVO != null){
                        entity4.setCumExtaxPrice(overusedeductionRequestVO.getAmounts());
                        entity4.setCumIntaxPrice(overusedeductionRequestVO.getTaxAmounts());
                        if(entity4.getExtaxPriceC() == null){
                            entity4.setCurExtaxPrice(new BigDecimal(0.00));
                        }else{
                            entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        }

                        if(entity4.getIntaxPriceC() == null){
                            entity4.setCurIntaxPrice(new BigDecimal(0.00));
                        }else{
                            entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                        }
                    }else{
                        entity4.setCumExtaxPrice(new BigDecimal(0.00));
                        entity4.setCumIntaxPrice(new BigDecimal(0.00));
                        entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                    }
                    bigDecimal2 = bigDecimal2.add(entity4.getCurExtaxPrice());
                    bigDecimal3 = bigDecimal3.add(entity4.getCurIntaxPrice());
                }
            }
        }
        //汇总表同步数据
        if(!entity.getSettlementBookSummaryDetailEntities().isEmpty() && entity.getSettlementBookSummaryDetailEntities().size() > 0){
            for(SettlementBookSummaryDetailEntity entity5 : entity.getSettlementBookSummaryDetailEntities()){
                if(entity5.getProjectName().equals("材料节超")){
                    entity5.setExtaxPrice(bigDecimal);
                    entity5.setIntaxPrice(bigDecimal1);
                }
                if(entity5.getProjectName().equals("其他扣款")){
                    entity5.setExtaxPrice(bigDecimal2);
                    entity5.setIntaxPrice(bigDecimal3);
                }
            }
        }
        entity = service.totalForm(entity);
        for(SettlementBookMaterialDetailEntity entitys:entity.getSettlementBookMaterialDetailEntities()){
            entitys.setRowState("edit");
        }
        service.saveOrUpdate(entity, false);
        //回写分包中间计量状态
        List<Long> ids = new ArrayList<>();
        for(SettlementBookMaterialDetailEntity entitys:entity.getSettlementBookMaterialDetailEntities()){
            if(entitys.getIsMiddId() != null){
                ids.add(entitys.getIsMiddId());
            }
        }
        if(CollectionUtils.isNotEmpty(ids)){
            service.updateIsMiddId(ids);
        }

        SettlementBookVO vo = BeanMapper.map(entity, SettlementBookVO.class);
        vo.setSettlementBookStatementDetailEntities(handleChildren(vo.getSettlementBookStatementDetailEntities()));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 页面新增清单编号后重新构建树
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/refreshData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        Map<String, SettlementBookStatementDetailVO> map = new HashMap<>();
        SettlementBookStatementDetailVO add = list.get(list.size() - 1);
        for (SettlementBookStatementDetailVO VO : list) {
            if (VO.getId() == null){
                VO.setId(IdWorker.getId());
            }
        }
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getListingCode() + "_" + add.getSection());//清单编码确定唯一性
        //查询该清单编码往期累计
        //创建条件构造器
/*        QueryWrapper<SettlementBookStatementDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", add.getContractId());
        queryWrapper.eq("listing_code", add.getListingCode());
        queryWrapper.eq("section", add.getSection());
        queryWrapper.eq("examine_unitprice", add.getExamineUnitprice());
        queryWrapper.eq("examine_tax_unitprice", add.getExamineTaxUnitprice());
        queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
        List<SubcontractingvolumedetailEntity> pastDetails = subcontractingvolumedetailService.list(queryWrapper);
        if(pastDetails != null && pastDetails.size() > 0){
            BigDecimal examineQuantity = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineTaxAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineTaxAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
            add.setExamineCumulativeQuantity(examineQuantity);
            add.setExamineCumulativeAmounts(examineAmounts);
            add.setExamineCumulativeTaxAmounts(examineTaxAmounts);
        }*/
//		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapperNum = new QueryWrapper<>();
//		queryWrapperNum.eq("contract_id", add.getContractId());
//		queryWrapperNum.eq("subitem_code", add.getSubitemCode());
//		queryWrapperNum.eq("section", add.getSection());
//		queryWrapperNum.in("bill_state", 1, 3);//1直审 3审批通过
//		queryWrapperNum.eq("dr", "0");
//		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList = subcontractingvolumedetailService.list(queryWrapperNum);
//		if(CollectionUtils.isNotEmpty(subcontractingvolumedetailEntityList)){
//			BigDecimal examineQuantity = subcontractingvolumedetailEntityList.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
//			add.setSumNum(examineQuantity);
//		}

        //判断新增行是合同内还是合同外
        CommonResponse<List<OutcontractSubcontractUnitPriceVO>> outcontractResp = outcontractApi.queryListBycontractIdAndCode(add.getContractId(), add.getListingCode());
        int responseCode = outcontractResp.getCode();
        if(responseCode == 0){
            List<OutcontractSubcontractUnitPriceVO> voList = outcontractResp.getData();
            if(voList != null && voList.size() > 0){
                OutcontractSubcontractUnitPriceVO priceVO = voList.get(0);
                BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();//综合单价
                add.setSource("合同内");//合同内
                add.setIntaxUnitprice(comprehensiveUnitPrice);//含税单价
                BigDecimal tax = priceVO.getTax();//税金
                BigDecimal engineeringQuantity = priceVO.getEngineeringQuantity();//工程量
                if(tax != null && engineeringQuantity != null && engineeringQuantity.compareTo(BigDecimal.ZERO) != 0){
                    //除税单价 = 综合单价 - 税金/工程量
                    BigDecimal temp = tax.divide(engineeringQuantity, 8, BigDecimal.ROUND_HALF_UP);
                    add.setExtaxUnitprice(comprehensiveUnitPrice.subtract(temp));//除税单价
                }else {
                    add.setExtaxUnitprice(comprehensiveUnitPrice);
                }
            }else {
                add.setSource("合同外");//合同外
            }
        }else {
            add.setSource("合同外");//合同外
        }

        for (SettlementBookStatementDetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode()) && add.getExsettlementUnitprice().equals(vo.getExsettlementUnitprice()) && add.getInsettlementUnitprice().equals(vo.getInsettlementUnitprice())) {
                throw new BusinessException("数据已存在，请重新填写");
            }
        }
        //判断新增数据的上级清单编码和区段是否有重复值,有的话不能新增
        String subitemCode = add.getListingCode();
        String section = add.getSection();
        String innercodeDouble = null;
        Map<String, List<SettlementBookStatementDetailVO>> mapDouble = list.stream().collect(
                Collectors.groupingBy(
                        s -> s.getListingCode()+'_'+s.getSection()
                ));
        if (subitemCode.length() == 4){
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            checkDouble(innercodeDouble, mapDouble);
        }
        if (subitemCode.length() == 6){
            innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
            checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            checkDouble(innercodeDouble, mapDouble);
        }
        if (subitemCode.length() > 6){
            innercodeDouble = subitemCode.substring(0, 6) + "_" + section;
            checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
            checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            checkDouble(innercodeDouble, mapDouble);
        }

        //设置父级id
        for (SettlementBookStatementDetailVO vo : list) {
            String innercode = vo.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }

            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);

            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                vo.setTpid(pid.toString());
            } else {
                vo.setTpid("");
            }
        }
        list = handleChildren(list);

        //统计父级的合计数值
//		getChildrenUnitTotalAmount(list);
        json.put("dataSource", list);

        return CommonResponse.success(json);
    }
    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<SettlementBookStatementDetailVO> handleChildren(List<SettlementBookStatementDetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<SettlementBookStatementDetailVO>() {
            @Override
            public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                return (o1.getListingCode() + o1.getSection()).compareTo(o2.getListingCode() + o2.getSection());
            }
        });

        //获取子集,汇总数据
        List<String> tpidList = voList.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
        for(SettlementBookStatementDetailVO subcontractingvolumedetailVO : voList){
            List<SettlementBookStatementDetailVO> detailByPid = getDetailByPid(subcontractingvolumedetailVO.getTid(), voList);

            if (CollectionUtils.isNotEmpty(detailByPid)){

                subcontractingvolumedetailVO.setCumulativeEngineeringQuantity(null);
                subcontractingvolumedetailVO.setThisEngineeringQuantity(null);
                subcontractingvolumedetailVO.setExtaxAddition(null);
                subcontractingvolumedetailVO.setIntaxAddition(null);
                subcontractingvolumedetailVO.setExsettlementUnitprice(null);
                subcontractingvolumedetailVO.setInsettlementUnitprice(null);
                subcontractingvolumedetailVO.setSource(null);

                BigDecimal thisAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsNotax() != null).map(SettlementBookStatementDetailVO::getThisAmountsNotax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal thisAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsTax() != null).map(SettlementBookStatementDetailVO::getThisAmountsTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal accruingAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsNotax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsNotax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal accruingAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsTax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal intaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getIntaxAddition() != null).map(SettlementBookStatementDetailVO::getIntaxAddition)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal extaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExtaxAddition() != null).map(SettlementBookStatementDetailVO::getExtaxAddition)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                subcontractingvolumedetailVO.setThisAmountsNotax(thisAmountsNotax);
                subcontractingvolumedetailVO.setThisAmountsTax(thisAmountsTax);
                subcontractingvolumedetailVO.setAccruingAmountsNotax(accruingAmountsNotax);
                subcontractingvolumedetailVO.setAccruingAmountsTax(accruingAmountsTax);
                subcontractingvolumedetailVO.setIntaxAddition(intaxAddition);
                subcontractingvolumedetailVO.setExtaxAddition(extaxAddition);

                subList.clear();
            }
        }

        //构建树
        voList = createTreeData(voList);


        return voList;
    }

    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        List<SettlementBookStatementDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SettlementBookStatementDetailVO> listMap = new HashMap<>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SettlementBookStatementDetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = (List<SettlementBookStatementDetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    List<SettlementBookStatementDetailVO> subList = new ArrayList<>();
    private List<SettlementBookStatementDetailVO> getDetailByPid(String tid, List<SettlementBookStatementDetailVO> list) {

        for (SettlementBookStatementDetailVO subcontractingvolumedetailVO : list) {
            if (tid != null && tid.equals(subcontractingvolumedetailVO.getTpid())) {
                getDetailByPid(subcontractingvolumedetailVO.getTid(), list);
                subList.add(subcontractingvolumedetailVO);
            }
        }
        return subList;
    }


    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }


    private void checkDouble(String innercode, Map<String, List<SettlementBookStatementDetailVO>> mapDouble) {
        if (mapDouble.containsKey(innercode)){
            List<SettlementBookStatementDetailVO> subcontractingvolumedetailVOS = mapDouble.get(innercode);
            if (subcontractingvolumedetailVOS.size() > 1){
                throw new BusinessException("父级编码重复,无法新增!");
            }
            for (SettlementBookStatementDetailVO vo :subcontractingvolumedetailVOS){
                if (vo.getInsettlementUnitprice() != null || vo.getExsettlementUnitprice() != null || vo.getExtaxUnitprice() != null || vo.getIntaxUnitprice() != null){
                    throw new BusinessException("父级已有数据,无法新增!");
                }
            }

        }
    }


    /**
     * 新增工程分包结算书，没有创建分包结算条件会签单则不能新增
     *
     * @param
     * @param contractId
     */
    private void checkSubcontract(Long contractId) {
        QueryWrapper<SubcontractCountersignedEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
        List<SubcontractCountersignedEntity> pro = subcontractCountersignedService.list(queryWrapper);
        if (pro.isEmpty()) {
            throw new BusinessException("请先创建\"分包结算条件会签单\"!");
        }
    }

    /**
     * 校验结算书此合同小于等于年月是否存在自由态单据
     * @param entity
     */
    private void checkFormUniqueByMonth(SettlementBookEntity entity){
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        String date = sf.format(entity.getOrderMonth());
        QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", entity.getContractId());
        queryWrapper.le("DATE_FORMAT( order_month, '%Y-%m' )",date);
        queryWrapper.eq("bill_state", 0);//1直审 3审批通过
        if (entity.getId() != null)
            queryWrapper.ne("id",entity.getId());
        int count = service.count(queryWrapper);
        if (count > 0)
            throw new BusinessException("此合同存在往期已保存未提交结算单,请先提交往期未提交结算单");
        QueryWrapper<SettlementBookEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("contract_id", entity.getContractId());
        queryWrapper1.eq("DATE_FORMAT( order_month, '%Y-%m' )",date);
        if (entity.getId() != null)
            queryWrapper1.ne("id",entity.getId());
        int count1 = service.count(queryWrapper1);
        if (count1 > 0)
            throw new BusinessException("此合同当前月份已存在结算单，无法保存");


    }


    /**
     * 单据编码唯一性校验
     *
     * @param entity
     */
    private SettlementBookEntity checkBillCodeUniq(SettlementBookEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<SettlementBookEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            if (entity.getId() != null && entity.getId() != 0) {
                queryWrapperBillCode.ne("id", entity.getId());
            }
            List<SettlementBookEntity> proBillCode = service.list(queryWrapperBillCode);

            if (proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }
        return entity;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementBookVO> queryDetail(Long id) {
        SettlementBookEntity entity = service.selectById(id);
        SettlementBookVO vo = BeanMapper.map(entity, SettlementBookVO.class);
        vo.setSettlementBookStatementDetailEntities(handleChildren(vo.getSettlementBookStatementDetailEntities()));
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementBookVO> vos) {
        service.removeByIds(vos.stream().map(SettlementBookVO::getId).collect(Collectors.toList()), true);
        midSettlementStateApi.updateMidSettlementState(vos.get(0).getProjectId(),1,vos.get(0).getOrderMonth().toString());
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettlementBookEntity> page = service.queryPage(param, false);
        IPage<SettlementBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementBookVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<SettlementBookEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SettlementBookVO> settlementBookVOList = BeanMapper.mapList(list, SettlementBookVO.class);
        for (int i = 0; i < settlementBookVOList.size(); i++) {
            SettlementBookVO settlementBookVO = settlementBookVOList.get(i);
            if (settlementBookVO.getCreateTime() != null) {
                settlementBookVO.setCreateTimeShow(DateUtils.dateSimple2(settlementBookVO.getCreateTime()));
            }

            String billStateStr = settlementBookVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "审批驳回";
                }
                settlementBookVO.setBillStateStr(billStateStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settlementBookVOList);
        ExcelExport.getInstance().export("SettlementBook-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettlementBookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> refSettlementBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementBookEntity> page = service.queryPage(param, false);
        IPage<SettlementBookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementBookVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 根据合同id查询分包月度报量子表和物资节超数据
     * @param contractId 合同id
     * @return
     */
    @RequestMapping(value = "/querySubcontractingvolumeByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,List>> querySubcontractingvolumeMaterialByContractId(@RequestParam(value = "contractId") Long contractId){
        Map<String,List> map = new HashMap<>();
        Map<String, SettlementBookStatementDetailVO> mapVO = new HashMap<>();
        //请求分包月度报量及申请报告子表数据服务
        List<SettlementBookStatementDetailVO> statementDetailVOList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO>> statementResponse =
                subcontractingvolumeApi.querySubcontractingvolumeDetailByContractId(contractId);
        if (statementResponse.isSuccess()){
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO> data = statementResponse.getData();
            statementDetailVOList = BeanMapper.mapList(data, SettlementBookStatementDetailVO.class);
            for (SettlementBookStatementDetailVO VO : statementDetailVOList) {
                VO.setId(IdWorker.getId());
                VO.setTid(String.valueOf(IdWorker.getId()));
                VO.setIsDeleted("否");
                VO.setInnercode(VO.getListingCode()+ "_" + VO.getSection());//清单编号确定唯一性
                if("1".equals(VO.getSource())){
                    VO.setSource("合同内");
                }
                if("2".equals(VO.getSource())){
                    VO.setSource("合同外");
                    VO.setExtaxUnitprice(null);
                    VO.setIntaxUnitprice(null);
                }
                //重复性校验
                SettlementBookStatementDetailVO reVo = mapVO.get(VO.getInnercode());
                if (reVo == null) {
                    mapVO.put(VO.getInnercode(), VO);
                } /*else {
                    throw new BusinessException("清单编号已存在");
                }*/
            }


            //按子目编码排序
            Collections.sort(statementDetailVOList, new Comparator<SettlementBookStatementDetailVO>() {
                @Override
                public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                    return (o1.getListingCode() + o1.getSection()).compareTo(o2.getListingCode() + o2.getSection());
                }
            });
            //设置tid和tpid
            List<SettlementBookStatementDetailVO> resList = setTidAndTpid(statementDetailVOList, mapVO);

            //获取子集,汇总数据
            List<String> tpidList = resList.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
            for(SettlementBookStatementDetailVO subcontractingvolumedetailVO : resList){
                List<SettlementBookStatementDetailVO> detailByPid = getDetailByPid(subcontractingvolumedetailVO.getTid(), resList);

                if (CollectionUtils.isNotEmpty(detailByPid)){

                    subcontractingvolumedetailVO.setCumulativeEngineeringQuantity(null);
                    subcontractingvolumedetailVO.setThisEngineeringQuantity(null);
                    subcontractingvolumedetailVO.setExtaxAddition(null);
                    subcontractingvolumedetailVO.setIntaxAddition(null);
                    subcontractingvolumedetailVO.setExsettlementUnitprice(null);
                    subcontractingvolumedetailVO.setInsettlementUnitprice(null);
                    subcontractingvolumedetailVO.setSource(null);

                    BigDecimal thisAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsNotax() != null).map(SettlementBookStatementDetailVO::getThisAmountsNotax)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal thisAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsTax() != null).map(SettlementBookStatementDetailVO::getThisAmountsTax)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal accruingAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsNotax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsNotax)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal accruingAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsTax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsTax)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal intaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getIntaxAddition() != null).map(SettlementBookStatementDetailVO::getIntaxAddition)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal extaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExtaxAddition() != null).map(SettlementBookStatementDetailVO::getExtaxAddition)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    subcontractingvolumedetailVO.setIntaxAddition(intaxAddition);
                    subcontractingvolumedetailVO.setExtaxAddition(extaxAddition);
                    subcontractingvolumedetailVO.setThisAmountsNotax(thisAmountsNotax);
                    subcontractingvolumedetailVO.setThisAmountsTax(thisAmountsTax);
                    subcontractingvolumedetailVO.setAccruingAmountsNotax(accruingAmountsNotax);
                    subcontractingvolumedetailVO.setAccruingAmountsTax(accruingAmountsTax);
                    subList.clear();
                }
            }

            for(SettlementBookStatementDetailVO subcontractingvolumedetailVO:resList){
                subcontractingvolumedetailVO.setQuantities(subcontractingvolumedetailVO.getCumulativeEngineeringQuantity());//工程量
                subcontractingvolumedetailVO.setIntaxAddition(subcontractingvolumedetailVO.getAccruingAmountsTax());//合价(含税)
                subcontractingvolumedetailVO.setExtaxAddition(subcontractingvolumedetailVO.getAccruingAmountsNotax());//合价(除税)
            }

            resList = createTreeData(resList);
            map.put("statementDetailVOList",resList);
        }else {
            throw new BusinessException(statementResponse.getMsg());
        }
        //请求查询物资节超服务
        List<SettlementBookMaterialDetailVO> materialDetailVOList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO>> materialResponse =
                subcontractingvolumeApi.querySubcontractingvolumeMaterialByContractId(contractId);
        if (materialResponse.isSuccess()){
           /* if (!CollectionUtils.isNotEmpty(materialResponse.getData())) {
                throw new BusinessException("该合同已生成工程分包结算书！");
            }*/
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO> data =
                    materialResponse.getData();
            materialDetailVOList = BeanMapper.mapList(data,SettlementBookMaterialDetailVO.class);
            Map<Long, com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO> maps = data.stream().collect(Collectors.toMap(com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO::getId, Function.identity()));
            for (SettlementBookMaterialDetailVO settlementBookMaterialDetailVO : materialDetailVOList) {
                settlementBookMaterialDetailVO.setMaterialCode(maps.get(settlementBookMaterialDetailVO.getId()).getBillCodeB());
                settlementBookMaterialDetailVO.setMaterialName(maps.get(settlementBookMaterialDetailVO.getId()).getMaterialNameB());
                settlementBookMaterialDetailVO.setSort(maps.get(settlementBookMaterialDetailVO.getId()).getSort());
                settlementBookMaterialDetailVO.setSpec(maps.get(settlementBookMaterialDetailVO.getId()).getSubitemDesc());
                settlementBookMaterialDetailVO.setUnits(maps.get(settlementBookMaterialDetailVO.getId()).getUnitsB());
                settlementBookMaterialDetailVO.setExtaxPurchasingprice(maps.get(settlementBookMaterialDetailVO.getId()).getExtaxPurchasingpriceB());
                settlementBookMaterialDetailVO.setIntaxPurchasingprice(maps.get(settlementBookMaterialDetailVO.getId()).getIntaxPurchasingprice());
                settlementBookMaterialDetailVO.setDosageCollar(new BigDecimal(maps.get(settlementBookMaterialDetailVO.getId()).getDosageCollarB()));
                settlementBookMaterialDetailVO.setSettlementNum(new BigDecimal(maps.get(settlementBookMaterialDetailVO.getId()).getSectionNumB()));
                settlementBookMaterialDetailVO.setSectionNum(new BigDecimal(maps.get(settlementBookMaterialDetailVO.getId()).getSectionNumB()));
                settlementBookMaterialDetailVO.setExtaxSectionprice(maps.get(settlementBookMaterialDetailVO.getId()).getExtaxSectionpriceB());
                settlementBookMaterialDetailVO.setIntaxSectionprice(maps.get(settlementBookMaterialDetailVO.getId()).getIntaxSectionprice());
                settlementBookMaterialDetailVO.setIsEditState("否");
                settlementBookMaterialDetailVO.setIsMiddId(maps.get(settlementBookMaterialDetailVO.getId()).getMid());//回写状态id
                settlementBookMaterialDetailVO.setIsDeleted("否");
            }
            map.put("materialDetailVOList",materialDetailVOList);
        }else {
            throw new BusinessException(materialResponse.getMsg());
        }
        //其他扣款查询服务
        List<SettlementBookOtherDetailVO> otherDetailVOArrayList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO>> otherResponse =
                subcontractingvolumeApi.querySubcontractingvolumeOtherByContractId(contractId);
        if (otherResponse.isSuccess()){
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO> data =
                    otherResponse.getData();
            otherDetailVOArrayList = BeanMapper.mapList(data,SettlementBookOtherDetailVO.class);
            for (SettlementBookOtherDetailVO settlementBookOtherDetailVO : otherDetailVOArrayList) {
                settlementBookOtherDetailVO.setId(IdWorker.getId());
//                settlementBookOtherDetailVO.setIsEditState("否");
                settlementBookOtherDetailVO.setIsDeleted("否");
            }
            map.put("otherDetailVOArrayList",otherDetailVOArrayList);
        }else {
            throw new BusinessException(otherResponse.getMsg());
        }
        return CommonResponse.success("查询分包月度报量相关数据成功",map);
    }

    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if(vos == null){
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            SettlementBookStatementDetailVO consdrawbudgetdetailVO = vos.get(i);
            //设置父级id
            String innercode = consdrawbudgetdetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }

            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }


            if (pid != null) {
                consdrawbudgetdetailVO.setTpid(pid.toString());
            } else {
                consdrawbudgetdetailVO.setTpid("");
            }
        }

        return vos;
    }


}
