package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.settlementmanage.vo.MaterialSettleDetailVO;
import com.ejianc.business.settlementmanage.vo.MaterialSettleVO;
import com.ejianc.foundation.middlemeasurement.api.IPurchasesettlementApi;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.MaterialSettleMapper;
import com.ejianc.business.settlementmanage.bean.MaterialSettleEntity;
import com.ejianc.business.settlementmanage.service.IMaterialSettleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 物资采购最终结算
 *
 * @author generator
 *
 */
@Service("materialSettleService")
public class MaterialSettleServiceImpl extends BaseServiceImpl<MaterialSettleMapper, MaterialSettleEntity> implements IMaterialSettleService{

    private static final String BILL_CODE = "settlemanage_material_settle";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPurchasesettlementApi purchasesettlementApi;

    @Autowired
    private IOutcontractApi outcontractApi;

    @Override
    public MaterialSettleVO saveOrUpdate(MaterialSettleVO materialSettleVO) {
        MaterialSettleEntity entity = BeanMapper.map(materialSettleVO, MaterialSettleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), materialSettleVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        MaterialSettleVO vo = BeanMapper.map(entity, MaterialSettleVO.class);
        return vo;
    }

    @Override
    public MaterialSettleVO queryDetail(Long id) {
        MaterialSettleEntity entity = selectById(id);
        MaterialSettleVO vo = BeanMapper.map(entity, MaterialSettleVO.class);
        return vo;
    }

    @Override
    public MaterialSettleVO queryMidDataByCont(Long contractId, Long id) {
        LambdaQueryWrapper<MaterialSettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialSettleEntity::getContractId, contractId);
        queryWrapper.ne(null != id ,MaterialSettleEntity::getId, id);
        if (count(queryWrapper) > 0) {
            throw new BusinessException("该合同已存在最终结算单！");
        }
        MaterialSettleVO materialSettleVO = new MaterialSettleVO();
        CommonResponse<List<PurchasesettlementVO>> commonResponse = purchasesettlementApi.queryListByCont(contractId);
        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
            List<PurchasesettlementVO> purchaseList = commonResponse.getData();
            List<PurchasesettlementVO> result = new ArrayList<>();
            for (PurchasesettlementVO settleVO : purchaseList) {
                if (!settleVO.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !settleVO.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("该合同已存在未生效的中间计量单！");
                } else {
                    result.add(settleVO);
                }
            }
            BigDecimal sumMny = BigDecimal.ZERO;
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            List<MaterialSettleDetailVO> detailVOList = new ArrayList<>();
            for (PurchasesettlementVO settleVO : result) {
                sumMny = ComputeUtil.safeAdd(sumMny, settleVO.getMeasureCost());

                for (PurchasesettlementdetailVO purchaseDetailVO : settleVO.getPurchasesettlementdetailEntities()) {
                    sumSettleMny = ComputeUtil.safeAdd(sumSettleMny, purchaseDetailVO.getSettlementAmount());
                    sumSettleTaxMny = ComputeUtil.safeAdd(sumSettleTaxMny, purchaseDetailVO.getTaxSettlementAmount());

                    MaterialSettleDetailVO settleDetailVO = BeanMapper.map(purchaseDetailVO, MaterialSettleDetailVO.class);
                    settleDetailVO.setSource(String.valueOf(purchaseDetailVO.getId()));
                    settleDetailVO.setSourceType(1);
                    settleDetailVO.setCreateTime(null);
                    settleDetailVO.setCreateUserCode(null);
                    settleDetailVO.setUpdateTime(null);
                    settleDetailVO.setUpdateUserCode(null);
                    settleDetailVO.setVersion(1);
                    settleDetailVO.setId(null);
                    settleDetailVO.setSettleCode(settleVO.getBillCode());
                    settleDetailVO.setSettleDate(settleVO.getOccurrenceTime());
                    settleDetailVO.setMaterialCode(purchaseDetailVO.getBillCode());
                    settleDetailVO.setMaterialName(purchaseDetailVO.getBillName());
                    settleDetailVO.setRowState("add");
                    detailVOList.add(settleDetailVO);
                }
            }
            materialSettleVO = BeanMapper.map(result.get(0), MaterialSettleVO.class);
            materialSettleVO.setId(null);
            materialSettleVO.setCreateTime(null);
            materialSettleVO.setCreateUserCode(null);
            materialSettleVO.setUpdateTime(null);
            materialSettleVO.setUpdateUserCode(null);
            materialSettleVO.setBillCode(null);
            materialSettleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            materialSettleVO.setSumMeasureSettleMny(sumMny);
            materialSettleVO.setSumSettleMny(sumSettleMny);
            materialSettleVO.setSumSettleTaxMny(sumSettleTaxMny);

            materialSettleVO.setDetailList(detailVOList);
        } else {
            CommonResponse<OutcontractVO> response = outcontractApi.queryDetail(contractId);
            OutcontractVO outcontractVO = response.getData();
            materialSettleVO.setContractId(outcontractVO.getId());
            materialSettleVO.setContractCode(outcontractVO.getBillCode());
            materialSettleVO.setContractName(outcontractVO.getContractName());
            materialSettleVO.setProjectId(outcontractVO.getProjectId());
            materialSettleVO.setProjectName(outcontractVO.getProjectName());
            materialSettleVO.setOrgId(outcontractVO.getOrgId());
            materialSettleVO.setOrgName(outcontractVO.getOrgName());
            materialSettleVO.setSupplierId(outcontractVO.getSupplier());
            materialSettleVO.setSupplierName(outcontractVO.getSupplierName());
            materialSettleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }
        if (null != id) {
            MaterialSettleEntity materialSettleEntity = selectById(id);
            materialSettleVO.setId(materialSettleEntity.getId());
            materialSettleVO.setCreateTime(materialSettleEntity.getCreateTime());
            materialSettleVO.setCreateUserCode(materialSettleEntity.getCreateUserCode());
            materialSettleVO.setUpdateTime(materialSettleEntity.getUpdateTime());
            materialSettleVO.setUpdateUserCode(materialSettleEntity.getUpdateUserCode());
            materialSettleVO.setBillCode(materialSettleEntity.getBillCode());
            materialSettleVO.setVersion(materialSettleEntity.getVersion());
            materialSettleVO.setTenantId(materialSettleEntity.getTenantId());
        }
        return materialSettleVO;
    }
}
