package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalodetailEntity;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalodetailService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinaldetailService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 咨询及其他类合同最终结算单导入导出
 */
@Controller
@RequestMapping("consultotherfinalExport")
public class ExcelConsultotherfinalController {

	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IConsultotherfinalService service;
	@Autowired
	private IConsultotherfinaldetailService consultotherfinaldetailService;
	@Autowired
	private IConsultotherfinalodetailService consultotherfinalodetailService;

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download", method = RequestMethod.POST)
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "consultotherfinaldetail-import.xlsx", "咨询及其他类合同最终结算单-最终结算计价明表");
	}

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download3", method = RequestMethod.POST)
	@ResponseBody
	public void download3(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "consultotherfinalodetail-import.xlsx", "其它扣款清单");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response, Long contractId, String date)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ConsultotherfinaldetailVO> successList = new ArrayList<>();
		List<ConsultotherfinaldetailVO> errorList = new ArrayList<>();
		Map<String, ConsultotherfinaldetailVO> map = new HashMap<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			Map<String, ConsultotherfinaldetailVO> map1 = service.queryConsultDetailCumPastMap(contractId, date);
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					List<String> datas = result.get(i);
					StringBuilder errorsMsgBuilder = new StringBuilder();

					String subitemName = datas.get(0);//名称
					String spec = datas.get(1);//规格
					String unit = datas.get(2);//单位
					String unitprice = datas.get(3);//除税单价
					String taxUnitprice = datas.get(4);//含税单价
					String quantity = datas.get(5);//数量
					String amounts = datas.get(6);//除税金额
					String taxAmounts = datas.get(7);//含税金额
					String source = datas.get(8);//来源
					String memo = datas.get(9);//备注

					ConsultotherfinaldetailVO detailVO = new ConsultotherfinaldetailVO();
					detailVO.setId(IdWorker.getId());//id
					detailVO.setTid(String.valueOf(IdWorker.getId()));//tid
					detailVO.setContractId(contractId);//合同id

					detailVO.setSubitemName(subitemName); // 名称
					detailVO.setSpec(spec); // 规格
					detailVO.setUnit(unit); //单位

					if("合同内".equals(source)){
						detailVO.setSource("1"); //来源
					}else if("合同外".equals(source)){
						detailVO.setSource("2"); //来源
					}

					detailVO.setMemo(memo); //备注

					//必填项校验
					if (subitemName == null || TextUtils.isEmpty(subitemName)) {
						detailVO.setErrorMsg("名称不能为空！");
						errorsMsgBuilder.append("名称不能为空！");
					}
					if (unit == null || TextUtils.isEmpty(unit)) {
						detailVO.setErrorMsg("单位不能为空！");
						errorsMsgBuilder.append("单位不能为空！");
					}
					if (quantity == null || TextUtils.isEmpty(quantity)) {
						detailVO.setErrorMsg("数量不能为空！");
						errorsMsgBuilder.append("数量不能为空！");
					}
					if (unitprice == null || TextUtils.isEmpty(unitprice)) {
						detailVO.setErrorMsg("除税单价不能为空！");
						errorsMsgBuilder.append("除税单价不能为空！");
					}
					if (taxUnitprice == null || TextUtils.isEmpty(taxUnitprice)) {
						detailVO.setErrorMsg("含税单价不能为空！");
						errorsMsgBuilder.append("含税单价不能为空！");
					}

					//格式校验
					if (StringUtils.isNotBlank(quantity)) {
						if(!NumberUtil.isNumber(quantity)){
							detailVO.setErrorMsg("数量格式不正确！");
							errorsMsgBuilder.append("数量格式不正确！");
						}else {
							detailVO.setQuantity(new BigDecimal(quantity));
						}
					}

					if (StringUtils.isNotBlank(unitprice)) {
						if(!NumberUtil.isNumber(unitprice)){
							detailVO.setErrorMsg("除税单价格式不正确！");
							errorsMsgBuilder.append("除税单价格式不正确！");
						}else {
							detailVO.setUnitprice(new BigDecimal(unitprice));
						}
					}

					if (StringUtils.isNotBlank(taxUnitprice)) {
						if(!NumberUtil.isNumber(taxUnitprice)){
							detailVO.setErrorMsg("含税单价格式不正确！");
							errorsMsgBuilder.append("含税单价格式不正确！");
						}else {
							detailVO.setTaxUnitprice(new BigDecimal(taxUnitprice));
						}
					}

					if (StringUtils.isNotBlank(amounts)) {
						if(!NumberUtil.isNumber(amounts)){
							detailVO.setErrorMsg("除税合价格式不正确！");
							errorsMsgBuilder.append("除税合价格式不正确！");
						}else {
							detailVO.setCurExtaxPrice(new BigDecimal(amounts));
						}
					} else {
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal unitpriceB = detailVO.getUnitprice();
						if(quantityB != null && unitpriceB != null){
							detailVO.setCurExtaxPrice(quantityB.multiply(unitpriceB));
						}
					}

					if (StringUtils.isNotBlank(taxAmounts)) {
						if(!NumberUtil.isNumber(taxAmounts)){
							detailVO.setErrorMsg("含税合价格式不正确！");
							errorsMsgBuilder.append("含税合价格式不正确！");
						}else {
							detailVO.setCurIntaxPrice(new BigDecimal(taxAmounts));
						}
					} else {
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal taxUnitpriceB = detailVO.getTaxUnitprice();
						if(quantityB != null && taxUnitpriceB != null){
							detailVO.setCurIntaxPrice(quantityB.multiply(taxUnitpriceB));
						}
					}
					if (!map1.isEmpty()){
						String key = detailVO.getSubitemName() +
								detailVO.getUnitprice().setScale(2,BigDecimal.ROUND_HALF_UP) +
								detailVO.getTaxUnitprice().setScale(2,BigDecimal.ROUND_HALF_UP);
						ConsultotherfinaldetailVO consultotherfinaldetailVO = map1.get(key);
						if (consultotherfinaldetailVO != null){
							detailVO.setIsEditState("否");
							//代表查到月度计量中往期相关数据
							//往期相关数据
							detailVO.setCumExtaxPrice(consultotherfinaldetailVO.getCumExtaxPrice());
							detailVO.setCumIntaxPrice(consultotherfinaldetailVO.getCumIntaxPrice());
							detailVO.setPastQuantity(consultotherfinaldetailVO.getPastQuantity());
							detailVO.setUnitprice(consultotherfinaldetailVO.getUnitprice());
							detailVO.setTaxUnitprice(consultotherfinaldetailVO.getTaxUnitprice());
							//本期相关数据
							detailVO.setCurExtaxPrice(BigDecimalUtils.ofNullable(detailVO.getQuantity()).multiply(BigDecimalUtils.ofNullable(detailVO.getUnitprice())));
							detailVO.setCurIntaxPrice(BigDecimalUtils.ofNullable(detailVO.getQuantity()).multiply(BigDecimalUtils.ofNullable(detailVO.getTaxUnitprice())));
							//累计相关数据
							detailVO.setCumQuantity(consultotherfinaldetailVO.getPastQuantity().add(detailVO.getQuantity()));
							detailVO.setAmounts(consultotherfinaldetailVO.getCumExtaxPrice().add(detailVO.getCurExtaxPrice()));
							detailVO.setTaxAmounts(consultotherfinaldetailVO.getCumIntaxPrice().add(detailVO.getCurIntaxPrice()));
						}else {
							//代表没查到往期相关数据
							//往期相关数据
							detailVO.setCumExtaxPrice(BigDecimal.ZERO);
							detailVO.setCumIntaxPrice(BigDecimal.ZERO);
							detailVO.setPastQuantity(BigDecimal.ZERO);
							//累计相关数据
							detailVO.setCumQuantity(detailVO.getPastQuantity().add(BigDecimalUtils.ofNullable(detailVO.getQuantity())));
							detailVO.setAmounts(detailVO.getCumExtaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurExtaxPrice())));
							detailVO.setTaxAmounts(detailVO.getCumIntaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurIntaxPrice())));
						}
					}else {
						//代表没查到往期相关数据
						//往期相关数据
						detailVO.setCumExtaxPrice(BigDecimal.ZERO);
						detailVO.setCumIntaxPrice(BigDecimal.ZERO);
						detailVO.setPastQuantity(BigDecimal.ZERO);
						//累计相关数据
						detailVO.setCumQuantity(detailVO.getPastQuantity().add(BigDecimalUtils.ofNullable(detailVO.getQuantity())));
						detailVO.setAmounts(detailVO.getCumExtaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurExtaxPrice())));
						detailVO.setTaxAmounts(detailVO.getCumIntaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurIntaxPrice())));
					}
					if (errorsMsgBuilder.length() > 0) {
						errorList.add(detailVO);
					} else {
						successList.add(detailVO);
					}
				}
			}
		}

		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导入其它扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import3", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response,Long contractId, String date)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ConsultotherfinalodetailVO> successList = new ArrayList<>();
		List<ConsultotherfinalodetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			Map<String, ConsultotherfinalodetailVO> map = service.queryConsultOtherDetailCumPastMap(contractId, date);
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					StringBuilder errorsMsgBuilder = new StringBuilder();
					ConsultotherfinalodetailVO vo = new ConsultotherfinalodetailVO();

					List<String> datas = result.get(i);
					String expenseName = datas.get(0);//费用名称
					String unit = datas.get(1);//单位
					String quantity = datas.get(2);//数量
					String unitPrice = datas.get(3);//除税单价
					String unitTaxPrice = datas.get(4);//含税单价
					String amounts = datas.get(5);//除税金额
					String taxAmounts = datas.get(6);//含税金额
					String remarks = datas.get(7);//备注

					vo.setId(IdWorker.getId());
					vo.setExpenseName(expenseName);
					vo.setUnit(unit);
					vo.setRemarks(remarks);

					//格式校验
					if(StringUtils.isNotBlank(quantity)){
						if(NumberUtil.isNumber(quantity)){
							vo.setoQuantity(new BigDecimal(quantity));
						}else {
							vo.setErrorMsg("数量格式不正确！");
							errorsMsgBuilder.append("数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(unitPrice)){
						if(NumberUtil.isNumber(unitPrice)){
							vo.setoUnitPrice(new BigDecimal(unitPrice));
						}else {
							vo.setErrorMsg("除税单价格式不正确！");
							errorsMsgBuilder.append("除税单价格式不正确！");
						}
					}
					if(StringUtils.isNotBlank(unitTaxPrice)){
						if(NumberUtil.isNumber(unitTaxPrice)){
							vo.setoTaxUnitPrice(new BigDecimal(unitTaxPrice));
						}else {
							vo.setErrorMsg("含税单价格式不正确！");
							errorsMsgBuilder.append("含税单价格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(amounts)){
						if(NumberUtil.isNumber(amounts)){
							vo.setCurExtaxPrice(new BigDecimal(amounts));
						}else {
							vo.setErrorMsg("除税金额格式不正确！");
							errorsMsgBuilder.append("除税金额格式不正确！");
						}
					}else {
						BigDecimal quantityB = vo.getoQuantity();
						BigDecimal unitPriceB = vo.getoUnitPrice();
						if(quantityB != null && unitPriceB != null){
							BigDecimal amountsB = quantityB.multiply(unitPriceB);
							vo.setCurExtaxPrice(amountsB);
						}
					}
					if(StringUtils.isNotBlank(taxAmounts)){
						if(NumberUtil.isNumber(taxAmounts)){
							vo.setCurIntaxPrice(new BigDecimal(taxAmounts));
						}else {
							vo.setErrorMsg("含税金额格式不正确！");
							errorsMsgBuilder.append("含税金额格式不正确！");
						}
					}else {
						BigDecimal quantityB = vo.getoQuantity();
						BigDecimal unitPriceB = vo.getoTaxUnitPrice();
						if(quantityB != null && unitPriceB != null){
							BigDecimal amountsB = quantityB.multiply(unitPriceB);
							vo.setCurIntaxPrice(amountsB);
						}
					}
					if (!map.isEmpty()){
						String key = vo.getExpenseName() + vo.getoUnitPrice().setScale(2,BigDecimal.ROUND_HALF_UP) +
								vo.getoTaxUnitPrice().setScale(2,BigDecimal.ROUND_HALF_UP);
						ConsultotherfinalodetailVO consultotherfinalodetailVO = map.get(key);
						if (consultotherfinalodetailVO != null){
							vo.setIsEditState("否");
							//代表查到了月度计量的往期数据
							//往期相关数据
							vo.setCumExtaxPrice(consultotherfinalodetailVO.getCumExtaxPrice());
							vo.setCumIntaxPrice(consultotherfinalodetailVO.getCumIntaxPrice());
							vo.setoTaxUnitPrice(consultotherfinalodetailVO.getoTaxUnitPrice());
							vo.setoUnitPrice(consultotherfinalodetailVO.getoUnitPrice());
							vo.setPastQuantity(consultotherfinalodetailVO.getPastQuantity());
							//本期相关数据
							vo.setCurExtaxPrice(BigDecimalUtils.ofNullable(vo.getoQuantity()).multiply(BigDecimalUtils.ofNullable(vo.getoUnitPrice())));
							vo.setCurIntaxPrice(BigDecimalUtils.ofNullable(vo.getoQuantity()).multiply(BigDecimalUtils.ofNullable(vo.getoTaxUnitPrice())));
							//累计相关数量
							vo.setCumQuantity(consultotherfinalodetailVO.getPastQuantity().add(vo.getoQuantity()));
							vo.setAmounts(consultotherfinalodetailVO.getCumExtaxPrice().add(vo.getCurExtaxPrice()));
							vo.setTaxAmounts(consultotherfinalodetailVO.getCumIntaxPrice().add(vo.getCurIntaxPrice()));
						}else {
						//	代表没查到月度计量的往期数据
							//往期相关数据
							vo.setCumExtaxPrice(BigDecimal.ZERO);
							vo.setCumIntaxPrice(BigDecimal.ZERO);
							vo.setPastQuantity(BigDecimal.ZERO);
							//累计相关数量
							vo.setCumQuantity(vo.getPastQuantity().add(vo.getoQuantity()));
							vo.setAmounts(vo.getCumExtaxPrice().add(vo.getCurExtaxPrice()));
							vo.setTaxAmounts(vo.getCumIntaxPrice().add(vo.getCurIntaxPrice()));
						}
					}else {
						//	代表没查到月度计量的往期数据
						//往期相关数据
						vo.setCumExtaxPrice(BigDecimal.ZERO);
						vo.setCumIntaxPrice(BigDecimal.ZERO);
						vo.setPastQuantity(BigDecimal.ZERO);
						//累计相关数量
						vo.setCumQuantity(vo.getPastQuantity().add(vo.getoQuantity()));
						vo.setAmounts(vo.getCumExtaxPrice().add(vo.getCurExtaxPrice()));
						vo.setTaxAmounts(vo.getCumIntaxPrice().add(vo.getCurIntaxPrice()));
					}
					if (errorsMsgBuilder.length() > 0) {
						errorList.add(vo);
					} else {
						successList.add(vo);
					}
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export", method = RequestMethod.POST)
	@ResponseBody
	public void export(@RequestBody ConsultotherfinalVO consultotherfinalVO, HttpServletResponse response) {
		QueryWrapper<ConsultotherfinaldetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", consultotherfinalVO.getId());
		queryWrapper.eq("dr", 0);
		List<ConsultotherfinaldetailEntity> list = consultotherfinaldetailService.list(queryWrapper);
		List<ConsultotherfinaldetailVO> voList = BeanMapper.mapList(list, ConsultotherfinaldetailVO.class);
		List<ConsultotherfinaldetailVO> records = new ArrayList<>();

		for(ConsultotherfinaldetailVO vo : voList){
			records.add(vo);
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("consultotherfinaldetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage(@RequestBody List<ConsultotherfinaldetailVO> list, HttpServletResponse response) {
		List<ConsultotherfinaldetailVO> records = new ArrayList<>();
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				ConsultotherfinaldetailVO vo = list.get(i);
				String source = vo.getSource();
				if("1".equals(source)){//来源：1合同内 2合同外
					source = "合同内";
				}else if("2".equals(source)){
					source = "合同外";
				}
				vo.setSource(source);
				records.add(vo);
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("consultotherfinaldetail-export.xlsx", beans, response);
	}


	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export3", method = RequestMethod.POST)
	@ResponseBody
	public void export3(@RequestBody ConsultotherfinalVO vo, HttpServletResponse response) {
		QueryWrapper<ConsultotherfinalodetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<ConsultotherfinalodetailEntity> list = consultotherfinalodetailService.list(queryWrapper);
		List<ConsultotherfinalodetailVO> vOList = BeanMapper.mapList(list, ConsultotherfinalodetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				ConsultotherfinalodetailVO linevo = vOList.get(i);
				linevo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("consultotherfinalodetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage3", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage3(@RequestBody List<ConsultotherfinalodetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				ConsultotherfinalodetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("consultotherfinalodetail-export.xlsx", beans, response);
	}
}
