package com.ejianc.business.settlementmanage.service;

import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 工程分包结算书子表-支出明细-其它
 * 
 * @author generator
 * 
 */
public interface ISettlementBookOtherDetailService extends IBaseService<SettlementBookOtherDetailEntity> {
    /**
     * 根据合同id查询分包月度报量及申请报告的其他扣款数据
     * 并将查询到的数据组装成编码+区段+除税单价+含税单价为key的map数据方便比对哪些数据是从分包月度报量带过来的
     * @param contractId
     * @return
     */
    Map<String, SettlementBookOtherDetailVO> querySubcontractingvolumeOtherByContractId(Long contractId);

    /**
     * 汇总其他扣款子表的含税金额和除税金额
     * @param list
     * @return
     */
    Map<String, BigDecimal> totalForm(List<SettlementBookOtherDetailEntity> list);
}
